package com.viontech.mall.report.base;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.util.DateUtil;
import com.viontech.keliu.util.NumberUtil;
import com.viontech.mall.model.*;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.DataVo;
import com.viontech.mall.report.model.ReportVo;
import com.viontech.mall.report.service.adapter.*;
import com.viontech.mall.service.adapter.BrandService;
import com.viontech.mall.service.adapter.ConfigParamsService;
import com.viontech.mall.service.adapter.FormatService;
import com.viontech.mall.service.adapter.ReportChartService;

import javax.annotation.Resource;
import java.util.*;

public abstract class ChartReportBaseService {
	@Resource 
	private ReportChartService reportChartService;
	
	@Resource
	private FormatService formatService;
	
	@Resource
	private BrandService brandService;

	@Resource
	private ConfigParamsService configParamsService;

	@Resource
	private GateReportDataService gateReportDataService;

	@Resource
	private ZoneReportDataService zoneReportDataService;
	
	@Resource
	private FloorReportDataService floorReportDataService;
	
	@Resource
	private MallReportDataService mallReportDataService;

	@Resource
	private MallDataService mallDataService;


	
	/**布局报表信息*/
	public static  final String CHART_DETAIL_DATA = "detailChart";
	/**省份客流信息*/
	public static  final String CHART_TRAFFIC_DATA = "trafficChart";
	
	/**业态列表信息*/
	public static final String KEY_FORMAT_ALL ="allFormat";
	/**品牌列表信息*/
	public static final String KEY_BRAND_ALL="allBrand";
	/**有效客流人数*/
	public static final String KEY_ENABLE_TRAFFIC="enableTraffic";
	/**系统参数*/
	public static final String KEY_CONFIG_PARAMS="configParams";

	/**默认查询数据天数 30天*/
	public static  final int PARAM_DEFAULT_BEFOREDAY30 = -29;
	/**默认查询数据天数 15天*/
	public static  final int PARAM_DEFAULT_BEFOREDAY15 = -14;
	/**近3周日期*/
	public static  final int PARAM_DEFAULT_BEFOREDAY21 = -20;
	/**近8周日期*/
	public static  final int PARAM_DEFAULT_BEFOREDAY56 = -55;
	/** 商场开业状态 */
	public static final int PARAM_MALL_STATUS_OPEN = 1;
	/** 是否是商场的出入口 */
	public static final short PARAM_IS_MALL_GATE = 1;
	/**监控点   有人脸相机*/
	public static final short PARAM_GATE_HAS_FACE = 1;
	/**进店率参数配置 */
	public static final String PARAM_ENTERRATE_CONFIG = "enterRateConfig";
	/**店外客流参数配置 */
	public static final String PARAM_PASSTRAFFIC_CONFIG = "passTrafficConfig";
	/**有效客流参数配置 */
	public static final String PARAM_ENABLE_TRAFFIC_CONFIG = "enableTrafficConfig";

	public ReportVo getReport(Long[] orgIds,Date startDate,Date endDate,Long[] chartIds, Map<String, Object> dataMap) {
		ReportVo report = new ReportVo();
		Map<String,Object> head = getHead(orgIds, startDate, endDate ,dataMap);
		report.setHead(head);
		Map<String, Chart> body = getBody(orgIds, startDate, endDate, dataMap, chartIds);
		report.setBody(body);
		return report;
	}
	
	public abstract Map<String,Object> getHead(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap) ;
	


	/**
	 * 查询图表
	 * @return
	 */

	public abstract Chart getChart(Long[] orgIds,  Date startDate, Date endDate, Map<String, Object> dataMap, ReportChart reportChart);


	/**
	 * 日报(包含表头、各种图表)
	 * @return
	 */

	public Map<String,Chart> getBody(Long[] orgIds, Date startDate, Date endDate, Map<String, Object> dataMap, Long[] chartIds) {
		Map<String, Chart> bodyMap = new HashMap<String, Chart>();
		ReportChartExample reportChartExample = new ReportChartExample();
		reportChartExample.createCriteria().andIdIn(Arrays.asList(chartIds));
		List<ReportChart> reportCharts = reportChartService.selectByExample(reportChartExample);
		if(dataMap == null){
			dataMap = new HashMap<>();
		}
		for (ReportChart reportChart : reportCharts) {
			Chart chart = getChart(orgIds, startDate, endDate, dataMap, reportChart);
			if(chart != null){
				chart.removeChartHideCol();//移除指定的列
			}
			bodyMap.put(reportChart.getKey(), chart);
		}
		return bodyMap;
	}
	
	/**获取业态列表*/
	public Map getOrQueryFormats(Map<String, Object> dataMap){
		Map datas =(Map) dataMap.get(KEY_FORMAT_ALL);
		if (datas==null ) {
			datas = new HashMap<Long, Format>();
			FormatExample formatExample = new FormatExample();
			formatExample.createColumns().hasIdColumn().hasNameColumn();
			List<Format> formats = formatService.selectByExample(formatExample);
			if (formats != null) {
				for (Format format : formats) {
					datas.put(format.getId(), format);
				}
				dataMap.put(KEY_FORMAT_ALL, datas);
			}
		}
		return datas;
	}
	
	/**根据id获取业态*/
	public Format getOrQueryFormatById(Long formatId,Map<String, Object> dataMap){
		Map datas = getOrQueryFormats(dataMap);
		return (Format) datas.get(formatId);
	}
	
	/**获取品牌列表*/
	public Map<Long,Brand> getOrQueryBrand(Map<String, Object> dataMap){
		Map<Long,Brand> datas = (Map) dataMap.get(KEY_BRAND_ALL);
		if (datas == null) {
			datas = new HashMap<Long, Brand>();
			List<Brand> brands = new ArrayList<Brand>();
			BrandExample brandExample = new BrandExample();
			brandExample.createColumns().hasIdColumn().hasNameColumn();
			brands = brandService.selectByExample(brandExample);
			for (Brand brand : brands) {
				datas.put(brand.getId(), brand);
			}
			dataMap.put(KEY_BRAND_ALL, datas);
		}
		return datas;
	}
	
	/**根据id获取品牌名称*/
	public Brand getOrQueryBrandById(Long brandId,Map<String, Object> dataMap){
		Map<Long,Brand> datas = getOrQueryBrand(dataMap);
		return datas.get(brandId);
	}

	/**根据机构Id获取对应机构的面积*/
	public Float getOrgArea(Long orgId,Map<String, Object> dataMap) {
		Float area = null;
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		if (orgType == OrgType.zone) {
			Zone zone  = zoneReportDataService.getOrQueryZoneById(orgId, dataMap);
			if (zone != null ) {
				area = zone.getArea();
			}
		}else if(orgType == OrgType.floor){
			Floor floor = floorReportDataService.getFloorInfoById(orgId, dataMap);
			if (floor != null) {
			}
		}else if (orgType == OrgType.mall) {
			Mall mall = mallReportDataService.getMallByMallId(orgId, dataMap);
			if (mall != null) {
				area = mall.getArea();
			}
		}
		return area;
	}

	/**
	 * 获取数据中的组织机构名称
	 * @param dataVo
	 * @param dataMap
	 * @return
	 */
	public String getOrgName(DataVo dataVo,Map<String, Object> dataMap) {
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		Long orgId =  getOrgIdFromDataVo(orgType, dataVo);
		String orgName =getOrgNameById(orgId,orgType,dataMap);
		return orgName;
	}

	public String getOrgNameById(Long orgId,OrgType orgType,Map<String, Object> dataMap) {
		String orgName = null;
		if (orgType == null)
			 orgType = (OrgType) dataMap.get("ORGTYPE");
		if (orgType == OrgType.gate) {
			Gate gate = gateReportDataService.getGateInfoById(orgId, dataMap);
			if (gate != null)
				orgName = gate.getName();
		}else if (orgType == OrgType.zone) {
			Zone zone = zoneReportDataService.getOrQueryZoneById(orgId, dataMap);
			if (zone != null)
				orgName = zone.getName();
		}else if (orgType == OrgType.floor) {
			Floor floor = floorReportDataService.getFloorInfoById(orgId, dataMap);
			if (floor != null)
				orgName = floor.getName();
		}else if (orgType == OrgType.mall) {
			Mall mall = mallReportDataService.getMallByMallId(orgId, dataMap);
			if (mall != null)
				orgName = mall.getName();
		}
		return orgName;
	}



	public BaseDataServiceImpl.DateCriteria getMallOpenTime(Map<String, Object> dataMap, OrgType orgType, DataVo dataVot) {
		Long orgId = getOrgIdFromDataVo(orgType, dataVot);
		BaseDataServiceImpl.DateCriteria dateCriteria = getMallOpenTime(dataMap,orgType,orgId);
		return dateCriteria;
	}

	private Long getOrgIdFromDataVo(OrgType orgType, DataVo dataVot) {
		Long orgId = null;
		if (orgType == OrgType.gate) {
			orgId = dataVot.getGateId();
		}else if (orgType == OrgType.zone) {
			orgId = dataVot.getZoneId();
		}else if (orgType == OrgType.floor) {
			orgId = dataVot.getFloorId();
		}else if (orgType == OrgType.mall) {
			orgId = dataVot.getMallId();
		}
		return orgId;
	}

	public BaseDataServiceImpl.DateCriteria getMallOpenTime(Map<String, Object> dataMap, OrgType orgType, Long orgId) {
		if (orgType == null)
			orgType = (OrgType) dataMap.get("ORGTYPE");
		BaseDataServiceImpl.DateCriteria dateCriteria = new BaseDataServiceImpl.DateCriteria();
		if (orgType == OrgType.gate) {
			dateCriteria = gateReportDataService.getMallOpentimesByOrgId(orgId, OrgType.gate, dataMap);
		}else if (orgType == OrgType.zone) {
			dateCriteria = zoneReportDataService.getMallOpentimesByOrgId(orgId, OrgType.zone, dataMap);
		}else if (orgType == OrgType.floor) {
			dateCriteria = floorReportDataService.getMallOpentimesByOrgId(orgId, OrgType.floor, dataMap);
		}else if (orgType == OrgType.mall) {
			dateCriteria = mallReportDataService.getMallOpentimesByOrgId(orgId, OrgType.mall, dataMap);
		}
		return dateCriteria;
	}

	/**
	 * 获取商场的系统设置选项
	 * @param MallId
	 * @param dataMap
	 * @return
	 */
	public Map<String,ConfigParams> getConfigParamsByMallId(Long MallId,Map<String, Object> dataMap){
		Map<String,ConfigParams> configParamsMap = (Map<String, ConfigParams>) dataMap.get(KEY_CONFIG_PARAMS);
		if (configParamsMap == null){
			configParamsMap = new HashMap<>();
			List<ConfigParams> paramsList = configParamsService.ConfigParamsByMallId(MallId);
			for (ConfigParams configParams : paramsList) {
				configParamsMap.put(configParams.getKey(),configParams);
			}
			dataMap.put(KEY_CONFIG_PARAMS,configParamsMap);
		}
		return configParamsMap;
	}

	/**
	 * 获取对象的小时级有效客流人数
	 * @param dataMap
	 * @return
	 */
	public Number  getHourEnableTraffic(Long mallId,Date date,Map<String, Object> dataMap){
		String format_Date = DateUtil.format(DateUtil.FORMAT_YYYY_MM_DD_HH, date);
		String key = KEY_ENABLE_TRAFFIC + "_" + mallId + "_" + format_Date;
		Number enableTraffic = (Number) dataMap.get(key);
		if (enableTraffic == null){
			List<MallHourFaceRecognitionSta> faceData = (List<MallHourFaceRecognitionSta>) mallDataService.getFaceHourData(date,mallId);
			if (faceData != null && faceData.size() >0){
				MallHourFaceRecognitionSta mallHourFaceRecognitionSta = faceData.get(0);
				//判断有效人数是否为严格模式
				Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(mallId, dataMap);
				ConfigParams configParams = configParamsMap.get(PARAM_ENABLE_TRAFFIC_CONFIG);
				boolean isStrict = false;
				if (configParams != null){
					String value = configParams.getValue();
					isStrict = "1".equals(value)?true:false;
				}
				if (isStrict){
					enableTraffic =mallHourFaceRecognitionSta.getMaleCount()+mallHourFaceRecognitionSta.getFemaleCount();
				}else {
					enableTraffic = mallHourFaceRecognitionSta.getCustomCount();
				}
			}else
				enableTraffic = 0;
			dataMap.put(key,enableTraffic);
		}
		return enableTraffic;
	}

	/**
	 *获取对象的天级有效客流人数
	 * @param dataMap
	 * @return
	 */
	public Number getEnableTraffic(Long mallId,Date date,Map<String, Object> dataMap){
		String format_Date = DateUtil.format(DateUtil.FORMAT_SHORT, date);
		String key = KEY_ENABLE_TRAFFIC + "_" + mallId + "_" + format_Date;
		Number enableTraffic = (Number) dataMap.get(key);
		if (enableTraffic == null){
			List<MallDayFaceRecognitionSta> faceData = (List<MallDayFaceRecognitionSta>) mallDataService.getFaceDayData(date,mallId);
			if (faceData != null && faceData.size() >0){
				MallDayFaceRecognitionSta mallDayFaceRecognitionSta = faceData.get(0);
				//判断有效人数是否为严格模式
				Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(mallId, dataMap);
				ConfigParams configParams = configParamsMap.get(PARAM_ENABLE_TRAFFIC_CONFIG);
				boolean isStrict = false;
				if (configParams != null){
					String value = configParams.getValue();
					isStrict = "1".equals(value)?true:false;
				}
				if (isStrict){
					enableTraffic =mallDayFaceRecognitionSta.getMaleCount()+mallDayFaceRecognitionSta.getFemaleCount();
				}else {
					enableTraffic = mallDayFaceRecognitionSta.getCustomCount();
				}
			}else
				enableTraffic = 0;
			dataMap.put(key,enableTraffic);
		}
		return enableTraffic;
	}

	/***
	 * 根据kpi计算结果值
	 * @param dataVo
	 * @param dataVos
	 * @param dataMap
	 * @return
	 */
	public Number getKpiResult(DataVo dataVo,List<DataVo> dataVos,Map<String, Object> dataMap,KPIType kpiType) {
		OrgType orgType = (OrgType) dataMap.get("ORGTYPE");
		//该条数据的数据类型
		int dataType = dataVo.getDataType();
		Number result = null;
		if (kpiType == KPIType.TRAFFIC && dataType != 3) {
				result =  dataVo.getInnum();
		}else if ( kpiType == kpiType.SALES) {
			if (dataType == 3) 
				result = dataVo.getMoney();
		}else if (kpiType == KPIType.ENTERINGRATE && orgType == OrgType.mall && dataType != 3) {
			Long mallId = dataVo.getMallId();
			Date date = dataVo.getDate();
			if (mallId == null || date == null) {
				return  0;
			}
			//获取进店人数
			Number enableTraffic = 0;
			//获取进店率的系统配置
			Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(mallId, dataMap);
			ConfigParams innumConfigParams = configParamsMap.get(PARAM_ENTERRATE_CONFIG);
			String choseFlag = Optional.ofNullable(innumConfigParams.getValue()).orElse("0");
			enableTraffic = getTrafficByConfig(dataVo, dataMap, dataType, mallId, date, choseFlag);
			//获取店外人数
			int passNum = 0;
			ConfigParams passNumConfigParams = configParamsMap.get(PARAM_PASSTRAFFIC_CONFIG);
			String passNumFlag = Optional.ofNullable(passNumConfigParams.getValue()).orElse("0");
			//根据有效客流计算进店率
			if ("1".equals(passNumFlag) ){
				passNum = dataVo.getPassInnum()+dataVo.getPassOutnum()+dataVo.getInnum();
			}else {
				passNum = dataVo.getPassInnum()+dataVo.getPassOutnum();
			}
			result = NumberUtil.percentage(enableTraffic, passNum, 2);

		}else if (kpiType == KPIType.PREPRICE  && dataType == 3) {
			result = NumberUtil.divide(dataVo.getMoney(), dataVo.getSaleCount(), 2);
		}else if (kpiType == KPIType.PERAREAVALUE  && dataType == 3) {
			Long orgId = null;
			if (orgType == OrgType.zone) {
				orgId = dataVo.getZoneId();
			}else if (orgType == OrgType.mall) {
				orgId = dataVo.getMallId();
			}
			float area = getOrgArea(orgId, dataMap);
			result = NumberUtil.divide(dataVo.getMoney(), area, 2);
		}else if (kpiType == KPIType.ORDER && dataType == 3) {
			result = dataVo.getSaleCount();
		}else if (kpiType == KPIType.HANDBAGRATE && dataType == 2 ) {
			Integer saleCount = null;
			Date dataDate = dataVo.getDate();
			//循环查找 当前时间的的销售数据
			for(DataVo dataVo1 : dataVos){
				int dataType1 = dataVo1.getDataType();
				if (dataType1 == 3) {
					if (dataDate.equals(dataVo1.getDate())) {
						saleCount = dataVo1.getSaleCount();
					}
				}
			}
			result = NumberUtil.percentage(saleCount, dataVo.getInnum(), 2);
		}else if (kpiType == KPIType.DURATIONTIME && dataType == 2 ) {
			Integer hourTraffic = 0;
			//获取当前日期
			Date dataDate = dataVo.getDate();
			//循环查找 当前时间的的数据
			for (DataVo dataVo1 : dataVos){
				int dataType1 = dataVo1.getDataType();
				if (dataType1 != 1)
					continue;
				if (dataDate.equals(dataVo1.getDate())) {
					hourTraffic += dataVo1.getInnum();
				}
			}
			result = NumberUtil.divide(hourTraffic, dataVo.getInnum(), 2);
		}else if(kpiType == KPIType.INNUM  && dataType != 3){
			result = dataVo.getInnum();
		}else if(kpiType == KPIType.OUTNUM  && dataType != 3){
			result = dataVo.getOutnum();
		}else if(kpiType == KPIType.PASSTRAFFIC  && dataType != 3){
			Long mallId = dataVo.getMallId();
			Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(mallId, dataMap);
			ConfigParams configParams = configParamsMap.get(PARAM_PASSTRAFFIC_CONFIG);
			String choseFlag = Optional.ofNullable(configParams.getValue()).orElse("0");
			//根据有效客流计算进店率
			if ("1".equals(choseFlag) ){
				result = dataVo.getPassInnum()+dataVo.getPassOutnum()+dataVo.getInnum();
			}else {
				result = dataVo.getPassInnum()+dataVo.getPassOutnum();
			}
		}else if(kpiType == KPIType.EFFECTIVETRAFFIC  && dataType != 3){
			Long mallId = dataVo.getMallId();
			Date date = dataVo.getDate();
			if (mallId == null || date == null) {
				return  0;
			}
			Map<String, ConfigParams> configParamsMap = getConfigParamsByMallId(mallId, dataMap);
			ConfigParams innumConfigParams = configParamsMap.get(PARAM_ENTERRATE_CONFIG);
			String choseFlag = Optional.ofNullable(innumConfigParams.getValue()).orElse("0");
			result = getTrafficByConfig(dataVo, dataMap, dataType, mallId, date, choseFlag);
		}else if(kpiType == KPIType.DURATIONNUM  && dataType != 3){
			int value = dataVo.getInnum() - dataVo.getOutnum();
			result = value < 0 ? 0 : value;
		}else if(kpiType == KPIType.ZONENUM ){
			if (orgType == OrgType.floor) {
				Long floorId = dataVo.getFloorId();
				List<Zone> zoneOfFloor = floorReportDataService.getZoneOfFloor(floorId, dataMap);
				result = zoneOfFloor.size();
			}else if (orgType == OrgType.mall) {
				Long mallId = dataVo.getMallId();
				List<Zone> zonesOfMall = mallReportDataService.getOrQueryZonesOfMallId(mallId, dataMap);
				result = zonesOfMall.size();
			}
			return result;
		}
		return result;
	}

	/**
	 * 根据参数表的配置获取客流量数据
	 * @param dataVo
	 * @param dataMap
	 * @param dataType
	 * @param mallId
	 * @param date
	 * @param choseFlag
	 * @return
	 */
	private Number getTrafficByConfig(DataVo dataVo, Map<String, Object> dataMap, int dataType, Long mallId, Date date, String choseFlag) {
		Number result;
		if ("1".equals(choseFlag) && dataType == 2){
			result = getEnableTraffic(mallId, date, dataMap);
		}else if ("1".equals(choseFlag) && dataType == 1){
			date = dataVo.getTime();
			result = getHourEnableTraffic(mallId, date, dataMap);
		}else {
			result  = Optional.ofNullable(dataVo.getInnum()).orElse(0);
		}
		return result;
	}


}
