package com.viontech.mall.report.base;

import com.viontech.keliu.chart.Chart;
import com.viontech.keliu.chart.excel.ChartExcel;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.util.FileUtil;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.mall.model.ReportChart;
import com.viontech.mall.model.Zone;
import com.viontech.mall.model.ZoneExample;
import com.viontech.mall.model.ZoneExample.Criteria;
import com.viontech.mall.report.enums.KPIType;
import com.viontech.mall.report.enums.OptionsContain;
import com.viontech.mall.report.enums.OrgType;
import com.viontech.mall.report.model.ParamModel;
import com.viontech.mall.report.model.ReportVo;
import com.viontech.mall.service.adapter.ReportChartService;
import com.viontech.mall.service.adapter.ZoneService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.*;

public abstract class ChartReportBaseController  {

	Logger logger = LoggerFactory.getLogger(this.getClass());
	
	@Resource 
	private ReportChartService reportChartService;
	
	@Resource
	private ZoneService zoneService;

	/**
	 * 月报表头
	 * 
	 * @return
	 */
	@GetMapping("")
	@ResponseBody
	public Object report(@PathVariable OrgType orgType,ParamModel params) {
		Object message = validatParam(params);
		if(message!= null)
			return message;
		Map<String,Object> dataMap = new HashMap<String, Object>();
		params.setOrgType(orgType);
		params = putParamToDataMap(params, dataMap);
		ReportVo  reportVo = getReportService(orgType).getReport(params.getOrgIds(), params.getStartDate(), 
				params.getEndDate(),params.getChartIds(),dataMap);
		return JsonMessageUtil.getSuccessJsonMsg(reportVo);
	}

	@GetMapping("/head")
	@ResponseBody
	public Object head(@PathVariable OrgType orgType,ParamModel params) {
		Object message = validatParam(params);
		if(message!= null)
			return message;
		Map<String,Object> dataMap = new HashMap<String, Object>();
		params.setOrgType(orgType);
		params = putParamToDataMap(params, dataMap);
		Map<String,Object> headMap = getReportService(orgType).getHead(params.getOrgIds(),
				params.getStartDate(),params.getEndDate(), dataMap);
		return JsonMessageUtil.getSuccessJsonMsg(headMap);
	}

	/**
	 * 查询图表
	 * 
	 * @return
	 */
	@GetMapping("/{chartId}")
	@ResponseBody
	public Object chart(@PathVariable OrgType orgType,@PathVariable Long chartId,ParamModel params) {
		params.setChartIds(new Long[]{chartId});
		Object message = validatParam(params);
		if(message!= null)
			return message;
		Map<String,Object> dataMap = new HashMap<String, Object>();
		params.setOrgType(orgType);
		params = putParamToDataMap(params, dataMap);
		ReportChart reportChart = reportChartService.selectByPrimaryKey(chartId);
		Chart chart = getReportService(orgType).getChart(params.getOrgIds(),params.getStartDate(),params.getEndDate(), dataMap, reportChart);
		return JsonMessageUtil.getSuccessJsonMsg(chart);
	}
	/**
	 * 导出报表数据为Excel格式
	 * @param orgType
	 * @param chartId
	 * @param params
	 * @param request
	 * @param response
	 * @return
	 */
	@SuppressWarnings("rawtypes")
	@GetMapping("/{chartId}/excel")
	public Object exportData(@PathVariable OrgType orgType,@PathVariable Long chartId,ParamModel params,HttpServletRequest request, HttpServletResponse response) {
		Object message = validatParam(params);
		if(message!= null)
			return message;
		Map<String,Object> dataMap = new HashMap<String, Object>();
		params.setOrgType(orgType);
		params = putParamToDataMap(params, dataMap);
		ReportChart reportChart = reportChartService.selectByPrimaryKey(chartId);
		String localLanguage = params.getLocalLanguage();
		if (localLanguage != null && !localLanguage.isEmpty())
			LocalMessageUtil.setDefaultLanguage(localLanguage);
		Chart chart = getReportService(orgType).getChart(params.getOrgIds(),params.getStartDate(),params.getEndDate(), dataMap, reportChart);
		ChartExcel excel = new ChartExcel(chart);
		String fileName = reportChart.getTitle()+".xls";
		InputStream dataStream = excel.creatExcelInputStream();
		
		try {
			return FileUtil.downfile(fileName,dataStream, request, response);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return null;
	}
	

	/**
	 * 日报(包含表头、各种图表)
	 * @return
	 */
	@GetMapping("/body")
	@ResponseBody
	public Object body(@PathVariable OrgType orgType,ParamModel params) {
		Object message = validatParam(params);
		if(message!= null)
			return message;
		Map<String,Object> dataMap = new HashMap<String, Object>();
		params.setOrgType(orgType);
		params = putParamToDataMap(params, dataMap);
		Map<String,Chart> bodyMap = getReportService(orgType).getBody(params.getOrgIds(), params.getStartDate(),
				params.getEndDate(), dataMap, params.getChartIds());
		return JsonMessageUtil.getSuccessJsonMsg(bodyMap);
	}
	
	
	
	/**
	 * 对传递参数进行验证
	 * @param params
	 * @return
	 */
	private Object validatParam(ParamModel params){
		Long[] orgIds = params.getOrgIds(); 
		if(orgIds == null || orgIds.length == 0)
			return JsonMessageUtil.getErrorJsonMsg(LocalMessageUtil.getMessage("Message.orgIdIsNull"));
		return null;
	}
	/**
	 * 将参数放入Map容器中，方便业务获取必要的数据
	 * @param params
	 * @param dataMap
	 * @return
	 */
	private ParamModel putParamToDataMap(ParamModel params,Map<String,Object> dataMap){
		OrgType orgType = params.getOrgType();
		if(orgType != null){
			dataMap.put("ORGTYPE", orgType);
		}
		KPIType kpiType = params.getKpiType();
		if(kpiType != null){
			dataMap.put("KPITYPE", kpiType);
		}
		List<KPIType> kpiTypes = params.getKpiTypes();
		if(kpiTypes != null){
			dataMap.put("KPITYPES", kpiTypes);
		}
		Date date = params.getDate();
		if(date != null){
			params.setStartDate(date);
		}
		if (params.getStartDate1() != null) {
			dataMap.put("startDate1", params.getStartDate1());
			dataMap.put("endDate1", params.getEndDate1());
		}
		String holidayEventId = params.getHolidayEventId();
		if(holidayEventId != null){
			dataMap.put("holidayEventId", holidayEventId);
		}
		OptionsContain option = params.getOption();
		if(option != null){
			dataMap.put("chartOption", option);
		}
		String residenceStage = params.getResidenceStage();
		if(residenceStage != null){
			dataMap.put("residenceStage",residenceStage);
		}

		Long[] formats = params.getFormats();
		if (formats != null) {
			dataMap.put("FORMATS", formats);
			ZoneExample zoneExample = new ZoneExample();
			Criteria criteria = zoneExample.createCriteria();
			criteria.andFormatIdIn((List<Long>) dataMap.get("FORMATS"));
			Long[] orgIds = params.getOrgIds();
			if(orgType == OrgType.account){
				criteria.andAccountIdIn(Arrays.asList(orgIds));
			}else if(orgType == OrgType.mall){
				criteria.andMallIdIn(Arrays.asList(orgIds));
			}else if(orgType == OrgType.floor){
				criteria.andFloorIdIn(Arrays.asList(orgIds));
			}
			List<Zone> zones = zoneService.selectByExample(zoneExample);
			orgType = OrgType.zone;
			List<Long> zoneIds = new ArrayList<Long>();
			for (Zone zone : zones) {
				zoneIds.add(zone.getId());
			}
			orgIds = (Long[]) zoneIds.toArray();
			params.setOrgType(orgType);
			params.setOrgIds(orgIds);
		}
		return params;
	}
	

	public abstract ChartReportBaseService getReportService(OrgType orgType);
}
