package com.viontech.mall.report.base;

import com.viontech.keliu.base.BaseModel;
import com.viontech.keliu.util.DateUtil;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public abstract class BaseDataServiceImpl implements BaseDataService {
	
	public abstract List<? extends BaseModel> getMinuteData(List<Date> dates,List<Long> ids);
	
	public List<? extends BaseModel> getMinuteData(Date date,List<Long> ids){
		return this.getMinuteData(Arrays.asList(date),ids);
	}
	public List<? extends BaseModel> getMinuteData(Date date, Long id){
		return this.getMinuteData(Arrays.asList(date),Arrays.asList(id));
	}
	public List<? extends BaseModel> getMinuteData(List<Date> dates, Long id){
		return this.getMinuteData(dates,Arrays.asList(id));
	}
	public abstract List<? extends BaseModel> getHourData(List<Date> dates,List<Long> ids);
	
	public List<? extends BaseModel> getHourData(Date date,List<Long> ids){
		return this.getHourData(Arrays.asList(date),ids);
	}
	public List<? extends BaseModel> getHourData(Date date, Long id){
		return this.getHourData(Arrays.asList(date),Arrays.asList(id));
	}
	public List<? extends BaseModel> getHourData(List<Date> dates, Long id){
		return this.getHourData(dates,Arrays.asList(id));
	}
	
	public abstract List<? extends BaseModel> getDaysData(List<DateCriteria> dates,List<Long> ids);
	public abstract List<? extends BaseModel> getDayData(List<Date> dates,List<Long> ids);
	
	public  List<? extends BaseModel> getDayData(Date start,Date end,List<Long> ids){
		DateCriteria dateCriteria = new DateCriteria();
		dateCriteria.setStartDate(start);
		dateCriteria.setEndDate(end);
		List<DateCriteria> dateCriterias = new ArrayList<BaseDataServiceImpl.DateCriteria>();
		dateCriterias.add(dateCriteria);
		return this.getDaysData(dateCriterias, ids);
	}
	public List<? extends BaseModel> getDayData(Date date,List<Long> ids){
		return this.getDayData(Arrays.asList(date),ids);
	}
	public List<? extends BaseModel> getDayData(Date date, Long id){
		return this.getDayData(Arrays.asList(date),Arrays.asList(id));
	}
	public List<? extends BaseModel> getDayData(List<Date> dates, Long id){
		return this.getDayData(dates,Arrays.asList(id));
	}
	public  List<? extends BaseModel> getDayData(Date start,Date end,Long id){
		return this.getDayData(start, end, Arrays.asList(id));
	}
	
	public abstract List<? extends BaseModel> getFaceDaysData(List<DateCriteria> dates, List<Long> ids);
	public abstract List<? extends BaseModel> getFaceDayData(List<Date> dates, List<Long> ids);
	
	public  List<? extends BaseModel> getFaceDayData(Date start, Date end, List<Long> ids){
		DateCriteria dateCriteria = new DateCriteria();
		dateCriteria.setStartDate(start);
		dateCriteria.setEndDate(end);
		List<DateCriteria> dateCriterias = new ArrayList<BaseDataServiceImpl.DateCriteria>();
		dateCriterias.add(dateCriteria);
		return this.getFaceDaysData(dateCriterias, ids);
	}
	public List<? extends BaseModel> getFaceDayData(Date date, List<Long> ids){
		return this.getFaceDayData(Arrays.asList(date),ids);
	}
	public List<? extends BaseModel> getFaceDayData(Date date, Long id){
		return this.getFaceDayData(Arrays.asList(date),Arrays.asList(id));
	}
	public List<? extends BaseModel> getFaceDayData(List<Date> dates, Long id){
		return this.getFaceDayData(dates,Arrays.asList(id));
	}
	public  List<? extends BaseModel> getFaceDayData(Date start, Date end, Long id){
		return this.getFaceDayData(start, end, Arrays.asList(id));
	}

	public abstract List<? extends BaseModel> getFaceHourData(List<Date> dates, List<Long> ids);

	public List<? extends BaseModel> getFaceHourData(Date date, List<Long> ids){
		return this.getFaceHourData(Arrays.asList(date),ids);
	}
	public List<? extends BaseModel> getFaceHourData(Date date, Long id){
		return this.getFaceHourData(Arrays.asList(date),Arrays.asList(id));
	}
	public List<? extends BaseModel> getFaceHourData(List<Date> dates, Long id){
		return this.getFaceHourData(dates,Arrays.asList(id));
	}



	public  List<? extends BaseModel> getWeekData(List<Date> dates,List<Long> ids){
		List<DateCriteria> daysDateCriteria = new ArrayList<DateCriteria>();
		if (dates != null && dates.size() >0) {
			DateCriteria tmpCriteria = null; 
			for (Date date2 : dates) {
				Date start = DateUtil.getMondayOfWeek(date2);
				Date end = DateUtil.getSundayOfWeek(date2);
				tmpCriteria = new DateCriteria();
				tmpCriteria.setStartDate(start);
				tmpCriteria.setEndDate(end);
				daysDateCriteria.add(tmpCriteria);
			}
		}
		return this.getDaysData(daysDateCriteria, ids);
	}
	
	public List<? extends BaseModel> getWeekData(Date date,List<Long> ids){
		return this.getWeekData(Arrays.asList(date),ids);
	}
	public List<? extends BaseModel> getWeekData(Date date, Long id){
		return this.getWeekData(Arrays.asList(date),Arrays.asList(id));
	}
	public List<? extends BaseModel> getWeekData(List<Date> dates, Long id){
		return this.getWeekData(dates,Arrays.asList(id));
	}
	
	public  List<? extends BaseModel> getMonthData(List<Date> dates,List<Long> ids){
		List<DateCriteria> daysDateCriteria = new ArrayList<DateCriteria>();
		if (dates != null && dates.size() >0) {
			DateCriteria tmpCriteria = null; 
			for (Date date2 : dates) {
				Date  start = DateUtil.getFirstDateOfMonth(date2);
				Date  end = DateUtil.getLastDateOfMonth(date2);
				tmpCriteria = new DateCriteria();
				tmpCriteria.setStartDate(start);
				tmpCriteria.setEndDate(end);
				daysDateCriteria.add(tmpCriteria);
			}
		}
		return this.getDaysData(daysDateCriteria, ids);
	}
	
	public  List<? extends BaseModel> getMonthData(Date start,Date end,List<Long> ids){
		return this.getDayData(start, end, ids);
	}
	
	public List<? extends BaseModel> getMonthData(Date date,List<Long> ids){
		return this.getMonthData(Arrays.asList(date),ids);
	}
	public List<? extends BaseModel> getMonthData(Date date, Long id){
		return this.getMonthData(Arrays.asList(date),Arrays.asList(id));
	}
	public List<? extends BaseModel> getMonthData(List<Date> dates, Long id){
		return this.getMonthData(dates,Arrays.asList(id));
	}
	public  List<? extends BaseModel> getMonthData(Date start,Date end,Long id){
		return this.getMonthData(start, end, Arrays.asList(id));
	}
	
	public  List<? extends BaseModel> getYearData(List<Date> dates,List<Long> ids){
		List<DateCriteria> daysDateCriteria = new ArrayList<DateCriteria>();
		if (dates != null && dates.size() >0) {
			DateCriteria tmpCriteria = null; 
			for (Date date2 : dates) {
				Date  start = DateUtil.getFirstDateOfYear(date2);
				Date  end = DateUtil.getLastDateOfYear(date2);
				tmpCriteria = new DateCriteria();
				tmpCriteria.setStartDate(start);
				tmpCriteria.setEndDate(end);
				daysDateCriteria.add(tmpCriteria);
			}
		}
		return this.getDaysData(daysDateCriteria, ids);
	}
	public  List<? extends BaseModel> getYearData(Date start,Date end,List<Long> ids){
		return this.getDayData(start, end, ids);
	}
	public List<? extends BaseModel> getYearData(Date date,List<Long> ids){
		return this.getYearData(Arrays.asList(date),ids);
	}
	public List<? extends BaseModel> getYearData(Date date, Long id){
		return this.getYearData(Arrays.asList(date),Arrays.asList(id));
	}
	public List<? extends BaseModel> getYearData(List<Date> dates, Long id){
		return this.getYearData(dates,Arrays.asList(id));
	}
	public  List<? extends BaseModel> getYearData(Date start,Date end,Long id){
		return this.getYearData(start, end, Arrays.asList(id));
	}
	
   public static class DateCriteria{
		private Date startDate;
		private Date endDate;

	   public DateCriteria() {
	   }

	   public DateCriteria(Date startDate, Date endDate) {
		   this.startDate = startDate;
		   this.endDate = endDate;
	   }

	   public Date getStartDate() {
			return startDate;
		}
		public void setStartDate(Date startDate) {
			this.startDate = startDate;
		}
		public Date getEndDate() {
			return endDate;
		}
		public void setEndDate(Date endDate) {
			this.endDate = endDate;
		}
	}
	
}
  
    