package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class WeatherExample extends BaseExample {

    public WeatherExample() {
        super();
        tableName = "d_weather";
        tableAlias = "weather";
        ignoreCase = false;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "d_weather";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("\"weather\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"weather\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"weather\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"weather\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"weather\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"weather\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"weather\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"weather\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"weather\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"weather\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"weather\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"weather\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andProvinceIdIsNull() {
            addCriterion("\"weather\".province_id is null");
            return (Criteria) this;
        }

        public Criteria andProvinceIdIsNotNull() {
            addCriterion("\"weather\".province_id is not null");
            return (Criteria) this;
        }

        public Criteria andProvinceIdEqualTo(Long value) {
            addCriterion("\"weather\".province_id =", value, "provinceId");
            return (Criteria) this;
        }

        public Criteria andProvinceIdNotEqualTo(Long value) {
            addCriterion("\"weather\".province_id <>", value, "provinceId");
            return (Criteria) this;
        }

        public Criteria andProvinceIdGreaterThan(Long value) {
            addCriterion("\"weather\".province_id >", value, "provinceId");
            return (Criteria) this;
        }

        public Criteria andProvinceIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"weather\".province_id >=", value, "provinceId");
            return (Criteria) this;
        }

        public Criteria andProvinceIdLessThan(Long value) {
            addCriterion("\"weather\".province_id <", value, "provinceId");
            return (Criteria) this;
        }

        public Criteria andProvinceIdLessThanOrEqualTo(Long value) {
            addCriterion("\"weather\".province_id <=", value, "provinceId");
            return (Criteria) this;
        }

        public Criteria andProvinceIdIn(List<Long> values) {
            addCriterion("\"weather\".province_id in", values, "provinceId");
            return (Criteria) this;
        }

        public Criteria andProvinceIdNotIn(List<Long> values) {
            addCriterion("\"weather\".province_id not in", values, "provinceId");
            return (Criteria) this;
        }

        public Criteria andProvinceIdBetween(Long value1, Long value2) {
            addCriterion("\"weather\".province_id between", value1, value2, "provinceId");
            return (Criteria) this;
        }

        public Criteria andProvinceIdNotBetween(Long value1, Long value2) {
            addCriterion("\"weather\".province_id not between", value1, value2, "provinceId");
            return (Criteria) this;
        }

        public Criteria andCityIdIsNull() {
            addCriterion("\"weather\".city_id is null");
            return (Criteria) this;
        }

        public Criteria andCityIdIsNotNull() {
            addCriterion("\"weather\".city_id is not null");
            return (Criteria) this;
        }

        public Criteria andCityIdEqualTo(Long value) {
            addCriterion("\"weather\".city_id =", value, "cityId");
            return (Criteria) this;
        }

        public Criteria andCityIdNotEqualTo(Long value) {
            addCriterion("\"weather\".city_id <>", value, "cityId");
            return (Criteria) this;
        }

        public Criteria andCityIdGreaterThan(Long value) {
            addCriterion("\"weather\".city_id >", value, "cityId");
            return (Criteria) this;
        }

        public Criteria andCityIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"weather\".city_id >=", value, "cityId");
            return (Criteria) this;
        }

        public Criteria andCityIdLessThan(Long value) {
            addCriterion("\"weather\".city_id <", value, "cityId");
            return (Criteria) this;
        }

        public Criteria andCityIdLessThanOrEqualTo(Long value) {
            addCriterion("\"weather\".city_id <=", value, "cityId");
            return (Criteria) this;
        }

        public Criteria andCityIdIn(List<Long> values) {
            addCriterion("\"weather\".city_id in", values, "cityId");
            return (Criteria) this;
        }

        public Criteria andCityIdNotIn(List<Long> values) {
            addCriterion("\"weather\".city_id not in", values, "cityId");
            return (Criteria) this;
        }

        public Criteria andCityIdBetween(Long value1, Long value2) {
            addCriterion("\"weather\".city_id between", value1, value2, "cityId");
            return (Criteria) this;
        }

        public Criteria andCityIdNotBetween(Long value1, Long value2) {
            addCriterion("\"weather\".city_id not between", value1, value2, "cityId");
            return (Criteria) this;
        }

        public Criteria andTypeIsNull() {
            addCriterion("\"weather\".\"type\" is null");
            return (Criteria) this;
        }

        public Criteria andTypeIsNotNull() {
            addCriterion("\"weather\".\"type\" is not null");
            return (Criteria) this;
        }

        public Criteria andTypeEqualTo(String value) {
            addCriterion("\"weather\".\"type\" =", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotEqualTo(String value) {
            addCriterion("\"weather\".\"type\" <>", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeGreaterThan(String value) {
            addCriterion("\"weather\".\"type\" >", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeGreaterThanOrEqualTo(String value) {
            addCriterion("\"weather\".\"type\" >=", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeLessThan(String value) {
            addCriterion("\"weather\".\"type\" <", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeLessThanOrEqualTo(String value) {
            addCriterion("\"weather\".\"type\" <=", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeLike(String value) {
            addCriterion("\"weather\".\"type\" like", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotLike(String value) {
            addCriterion("\"weather\".\"type\" not like", value, "type");
            return (Criteria) this;
        }

        public Criteria andTypeIn(List<String> values) {
            addCriterion("\"weather\".\"type\" in", values, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotIn(List<String> values) {
            addCriterion("\"weather\".\"type\" not in", values, "type");
            return (Criteria) this;
        }

        public Criteria andTypeBetween(String value1, String value2) {
            addCriterion("\"weather\".\"type\" between", value1, value2, "type");
            return (Criteria) this;
        }

        public Criteria andTypeNotBetween(String value1, String value2) {
            addCriterion("\"weather\".\"type\" not between", value1, value2, "type");
            return (Criteria) this;
        }

        public Criteria andDataDateIsNull() {
            addCriterion("\"weather\".data_date is null");
            return (Criteria) this;
        }

        public Criteria andDataDateIsNotNull() {
            addCriterion("\"weather\".data_date is not null");
            return (Criteria) this;
        }

        public Criteria andDataDateEqualTo(Date value) {
            addCriterionForJDBCDate("\"weather\".data_date =", value, "dataDate");
            return (Criteria) this;
        }

        public Criteria andDataDateNotEqualTo(Date value) {
            addCriterionForJDBCDate("\"weather\".data_date <>", value, "dataDate");
            return (Criteria) this;
        }

        public Criteria andDataDateGreaterThan(Date value) {
            addCriterionForJDBCDate("\"weather\".data_date >", value, "dataDate");
            return (Criteria) this;
        }

        public Criteria andDataDateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"weather\".data_date >=", value, "dataDate");
            return (Criteria) this;
        }

        public Criteria andDataDateLessThan(Date value) {
            addCriterionForJDBCDate("\"weather\".data_date <", value, "dataDate");
            return (Criteria) this;
        }

        public Criteria andDataDateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"weather\".data_date <=", value, "dataDate");
            return (Criteria) this;
        }

        public Criteria andDataDateIn(List<Date> values) {
            addCriterionForJDBCDate("\"weather\".data_date in", values, "dataDate");
            return (Criteria) this;
        }

        public Criteria andDataDateNotIn(List<Date> values) {
            addCriterionForJDBCDate("\"weather\".data_date not in", values, "dataDate");
            return (Criteria) this;
        }

        public Criteria andDataDateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"weather\".data_date between", value1, value2, "dataDate");
            return (Criteria) this;
        }

        public Criteria andDataDateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"weather\".data_date not between", value1, value2, "dataDate");
            return (Criteria) this;
        }

        public Criteria andLtempIsNull() {
            addCriterion("\"weather\".ltemp is null");
            return (Criteria) this;
        }

        public Criteria andLtempIsNotNull() {
            addCriterion("\"weather\".ltemp is not null");
            return (Criteria) this;
        }

        public Criteria andLtempEqualTo(Short value) {
            addCriterion("\"weather\".ltemp =", value, "ltemp");
            return (Criteria) this;
        }

        public Criteria andLtempNotEqualTo(Short value) {
            addCriterion("\"weather\".ltemp <>", value, "ltemp");
            return (Criteria) this;
        }

        public Criteria andLtempGreaterThan(Short value) {
            addCriterion("\"weather\".ltemp >", value, "ltemp");
            return (Criteria) this;
        }

        public Criteria andLtempGreaterThanOrEqualTo(Short value) {
            addCriterion("\"weather\".ltemp >=", value, "ltemp");
            return (Criteria) this;
        }

        public Criteria andLtempLessThan(Short value) {
            addCriterion("\"weather\".ltemp <", value, "ltemp");
            return (Criteria) this;
        }

        public Criteria andLtempLessThanOrEqualTo(Short value) {
            addCriterion("\"weather\".ltemp <=", value, "ltemp");
            return (Criteria) this;
        }

        public Criteria andLtempIn(List<Short> values) {
            addCriterion("\"weather\".ltemp in", values, "ltemp");
            return (Criteria) this;
        }

        public Criteria andLtempNotIn(List<Short> values) {
            addCriterion("\"weather\".ltemp not in", values, "ltemp");
            return (Criteria) this;
        }

        public Criteria andLtempBetween(Short value1, Short value2) {
            addCriterion("\"weather\".ltemp between", value1, value2, "ltemp");
            return (Criteria) this;
        }

        public Criteria andLtempNotBetween(Short value1, Short value2) {
            addCriterion("\"weather\".ltemp not between", value1, value2, "ltemp");
            return (Criteria) this;
        }

        public Criteria andHtempIsNull() {
            addCriterion("\"weather\".htemp is null");
            return (Criteria) this;
        }

        public Criteria andHtempIsNotNull() {
            addCriterion("\"weather\".htemp is not null");
            return (Criteria) this;
        }

        public Criteria andHtempEqualTo(Short value) {
            addCriterion("\"weather\".htemp =", value, "htemp");
            return (Criteria) this;
        }

        public Criteria andHtempNotEqualTo(Short value) {
            addCriterion("\"weather\".htemp <>", value, "htemp");
            return (Criteria) this;
        }

        public Criteria andHtempGreaterThan(Short value) {
            addCriterion("\"weather\".htemp >", value, "htemp");
            return (Criteria) this;
        }

        public Criteria andHtempGreaterThanOrEqualTo(Short value) {
            addCriterion("\"weather\".htemp >=", value, "htemp");
            return (Criteria) this;
        }

        public Criteria andHtempLessThan(Short value) {
            addCriterion("\"weather\".htemp <", value, "htemp");
            return (Criteria) this;
        }

        public Criteria andHtempLessThanOrEqualTo(Short value) {
            addCriterion("\"weather\".htemp <=", value, "htemp");
            return (Criteria) this;
        }

        public Criteria andHtempIn(List<Short> values) {
            addCriterion("\"weather\".htemp in", values, "htemp");
            return (Criteria) this;
        }

        public Criteria andHtempNotIn(List<Short> values) {
            addCriterion("\"weather\".htemp not in", values, "htemp");
            return (Criteria) this;
        }

        public Criteria andHtempBetween(Short value1, Short value2) {
            addCriterion("\"weather\".htemp between", value1, value2, "htemp");
            return (Criteria) this;
        }

        public Criteria andHtempNotBetween(Short value1, Short value2) {
            addCriterion("\"weather\".htemp not between", value1, value2, "htemp");
            return (Criteria) this;
        }

        public Criteria andAqiIsNull() {
            addCriterion("\"weather\".aqi is null");
            return (Criteria) this;
        }

        public Criteria andAqiIsNotNull() {
            addCriterion("\"weather\".aqi is not null");
            return (Criteria) this;
        }

        public Criteria andAqiEqualTo(Short value) {
            addCriterion("\"weather\".aqi =", value, "aqi");
            return (Criteria) this;
        }

        public Criteria andAqiNotEqualTo(Short value) {
            addCriterion("\"weather\".aqi <>", value, "aqi");
            return (Criteria) this;
        }

        public Criteria andAqiGreaterThan(Short value) {
            addCriterion("\"weather\".aqi >", value, "aqi");
            return (Criteria) this;
        }

        public Criteria andAqiGreaterThanOrEqualTo(Short value) {
            addCriterion("\"weather\".aqi >=", value, "aqi");
            return (Criteria) this;
        }

        public Criteria andAqiLessThan(Short value) {
            addCriterion("\"weather\".aqi <", value, "aqi");
            return (Criteria) this;
        }

        public Criteria andAqiLessThanOrEqualTo(Short value) {
            addCriterion("\"weather\".aqi <=", value, "aqi");
            return (Criteria) this;
        }

        public Criteria andAqiIn(List<Short> values) {
            addCriterion("\"weather\".aqi in", values, "aqi");
            return (Criteria) this;
        }

        public Criteria andAqiNotIn(List<Short> values) {
            addCriterion("\"weather\".aqi not in", values, "aqi");
            return (Criteria) this;
        }

        public Criteria andAqiBetween(Short value1, Short value2) {
            addCriterion("\"weather\".aqi between", value1, value2, "aqi");
            return (Criteria) this;
        }

        public Criteria andAqiNotBetween(Short value1, Short value2) {
            addCriterion("\"weather\".aqi not between", value1, value2, "aqi");
            return (Criteria) this;
        }

        public Criteria andWindIntensityIsNull() {
            addCriterion("\"weather\".wind_intensity is null");
            return (Criteria) this;
        }

        public Criteria andWindIntensityIsNotNull() {
            addCriterion("\"weather\".wind_intensity is not null");
            return (Criteria) this;
        }

        public Criteria andWindIntensityEqualTo(Short value) {
            addCriterion("\"weather\".wind_intensity =", value, "windIntensity");
            return (Criteria) this;
        }

        public Criteria andWindIntensityNotEqualTo(Short value) {
            addCriterion("\"weather\".wind_intensity <>", value, "windIntensity");
            return (Criteria) this;
        }

        public Criteria andWindIntensityGreaterThan(Short value) {
            addCriterion("\"weather\".wind_intensity >", value, "windIntensity");
            return (Criteria) this;
        }

        public Criteria andWindIntensityGreaterThanOrEqualTo(Short value) {
            addCriterion("\"weather\".wind_intensity >=", value, "windIntensity");
            return (Criteria) this;
        }

        public Criteria andWindIntensityLessThan(Short value) {
            addCriterion("\"weather\".wind_intensity <", value, "windIntensity");
            return (Criteria) this;
        }

        public Criteria andWindIntensityLessThanOrEqualTo(Short value) {
            addCriterion("\"weather\".wind_intensity <=", value, "windIntensity");
            return (Criteria) this;
        }

        public Criteria andWindIntensityIn(List<Short> values) {
            addCriterion("\"weather\".wind_intensity in", values, "windIntensity");
            return (Criteria) this;
        }

        public Criteria andWindIntensityNotIn(List<Short> values) {
            addCriterion("\"weather\".wind_intensity not in", values, "windIntensity");
            return (Criteria) this;
        }

        public Criteria andWindIntensityBetween(Short value1, Short value2) {
            addCriterion("\"weather\".wind_intensity between", value1, value2, "windIntensity");
            return (Criteria) this;
        }

        public Criteria andWindIntensityNotBetween(Short value1, Short value2) {
            addCriterion("\"weather\".wind_intensity not between", value1, value2, "windIntensity");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"weather\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"weather\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"weather\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"weather\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"weather\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"weather\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"weather\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"weather\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"weather\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"weather\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"weather\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"weather\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"weather\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"weather\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"weather\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"weather\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"weather\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"weather\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"weather\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"weather\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"weather\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"weather\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"weather\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"weather\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"weather\".id as weather_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasProvinceIdColumn() {
            addColumnStr("\"weather\".province_id as weather_province_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCityIdColumn() {
            addColumnStr("\"weather\".city_id as weather_city_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasTypeColumn() {
            addColumnStr("\"weather\".\"type\" as \"weather_type\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasDataDateColumn() {
            addColumnStr("\"weather\".data_date as weather_data_date ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasLtempColumn() {
            addColumnStr("\"weather\".ltemp as weather_ltemp ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasHtempColumn() {
            addColumnStr("\"weather\".htemp as weather_htemp ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAqiColumn() {
            addColumnStr("\"weather\".aqi as weather_aqi ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasWindIntensityColumn() {
            addColumnStr("\"weather\".wind_intensity as weather_wind_intensity ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"weather\".modify_time as weather_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"weather\".create_time as weather_create_time ");
            return (ColumnContainer) this;
        }
    }
}