package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.Date;
import java.util.List;

public class StaffExample extends BaseExample {

    public StaffExample() {
        super();
        tableName = "b_staff";
        tableAlias = "staff";
        ignoreCase = false;
    }

    public PersonExample.ColumnContainer createPersonColumns() {
        PersonExample personExample = new PersonExample();
        PersonExample.ColumnContainer columnContainer = (PersonExample.ColumnContainer) columnContainerMap.get(personExample.getTableName());
         if(columnContainer == null){
            columnContainer = personExample.createColumns();
            columnContainerMap.put(personExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public PersonExample.Criteria andPersonCriteria() {
        PersonExample personExample = new PersonExample();
        PersonExample.Criteria criteria = personExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public PersonExample.Criteria orPersonCriteria() {
        PersonExample personExample = new PersonExample();
        PersonExample.Criteria criteria = personExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public PersonExample.Criteria andPersonCriteria(Criteria criteria) {
        PersonExample personExample = new PersonExample();
        PersonExample.Criteria newCriteria = personExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public MallExample.ColumnContainer createMallColumns() {
        MallExample mallExample = new MallExample();
        MallExample.ColumnContainer columnContainer = (MallExample.ColumnContainer) columnContainerMap.get(mallExample.getTableName());
         if(columnContainer == null){
            columnContainer = mallExample.createColumns();
            columnContainerMap.put(mallExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public MallExample.Criteria andMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public MallExample.Criteria orMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public MallExample.Criteria andMallCriteria(Criteria criteria) {
        MallExample mallExample = new MallExample();
        MallExample.Criteria newCriteria = mallExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public AccountExample.ColumnContainer createAccountColumns() {
        AccountExample accountExample = new AccountExample();
        AccountExample.ColumnContainer columnContainer = (AccountExample.ColumnContainer) columnContainerMap.get(accountExample.getTableName());
         if(columnContainer == null){
            columnContainer = accountExample.createColumns();
            columnContainerMap.put(accountExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public AccountExample.Criteria andAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public AccountExample.Criteria orAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public AccountExample.Criteria andAccountCriteria(Criteria criteria) {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria newCriteria = accountExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "b_staff";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("\"staff\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"staff\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"staff\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"staff\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"staff\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"staff\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"staff\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"staff\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"staff\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"staff\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"staff\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"staff\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andPersonIdIsNull() {
            addCriterion("\"staff\".person_id is null");
            return (Criteria) this;
        }

        public Criteria andPersonIdIsNotNull() {
            addCriterion("\"staff\".person_id is not null");
            return (Criteria) this;
        }

        public Criteria andPersonIdEqualTo(Long value) {
            addCriterion("\"staff\".person_id =", value, "personId");
            return (Criteria) this;
        }

        public Criteria andPersonIdNotEqualTo(Long value) {
            addCriterion("\"staff\".person_id <>", value, "personId");
            return (Criteria) this;
        }

        public Criteria andPersonIdGreaterThan(Long value) {
            addCriterion("\"staff\".person_id >", value, "personId");
            return (Criteria) this;
        }

        public Criteria andPersonIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"staff\".person_id >=", value, "personId");
            return (Criteria) this;
        }

        public Criteria andPersonIdLessThan(Long value) {
            addCriterion("\"staff\".person_id <", value, "personId");
            return (Criteria) this;
        }

        public Criteria andPersonIdLessThanOrEqualTo(Long value) {
            addCriterion("\"staff\".person_id <=", value, "personId");
            return (Criteria) this;
        }

        public Criteria andPersonIdIn(List<Long> values) {
            addCriterion("\"staff\".person_id in", values, "personId");
            return (Criteria) this;
        }

        public Criteria andPersonIdNotIn(List<Long> values) {
            addCriterion("\"staff\".person_id not in", values, "personId");
            return (Criteria) this;
        }

        public Criteria andPersonIdBetween(Long value1, Long value2) {
            addCriterion("\"staff\".person_id between", value1, value2, "personId");
            return (Criteria) this;
        }

        public Criteria andPersonIdNotBetween(Long value1, Long value2) {
            addCriterion("\"staff\".person_id not between", value1, value2, "personId");
            return (Criteria) this;
        }

        public Criteria andPersonUnidIsNull() {
            addCriterion("\"staff\".person_unid is null");
            return (Criteria) this;
        }

        public Criteria andPersonUnidIsNotNull() {
            addCriterion("\"staff\".person_unid is not null");
            return (Criteria) this;
        }

        public Criteria andPersonUnidEqualTo(String value) {
            addCriterion("\"staff\".person_unid =", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidNotEqualTo(String value) {
            addCriterion("\"staff\".person_unid <>", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidGreaterThan(String value) {
            addCriterion("\"staff\".person_unid >", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidGreaterThanOrEqualTo(String value) {
            addCriterion("\"staff\".person_unid >=", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidLessThan(String value) {
            addCriterion("\"staff\".person_unid <", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidLessThanOrEqualTo(String value) {
            addCriterion("\"staff\".person_unid <=", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidLike(String value) {
            addCriterion("\"staff\".person_unid like", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidNotLike(String value) {
            addCriterion("\"staff\".person_unid not like", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidIn(List<String> values) {
            addCriterion("\"staff\".person_unid in", values, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidNotIn(List<String> values) {
            addCriterion("\"staff\".person_unid not in", values, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidBetween(String value1, String value2) {
            addCriterion("\"staff\".person_unid between", value1, value2, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidNotBetween(String value1, String value2) {
            addCriterion("\"staff\".person_unid not between", value1, value2, "personUnid");
            return (Criteria) this;
        }

        public Criteria andNameIsNull() {
            addCriterion("\"staff\".\"name\" is null");
            return (Criteria) this;
        }

        public Criteria andNameIsNotNull() {
            addCriterion("\"staff\".\"name\" is not null");
            return (Criteria) this;
        }

        public Criteria andNameEqualTo(String value) {
            addCriterion("\"staff\".\"name\" =", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotEqualTo(String value) {
            addCriterion("\"staff\".\"name\" <>", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameGreaterThan(String value) {
            addCriterion("\"staff\".\"name\" >", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameGreaterThanOrEqualTo(String value) {
            addCriterion("\"staff\".\"name\" >=", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameLessThan(String value) {
            addCriterion("\"staff\".\"name\" <", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameLessThanOrEqualTo(String value) {
            addCriterion("\"staff\".\"name\" <=", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameLike(String value) {
            addCriterion("\"staff\".\"name\" like", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotLike(String value) {
            addCriterion("\"staff\".\"name\" not like", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameIn(List<String> values) {
            addCriterion("\"staff\".\"name\" in", values, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotIn(List<String> values) {
            addCriterion("\"staff\".\"name\" not in", values, "name");
            return (Criteria) this;
        }

        public Criteria andNameBetween(String value1, String value2) {
            addCriterion("\"staff\".\"name\" between", value1, value2, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotBetween(String value1, String value2) {
            addCriterion("\"staff\".\"name\" not between", value1, value2, "name");
            return (Criteria) this;
        }

        public Criteria andGenderIsNull() {
            addCriterion("\"staff\".gender is null");
            return (Criteria) this;
        }

        public Criteria andGenderIsNotNull() {
            addCriterion("\"staff\".gender is not null");
            return (Criteria) this;
        }

        public Criteria andGenderEqualTo(Short value) {
            addCriterion("\"staff\".gender =", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderNotEqualTo(Short value) {
            addCriterion("\"staff\".gender <>", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderGreaterThan(Short value) {
            addCriterion("\"staff\".gender >", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderGreaterThanOrEqualTo(Short value) {
            addCriterion("\"staff\".gender >=", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderLessThan(Short value) {
            addCriterion("\"staff\".gender <", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderLessThanOrEqualTo(Short value) {
            addCriterion("\"staff\".gender <=", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderIn(List<Short> values) {
            addCriterion("\"staff\".gender in", values, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderNotIn(List<Short> values) {
            addCriterion("\"staff\".gender not in", values, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderBetween(Short value1, Short value2) {
            addCriterion("\"staff\".gender between", value1, value2, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderNotBetween(Short value1, Short value2) {
            addCriterion("\"staff\".gender not between", value1, value2, "gender");
            return (Criteria) this;
        }

        public Criteria andAgeIsNull() {
            addCriterion("\"staff\".age is null");
            return (Criteria) this;
        }

        public Criteria andAgeIsNotNull() {
            addCriterion("\"staff\".age is not null");
            return (Criteria) this;
        }

        public Criteria andAgeEqualTo(Short value) {
            addCriterion("\"staff\".age =", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeNotEqualTo(Short value) {
            addCriterion("\"staff\".age <>", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeGreaterThan(Short value) {
            addCriterion("\"staff\".age >", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeGreaterThanOrEqualTo(Short value) {
            addCriterion("\"staff\".age >=", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeLessThan(Short value) {
            addCriterion("\"staff\".age <", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeLessThanOrEqualTo(Short value) {
            addCriterion("\"staff\".age <=", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeIn(List<Short> values) {
            addCriterion("\"staff\".age in", values, "age");
            return (Criteria) this;
        }

        public Criteria andAgeNotIn(List<Short> values) {
            addCriterion("\"staff\".age not in", values, "age");
            return (Criteria) this;
        }

        public Criteria andAgeBetween(Short value1, Short value2) {
            addCriterion("\"staff\".age between", value1, value2, "age");
            return (Criteria) this;
        }

        public Criteria andAgeNotBetween(Short value1, Short value2) {
            addCriterion("\"staff\".age not between", value1, value2, "age");
            return (Criteria) this;
        }

        public Criteria andTelIsNull() {
            addCriterion("\"staff\".tel is null");
            return (Criteria) this;
        }

        public Criteria andTelIsNotNull() {
            addCriterion("\"staff\".tel is not null");
            return (Criteria) this;
        }

        public Criteria andTelEqualTo(String value) {
            addCriterion("\"staff\".tel =", value, "tel");
            return (Criteria) this;
        }

        public Criteria andTelNotEqualTo(String value) {
            addCriterion("\"staff\".tel <>", value, "tel");
            return (Criteria) this;
        }

        public Criteria andTelGreaterThan(String value) {
            addCriterion("\"staff\".tel >", value, "tel");
            return (Criteria) this;
        }

        public Criteria andTelGreaterThanOrEqualTo(String value) {
            addCriterion("\"staff\".tel >=", value, "tel");
            return (Criteria) this;
        }

        public Criteria andTelLessThan(String value) {
            addCriterion("\"staff\".tel <", value, "tel");
            return (Criteria) this;
        }

        public Criteria andTelLessThanOrEqualTo(String value) {
            addCriterion("\"staff\".tel <=", value, "tel");
            return (Criteria) this;
        }

        public Criteria andTelLike(String value) {
            addCriterion("\"staff\".tel like", value, "tel");
            return (Criteria) this;
        }

        public Criteria andTelNotLike(String value) {
            addCriterion("\"staff\".tel not like", value, "tel");
            return (Criteria) this;
        }

        public Criteria andTelIn(List<String> values) {
            addCriterion("\"staff\".tel in", values, "tel");
            return (Criteria) this;
        }

        public Criteria andTelNotIn(List<String> values) {
            addCriterion("\"staff\".tel not in", values, "tel");
            return (Criteria) this;
        }

        public Criteria andTelBetween(String value1, String value2) {
            addCriterion("\"staff\".tel between", value1, value2, "tel");
            return (Criteria) this;
        }

        public Criteria andTelNotBetween(String value1, String value2) {
            addCriterion("\"staff\".tel not between", value1, value2, "tel");
            return (Criteria) this;
        }

        public Criteria andEmailIsNull() {
            addCriterion("\"staff\".email is null");
            return (Criteria) this;
        }

        public Criteria andEmailIsNotNull() {
            addCriterion("\"staff\".email is not null");
            return (Criteria) this;
        }

        public Criteria andEmailEqualTo(String value) {
            addCriterion("\"staff\".email =", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailNotEqualTo(String value) {
            addCriterion("\"staff\".email <>", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailGreaterThan(String value) {
            addCriterion("\"staff\".email >", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailGreaterThanOrEqualTo(String value) {
            addCriterion("\"staff\".email >=", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailLessThan(String value) {
            addCriterion("\"staff\".email <", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailLessThanOrEqualTo(String value) {
            addCriterion("\"staff\".email <=", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailLike(String value) {
            addCriterion("\"staff\".email like", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailNotLike(String value) {
            addCriterion("\"staff\".email not like", value, "email");
            return (Criteria) this;
        }

        public Criteria andEmailIn(List<String> values) {
            addCriterion("\"staff\".email in", values, "email");
            return (Criteria) this;
        }

        public Criteria andEmailNotIn(List<String> values) {
            addCriterion("\"staff\".email not in", values, "email");
            return (Criteria) this;
        }

        public Criteria andEmailBetween(String value1, String value2) {
            addCriterion("\"staff\".email between", value1, value2, "email");
            return (Criteria) this;
        }

        public Criteria andEmailNotBetween(String value1, String value2) {
            addCriterion("\"staff\".email not between", value1, value2, "email");
            return (Criteria) this;
        }

        public Criteria andPhotoIsNull() {
            addCriterion("\"staff\".photo is null");
            return (Criteria) this;
        }

        public Criteria andPhotoIsNotNull() {
            addCriterion("\"staff\".photo is not null");
            return (Criteria) this;
        }

        public Criteria andPhotoEqualTo(String value) {
            addCriterion("\"staff\".photo =", value, "photo");
            return (Criteria) this;
        }

        public Criteria andPhotoNotEqualTo(String value) {
            addCriterion("\"staff\".photo <>", value, "photo");
            return (Criteria) this;
        }

        public Criteria andPhotoGreaterThan(String value) {
            addCriterion("\"staff\".photo >", value, "photo");
            return (Criteria) this;
        }

        public Criteria andPhotoGreaterThanOrEqualTo(String value) {
            addCriterion("\"staff\".photo >=", value, "photo");
            return (Criteria) this;
        }

        public Criteria andPhotoLessThan(String value) {
            addCriterion("\"staff\".photo <", value, "photo");
            return (Criteria) this;
        }

        public Criteria andPhotoLessThanOrEqualTo(String value) {
            addCriterion("\"staff\".photo <=", value, "photo");
            return (Criteria) this;
        }

        public Criteria andPhotoLike(String value) {
            addCriterion("\"staff\".photo like", value, "photo");
            return (Criteria) this;
        }

        public Criteria andPhotoNotLike(String value) {
            addCriterion("\"staff\".photo not like", value, "photo");
            return (Criteria) this;
        }

        public Criteria andPhotoIn(List<String> values) {
            addCriterion("\"staff\".photo in", values, "photo");
            return (Criteria) this;
        }

        public Criteria andPhotoNotIn(List<String> values) {
            addCriterion("\"staff\".photo not in", values, "photo");
            return (Criteria) this;
        }

        public Criteria andPhotoBetween(String value1, String value2) {
            addCriterion("\"staff\".photo between", value1, value2, "photo");
            return (Criteria) this;
        }

        public Criteria andPhotoNotBetween(String value1, String value2) {
            addCriterion("\"staff\".photo not between", value1, value2, "photo");
            return (Criteria) this;
        }

        public Criteria andPositionIsNull() {
            addCriterion("\"staff\".\"position\" is null");
            return (Criteria) this;
        }

        public Criteria andPositionIsNotNull() {
            addCriterion("\"staff\".\"position\" is not null");
            return (Criteria) this;
        }

        public Criteria andPositionEqualTo(String value) {
            addCriterion("\"staff\".\"position\" =", value, "position");
            return (Criteria) this;
        }

        public Criteria andPositionNotEqualTo(String value) {
            addCriterion("\"staff\".\"position\" <>", value, "position");
            return (Criteria) this;
        }

        public Criteria andPositionGreaterThan(String value) {
            addCriterion("\"staff\".\"position\" >", value, "position");
            return (Criteria) this;
        }

        public Criteria andPositionGreaterThanOrEqualTo(String value) {
            addCriterion("\"staff\".\"position\" >=", value, "position");
            return (Criteria) this;
        }

        public Criteria andPositionLessThan(String value) {
            addCriterion("\"staff\".\"position\" <", value, "position");
            return (Criteria) this;
        }

        public Criteria andPositionLessThanOrEqualTo(String value) {
            addCriterion("\"staff\".\"position\" <=", value, "position");
            return (Criteria) this;
        }

        public Criteria andPositionLike(String value) {
            addCriterion("\"staff\".\"position\" like", value, "position");
            return (Criteria) this;
        }

        public Criteria andPositionNotLike(String value) {
            addCriterion("\"staff\".\"position\" not like", value, "position");
            return (Criteria) this;
        }

        public Criteria andPositionIn(List<String> values) {
            addCriterion("\"staff\".\"position\" in", values, "position");
            return (Criteria) this;
        }

        public Criteria andPositionNotIn(List<String> values) {
            addCriterion("\"staff\".\"position\" not in", values, "position");
            return (Criteria) this;
        }

        public Criteria andPositionBetween(String value1, String value2) {
            addCriterion("\"staff\".\"position\" between", value1, value2, "position");
            return (Criteria) this;
        }

        public Criteria andPositionNotBetween(String value1, String value2) {
            addCriterion("\"staff\".\"position\" not between", value1, value2, "position");
            return (Criteria) this;
        }

        public Criteria andStatusIsNull() {
            addCriterion("\"staff\".\"status\" is null");
            return (Criteria) this;
        }

        public Criteria andStatusIsNotNull() {
            addCriterion("\"staff\".\"status\" is not null");
            return (Criteria) this;
        }

        public Criteria andStatusEqualTo(Short value) {
            addCriterion("\"staff\".\"status\" =", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotEqualTo(Short value) {
            addCriterion("\"staff\".\"status\" <>", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThan(Short value) {
            addCriterion("\"staff\".\"status\" >", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThanOrEqualTo(Short value) {
            addCriterion("\"staff\".\"status\" >=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThan(Short value) {
            addCriterion("\"staff\".\"status\" <", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThanOrEqualTo(Short value) {
            addCriterion("\"staff\".\"status\" <=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusIn(List<Short> values) {
            addCriterion("\"staff\".\"status\" in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotIn(List<Short> values) {
            addCriterion("\"staff\".\"status\" not in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusBetween(Short value1, Short value2) {
            addCriterion("\"staff\".\"status\" between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotBetween(Short value1, Short value2) {
            addCriterion("\"staff\".\"status\" not between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNull() {
            addCriterion("\"staff\".mall_id is null");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNotNull() {
            addCriterion("\"staff\".mall_id is not null");
            return (Criteria) this;
        }

        public Criteria andMallIdEqualTo(Long value) {
            addCriterion("\"staff\".mall_id =", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotEqualTo(Long value) {
            addCriterion("\"staff\".mall_id <>", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThan(Long value) {
            addCriterion("\"staff\".mall_id >", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"staff\".mall_id >=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThan(Long value) {
            addCriterion("\"staff\".mall_id <", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThanOrEqualTo(Long value) {
            addCriterion("\"staff\".mall_id <=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdIn(List<Long> values) {
            addCriterion("\"staff\".mall_id in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotIn(List<Long> values) {
            addCriterion("\"staff\".mall_id not in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdBetween(Long value1, Long value2) {
            addCriterion("\"staff\".mall_id between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotBetween(Long value1, Long value2) {
            addCriterion("\"staff\".mall_id not between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNull() {
            addCriterion("\"staff\".account_id is null");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNotNull() {
            addCriterion("\"staff\".account_id is not null");
            return (Criteria) this;
        }

        public Criteria andAccountIdEqualTo(Long value) {
            addCriterion("\"staff\".account_id =", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotEqualTo(Long value) {
            addCriterion("\"staff\".account_id <>", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThan(Long value) {
            addCriterion("\"staff\".account_id >", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"staff\".account_id >=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThan(Long value) {
            addCriterion("\"staff\".account_id <", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThanOrEqualTo(Long value) {
            addCriterion("\"staff\".account_id <=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIn(List<Long> values) {
            addCriterion("\"staff\".account_id in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotIn(List<Long> values) {
            addCriterion("\"staff\".account_id not in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdBetween(Long value1, Long value2) {
            addCriterion("\"staff\".account_id between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotBetween(Long value1, Long value2) {
            addCriterion("\"staff\".account_id not between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andIntroIsNull() {
            addCriterion("\"staff\".intro is null");
            return (Criteria) this;
        }

        public Criteria andIntroIsNotNull() {
            addCriterion("\"staff\".intro is not null");
            return (Criteria) this;
        }

        public Criteria andIntroEqualTo(String value) {
            addCriterion("\"staff\".intro =", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotEqualTo(String value) {
            addCriterion("\"staff\".intro <>", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroGreaterThan(String value) {
            addCriterion("\"staff\".intro >", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroGreaterThanOrEqualTo(String value) {
            addCriterion("\"staff\".intro >=", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroLessThan(String value) {
            addCriterion("\"staff\".intro <", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroLessThanOrEqualTo(String value) {
            addCriterion("\"staff\".intro <=", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroLike(String value) {
            addCriterion("\"staff\".intro like", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotLike(String value) {
            addCriterion("\"staff\".intro not like", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroIn(List<String> values) {
            addCriterion("\"staff\".intro in", values, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotIn(List<String> values) {
            addCriterion("\"staff\".intro not in", values, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroBetween(String value1, String value2) {
            addCriterion("\"staff\".intro between", value1, value2, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotBetween(String value1, String value2) {
            addCriterion("\"staff\".intro not between", value1, value2, "intro");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"staff\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"staff\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"staff\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"staff\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"staff\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"staff\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"staff\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"staff\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"staff\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"staff\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"staff\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"staff\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"staff\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"staff\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"staff\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"staff\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"staff\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"staff\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"staff\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"staff\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"staff\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"staff\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"staff\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"staff\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"staff\".id as staff_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasPersonIdColumn() {
            addColumnStr("\"staff\".person_id as staff_person_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasPersonUnidColumn() {
            addColumnStr("\"staff\".person_unid as staff_person_unid ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasNameColumn() {
            addColumnStr("\"staff\".\"name\" as \"staff_name\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasGenderColumn() {
            addColumnStr("\"staff\".gender as staff_gender ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAgeColumn() {
            addColumnStr("\"staff\".age as staff_age ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasTelColumn() {
            addColumnStr("\"staff\".tel as staff_tel ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasEmailColumn() {
            addColumnStr("\"staff\".email as staff_email ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasPhotoColumn() {
            addColumnStr("\"staff\".photo as staff_photo ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasPositionColumn() {
            addColumnStr("\"staff\".\"position\" as \"staff_position\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasStatusColumn() {
            addColumnStr("\"staff\".\"status\" as \"staff_status\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMallIdColumn() {
            addColumnStr("\"staff\".mall_id as staff_mall_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAccountIdColumn() {
            addColumnStr("\"staff\".account_id as staff_account_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasIntroColumn() {
            addColumnStr("\"staff\".intro as staff_intro ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"staff\".create_time as staff_create_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"staff\".modify_time as staff_modify_time ");
            return (ColumnContainer) this;
        }
    }
}