package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ResidenceExample extends BaseExample {

    public ResidenceExample() {
        super();
        tableName = "d_residence";
        tableAlias = "residence";
        ignoreCase = false;
    }

    public MallExample.ColumnContainer createMallColumns() {
        MallExample mallExample = new MallExample();
        MallExample.ColumnContainer columnContainer = (MallExample.ColumnContainer) columnContainerMap.get(mallExample.getTableName());
         if(columnContainer == null){
            columnContainer = mallExample.createColumns();
            columnContainerMap.put(mallExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public MallExample.Criteria andMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public MallExample.Criteria orMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public MallExample.Criteria andMallCriteria(Criteria criteria) {
        MallExample mallExample = new MallExample();
        MallExample.Criteria newCriteria = mallExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public AccountExample.ColumnContainer createAccountColumns() {
        AccountExample accountExample = new AccountExample();
        AccountExample.ColumnContainer columnContainer = (AccountExample.ColumnContainer) columnContainerMap.get(accountExample.getTableName());
         if(columnContainer == null){
            columnContainer = accountExample.createColumns();
            columnContainerMap.put(accountExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public AccountExample.Criteria andAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public AccountExample.Criteria orAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public AccountExample.Criteria andAccountCriteria(Criteria criteria) {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria newCriteria = accountExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "d_residence";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("\"residence\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"residence\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"residence\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"residence\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"residence\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"residence\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"residence\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"residence\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"residence\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"residence\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"residence\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"residence\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNull() {
            addCriterion("\"residence\".mall_id is null");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNotNull() {
            addCriterion("\"residence\".mall_id is not null");
            return (Criteria) this;
        }

        public Criteria andMallIdEqualTo(Long value) {
            addCriterion("\"residence\".mall_id =", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotEqualTo(Long value) {
            addCriterion("\"residence\".mall_id <>", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThan(Long value) {
            addCriterion("\"residence\".mall_id >", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"residence\".mall_id >=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThan(Long value) {
            addCriterion("\"residence\".mall_id <", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThanOrEqualTo(Long value) {
            addCriterion("\"residence\".mall_id <=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdIn(List<Long> values) {
            addCriterion("\"residence\".mall_id in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotIn(List<Long> values) {
            addCriterion("\"residence\".mall_id not in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdBetween(Long value1, Long value2) {
            addCriterion("\"residence\".mall_id between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotBetween(Long value1, Long value2) {
            addCriterion("\"residence\".mall_id not between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNull() {
            addCriterion("\"residence\".account_id is null");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNotNull() {
            addCriterion("\"residence\".account_id is not null");
            return (Criteria) this;
        }

        public Criteria andAccountIdEqualTo(Long value) {
            addCriterion("\"residence\".account_id =", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotEqualTo(Long value) {
            addCriterion("\"residence\".account_id <>", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThan(Long value) {
            addCriterion("\"residence\".account_id >", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"residence\".account_id >=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThan(Long value) {
            addCriterion("\"residence\".account_id <", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThanOrEqualTo(Long value) {
            addCriterion("\"residence\".account_id <=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIn(List<Long> values) {
            addCriterion("\"residence\".account_id in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotIn(List<Long> values) {
            addCriterion("\"residence\".account_id not in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdBetween(Long value1, Long value2) {
            addCriterion("\"residence\".account_id between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotBetween(Long value1, Long value2) {
            addCriterion("\"residence\".account_id not between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andArrFacePicIsNull() {
            addCriterion("\"residence\".arr_face_pic is null");
            return (Criteria) this;
        }

        public Criteria andArrFacePicIsNotNull() {
            addCriterion("\"residence\".arr_face_pic is not null");
            return (Criteria) this;
        }

        public Criteria andArrFacePicEqualTo(String value) {
            addCriterion("\"residence\".arr_face_pic =", value, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrFacePicNotEqualTo(String value) {
            addCriterion("\"residence\".arr_face_pic <>", value, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrFacePicGreaterThan(String value) {
            addCriterion("\"residence\".arr_face_pic >", value, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrFacePicGreaterThanOrEqualTo(String value) {
            addCriterion("\"residence\".arr_face_pic >=", value, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrFacePicLessThan(String value) {
            addCriterion("\"residence\".arr_face_pic <", value, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrFacePicLessThanOrEqualTo(String value) {
            addCriterion("\"residence\".arr_face_pic <=", value, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrFacePicLike(String value) {
            addCriterion("\"residence\".arr_face_pic like", value, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrFacePicNotLike(String value) {
            addCriterion("\"residence\".arr_face_pic not like", value, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrFacePicIn(List<String> values) {
            addCriterion("\"residence\".arr_face_pic in", values, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrFacePicNotIn(List<String> values) {
            addCriterion("\"residence\".arr_face_pic not in", values, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrFacePicBetween(String value1, String value2) {
            addCriterion("\"residence\".arr_face_pic between", value1, value2, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrFacePicNotBetween(String value1, String value2) {
            addCriterion("\"residence\".arr_face_pic not between", value1, value2, "arrFacePic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicIsNull() {
            addCriterion("\"residence\".arr_body_pic is null");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicIsNotNull() {
            addCriterion("\"residence\".arr_body_pic is not null");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicEqualTo(String value) {
            addCriterion("\"residence\".arr_body_pic =", value, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicNotEqualTo(String value) {
            addCriterion("\"residence\".arr_body_pic <>", value, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicGreaterThan(String value) {
            addCriterion("\"residence\".arr_body_pic >", value, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicGreaterThanOrEqualTo(String value) {
            addCriterion("\"residence\".arr_body_pic >=", value, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicLessThan(String value) {
            addCriterion("\"residence\".arr_body_pic <", value, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicLessThanOrEqualTo(String value) {
            addCriterion("\"residence\".arr_body_pic <=", value, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicLike(String value) {
            addCriterion("\"residence\".arr_body_pic like", value, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicNotLike(String value) {
            addCriterion("\"residence\".arr_body_pic not like", value, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicIn(List<String> values) {
            addCriterion("\"residence\".arr_body_pic in", values, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicNotIn(List<String> values) {
            addCriterion("\"residence\".arr_body_pic not in", values, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicBetween(String value1, String value2) {
            addCriterion("\"residence\".arr_body_pic between", value1, value2, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andArrBodyPicNotBetween(String value1, String value2) {
            addCriterion("\"residence\".arr_body_pic not between", value1, value2, "arrBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicIsNull() {
            addCriterion("\"residence\".leave_body_pic is null");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicIsNotNull() {
            addCriterion("\"residence\".leave_body_pic is not null");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicEqualTo(String value) {
            addCriterion("\"residence\".leave_body_pic =", value, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicNotEqualTo(String value) {
            addCriterion("\"residence\".leave_body_pic <>", value, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicGreaterThan(String value) {
            addCriterion("\"residence\".leave_body_pic >", value, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicGreaterThanOrEqualTo(String value) {
            addCriterion("\"residence\".leave_body_pic >=", value, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicLessThan(String value) {
            addCriterion("\"residence\".leave_body_pic <", value, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicLessThanOrEqualTo(String value) {
            addCriterion("\"residence\".leave_body_pic <=", value, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicLike(String value) {
            addCriterion("\"residence\".leave_body_pic like", value, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicNotLike(String value) {
            addCriterion("\"residence\".leave_body_pic not like", value, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicIn(List<String> values) {
            addCriterion("\"residence\".leave_body_pic in", values, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicNotIn(List<String> values) {
            addCriterion("\"residence\".leave_body_pic not in", values, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicBetween(String value1, String value2) {
            addCriterion("\"residence\".leave_body_pic between", value1, value2, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveBodyPicNotBetween(String value1, String value2) {
            addCriterion("\"residence\".leave_body_pic not between", value1, value2, "leaveBodyPic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicIsNull() {
            addCriterion("\"residence\".leave_face_pic is null");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicIsNotNull() {
            addCriterion("\"residence\".leave_face_pic is not null");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicEqualTo(String value) {
            addCriterion("\"residence\".leave_face_pic =", value, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicNotEqualTo(String value) {
            addCriterion("\"residence\".leave_face_pic <>", value, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicGreaterThan(String value) {
            addCriterion("\"residence\".leave_face_pic >", value, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicGreaterThanOrEqualTo(String value) {
            addCriterion("\"residence\".leave_face_pic >=", value, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicLessThan(String value) {
            addCriterion("\"residence\".leave_face_pic <", value, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicLessThanOrEqualTo(String value) {
            addCriterion("\"residence\".leave_face_pic <=", value, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicLike(String value) {
            addCriterion("\"residence\".leave_face_pic like", value, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicNotLike(String value) {
            addCriterion("\"residence\".leave_face_pic not like", value, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicIn(List<String> values) {
            addCriterion("\"residence\".leave_face_pic in", values, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicNotIn(List<String> values) {
            addCriterion("\"residence\".leave_face_pic not in", values, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicBetween(String value1, String value2) {
            addCriterion("\"residence\".leave_face_pic between", value1, value2, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andLeaveFacePicNotBetween(String value1, String value2) {
            addCriterion("\"residence\".leave_face_pic not between", value1, value2, "leaveFacePic");
            return (Criteria) this;
        }

        public Criteria andArrivalIdIsNull() {
            addCriterion("\"residence\".arrival_id is null");
            return (Criteria) this;
        }

        public Criteria andArrivalIdIsNotNull() {
            addCriterion("\"residence\".arrival_id is not null");
            return (Criteria) this;
        }

        public Criteria andArrivalIdEqualTo(Long value) {
            addCriterion("\"residence\".arrival_id =", value, "arrivalId");
            return (Criteria) this;
        }

        public Criteria andArrivalIdNotEqualTo(Long value) {
            addCriterion("\"residence\".arrival_id <>", value, "arrivalId");
            return (Criteria) this;
        }

        public Criteria andArrivalIdGreaterThan(Long value) {
            addCriterion("\"residence\".arrival_id >", value, "arrivalId");
            return (Criteria) this;
        }

        public Criteria andArrivalIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"residence\".arrival_id >=", value, "arrivalId");
            return (Criteria) this;
        }

        public Criteria andArrivalIdLessThan(Long value) {
            addCriterion("\"residence\".arrival_id <", value, "arrivalId");
            return (Criteria) this;
        }

        public Criteria andArrivalIdLessThanOrEqualTo(Long value) {
            addCriterion("\"residence\".arrival_id <=", value, "arrivalId");
            return (Criteria) this;
        }

        public Criteria andArrivalIdIn(List<Long> values) {
            addCriterion("\"residence\".arrival_id in", values, "arrivalId");
            return (Criteria) this;
        }

        public Criteria andArrivalIdNotIn(List<Long> values) {
            addCriterion("\"residence\".arrival_id not in", values, "arrivalId");
            return (Criteria) this;
        }

        public Criteria andArrivalIdBetween(Long value1, Long value2) {
            addCriterion("\"residence\".arrival_id between", value1, value2, "arrivalId");
            return (Criteria) this;
        }

        public Criteria andArrivalIdNotBetween(Long value1, Long value2) {
            addCriterion("\"residence\".arrival_id not between", value1, value2, "arrivalId");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidIsNull() {
            addCriterion("\"residence\".arrival_unid is null");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidIsNotNull() {
            addCriterion("\"residence\".arrival_unid is not null");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidEqualTo(String value) {
            addCriterion("\"residence\".arrival_unid =", value, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidNotEqualTo(String value) {
            addCriterion("\"residence\".arrival_unid <>", value, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidGreaterThan(String value) {
            addCriterion("\"residence\".arrival_unid >", value, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidGreaterThanOrEqualTo(String value) {
            addCriterion("\"residence\".arrival_unid >=", value, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidLessThan(String value) {
            addCriterion("\"residence\".arrival_unid <", value, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidLessThanOrEqualTo(String value) {
            addCriterion("\"residence\".arrival_unid <=", value, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidLike(String value) {
            addCriterion("\"residence\".arrival_unid like", value, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidNotLike(String value) {
            addCriterion("\"residence\".arrival_unid not like", value, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidIn(List<String> values) {
            addCriterion("\"residence\".arrival_unid in", values, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidNotIn(List<String> values) {
            addCriterion("\"residence\".arrival_unid not in", values, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidBetween(String value1, String value2) {
            addCriterion("\"residence\".arrival_unid between", value1, value2, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andArrivalUnidNotBetween(String value1, String value2) {
            addCriterion("\"residence\".arrival_unid not between", value1, value2, "arrivalUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveIdIsNull() {
            addCriterion("\"residence\".leave_id is null");
            return (Criteria) this;
        }

        public Criteria andLeaveIdIsNotNull() {
            addCriterion("\"residence\".leave_id is not null");
            return (Criteria) this;
        }

        public Criteria andLeaveIdEqualTo(Long value) {
            addCriterion("\"residence\".leave_id =", value, "leaveId");
            return (Criteria) this;
        }

        public Criteria andLeaveIdNotEqualTo(Long value) {
            addCriterion("\"residence\".leave_id <>", value, "leaveId");
            return (Criteria) this;
        }

        public Criteria andLeaveIdGreaterThan(Long value) {
            addCriterion("\"residence\".leave_id >", value, "leaveId");
            return (Criteria) this;
        }

        public Criteria andLeaveIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"residence\".leave_id >=", value, "leaveId");
            return (Criteria) this;
        }

        public Criteria andLeaveIdLessThan(Long value) {
            addCriterion("\"residence\".leave_id <", value, "leaveId");
            return (Criteria) this;
        }

        public Criteria andLeaveIdLessThanOrEqualTo(Long value) {
            addCriterion("\"residence\".leave_id <=", value, "leaveId");
            return (Criteria) this;
        }

        public Criteria andLeaveIdIn(List<Long> values) {
            addCriterion("\"residence\".leave_id in", values, "leaveId");
            return (Criteria) this;
        }

        public Criteria andLeaveIdNotIn(List<Long> values) {
            addCriterion("\"residence\".leave_id not in", values, "leaveId");
            return (Criteria) this;
        }

        public Criteria andLeaveIdBetween(Long value1, Long value2) {
            addCriterion("\"residence\".leave_id between", value1, value2, "leaveId");
            return (Criteria) this;
        }

        public Criteria andLeaveIdNotBetween(Long value1, Long value2) {
            addCriterion("\"residence\".leave_id not between", value1, value2, "leaveId");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidIsNull() {
            addCriterion("\"residence\".leave_unid is null");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidIsNotNull() {
            addCriterion("\"residence\".leave_unid is not null");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidEqualTo(String value) {
            addCriterion("\"residence\".leave_unid =", value, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidNotEqualTo(String value) {
            addCriterion("\"residence\".leave_unid <>", value, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidGreaterThan(String value) {
            addCriterion("\"residence\".leave_unid >", value, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidGreaterThanOrEqualTo(String value) {
            addCriterion("\"residence\".leave_unid >=", value, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidLessThan(String value) {
            addCriterion("\"residence\".leave_unid <", value, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidLessThanOrEqualTo(String value) {
            addCriterion("\"residence\".leave_unid <=", value, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidLike(String value) {
            addCriterion("\"residence\".leave_unid like", value, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidNotLike(String value) {
            addCriterion("\"residence\".leave_unid not like", value, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidIn(List<String> values) {
            addCriterion("\"residence\".leave_unid in", values, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidNotIn(List<String> values) {
            addCriterion("\"residence\".leave_unid not in", values, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidBetween(String value1, String value2) {
            addCriterion("\"residence\".leave_unid between", value1, value2, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andLeaveUnidNotBetween(String value1, String value2) {
            addCriterion("\"residence\".leave_unid not between", value1, value2, "leaveUnid");
            return (Criteria) this;
        }

        public Criteria andAgeIsNull() {
            addCriterion("\"residence\".age is null");
            return (Criteria) this;
        }

        public Criteria andAgeIsNotNull() {
            addCriterion("\"residence\".age is not null");
            return (Criteria) this;
        }

        public Criteria andAgeEqualTo(Short value) {
            addCriterion("\"residence\".age =", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeNotEqualTo(Short value) {
            addCriterion("\"residence\".age <>", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeGreaterThan(Short value) {
            addCriterion("\"residence\".age >", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeGreaterThanOrEqualTo(Short value) {
            addCriterion("\"residence\".age >=", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeLessThan(Short value) {
            addCriterion("\"residence\".age <", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeLessThanOrEqualTo(Short value) {
            addCriterion("\"residence\".age <=", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeIn(List<Short> values) {
            addCriterion("\"residence\".age in", values, "age");
            return (Criteria) this;
        }

        public Criteria andAgeNotIn(List<Short> values) {
            addCriterion("\"residence\".age not in", values, "age");
            return (Criteria) this;
        }

        public Criteria andAgeBetween(Short value1, Short value2) {
            addCriterion("\"residence\".age between", value1, value2, "age");
            return (Criteria) this;
        }

        public Criteria andAgeNotBetween(Short value1, Short value2) {
            addCriterion("\"residence\".age not between", value1, value2, "age");
            return (Criteria) this;
        }

        public Criteria andGenderIsNull() {
            addCriterion("\"residence\".gender is null");
            return (Criteria) this;
        }

        public Criteria andGenderIsNotNull() {
            addCriterion("\"residence\".gender is not null");
            return (Criteria) this;
        }

        public Criteria andGenderEqualTo(Short value) {
            addCriterion("\"residence\".gender =", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderNotEqualTo(Short value) {
            addCriterion("\"residence\".gender <>", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderGreaterThan(Short value) {
            addCriterion("\"residence\".gender >", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderGreaterThanOrEqualTo(Short value) {
            addCriterion("\"residence\".gender >=", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderLessThan(Short value) {
            addCriterion("\"residence\".gender <", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderLessThanOrEqualTo(Short value) {
            addCriterion("\"residence\".gender <=", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderIn(List<Short> values) {
            addCriterion("\"residence\".gender in", values, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderNotIn(List<Short> values) {
            addCriterion("\"residence\".gender not in", values, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderBetween(Short value1, Short value2) {
            addCriterion("\"residence\".gender between", value1, value2, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderNotBetween(Short value1, Short value2) {
            addCriterion("\"residence\".gender not between", value1, value2, "gender");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeIsNull() {
            addCriterion("\"residence\".arrival_time is null");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeIsNotNull() {
            addCriterion("\"residence\".arrival_time is not null");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeEqualTo(Date value) {
            addCriterion("\"residence\".arrival_time =", value, "arrivalTime");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeNotEqualTo(Date value) {
            addCriterion("\"residence\".arrival_time <>", value, "arrivalTime");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeGreaterThan(Date value) {
            addCriterion("\"residence\".arrival_time >", value, "arrivalTime");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"residence\".arrival_time >=", value, "arrivalTime");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeLessThan(Date value) {
            addCriterion("\"residence\".arrival_time <", value, "arrivalTime");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"residence\".arrival_time <=", value, "arrivalTime");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeIn(List<Date> values) {
            addCriterion("\"residence\".arrival_time in", values, "arrivalTime");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeNotIn(List<Date> values) {
            addCriterion("\"residence\".arrival_time not in", values, "arrivalTime");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeBetween(Date value1, Date value2) {
            addCriterion("\"residence\".arrival_time between", value1, value2, "arrivalTime");
            return (Criteria) this;
        }

        public Criteria andArrivalTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"residence\".arrival_time not between", value1, value2, "arrivalTime");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeIsNull() {
            addCriterion("\"residence\".leave_time is null");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeIsNotNull() {
            addCriterion("\"residence\".leave_time is not null");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeEqualTo(Date value) {
            addCriterion("\"residence\".leave_time =", value, "leaveTime");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeNotEqualTo(Date value) {
            addCriterion("\"residence\".leave_time <>", value, "leaveTime");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeGreaterThan(Date value) {
            addCriterion("\"residence\".leave_time >", value, "leaveTime");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"residence\".leave_time >=", value, "leaveTime");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeLessThan(Date value) {
            addCriterion("\"residence\".leave_time <", value, "leaveTime");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"residence\".leave_time <=", value, "leaveTime");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeIn(List<Date> values) {
            addCriterion("\"residence\".leave_time in", values, "leaveTime");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeNotIn(List<Date> values) {
            addCriterion("\"residence\".leave_time not in", values, "leaveTime");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeBetween(Date value1, Date value2) {
            addCriterion("\"residence\".leave_time between", value1, value2, "leaveTime");
            return (Criteria) this;
        }

        public Criteria andLeaveTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"residence\".leave_time not between", value1, value2, "leaveTime");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeIsNull() {
            addCriterion("\"residence\".residence_time is null");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeIsNotNull() {
            addCriterion("\"residence\".residence_time is not null");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeEqualTo(Integer value) {
            addCriterion("\"residence\".residence_time =", value, "residenceTime");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeNotEqualTo(Integer value) {
            addCriterion("\"residence\".residence_time <>", value, "residenceTime");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeGreaterThan(Integer value) {
            addCriterion("\"residence\".residence_time >", value, "residenceTime");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"residence\".residence_time >=", value, "residenceTime");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeLessThan(Integer value) {
            addCriterion("\"residence\".residence_time <", value, "residenceTime");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeLessThanOrEqualTo(Integer value) {
            addCriterion("\"residence\".residence_time <=", value, "residenceTime");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeIn(List<Integer> values) {
            addCriterion("\"residence\".residence_time in", values, "residenceTime");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeNotIn(List<Integer> values) {
            addCriterion("\"residence\".residence_time not in", values, "residenceTime");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeBetween(Integer value1, Integer value2) {
            addCriterion("\"residence\".residence_time between", value1, value2, "residenceTime");
            return (Criteria) this;
        }

        public Criteria andResidenceTimeNotBetween(Integer value1, Integer value2) {
            addCriterion("\"residence\".residence_time not between", value1, value2, "residenceTime");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNull() {
            addCriterion("\"residence\".countdate is null");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNotNull() {
            addCriterion("\"residence\".countdate is not null");
            return (Criteria) this;
        }

        public Criteria andCountdateEqualTo(Date value) {
            addCriterionForJDBCDate("\"residence\".countdate =", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotEqualTo(Date value) {
            addCriterionForJDBCDate("\"residence\".countdate <>", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThan(Date value) {
            addCriterionForJDBCDate("\"residence\".countdate >", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"residence\".countdate >=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThan(Date value) {
            addCriterionForJDBCDate("\"residence\".countdate <", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"residence\".countdate <=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateIn(List<Date> values) {
            addCriterionForJDBCDate("\"residence\".countdate in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotIn(List<Date> values) {
            addCriterionForJDBCDate("\"residence\".countdate not in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"residence\".countdate between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"residence\".countdate not between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNull() {
            addCriterion("\"residence\".counttime is null");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNotNull() {
            addCriterion("\"residence\".counttime is not null");
            return (Criteria) this;
        }

        public Criteria andCounttimeEqualTo(Date value) {
            addCriterion("\"residence\".counttime =", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotEqualTo(Date value) {
            addCriterion("\"residence\".counttime <>", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThan(Date value) {
            addCriterion("\"residence\".counttime >", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"residence\".counttime >=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThan(Date value) {
            addCriterion("\"residence\".counttime <", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThanOrEqualTo(Date value) {
            addCriterion("\"residence\".counttime <=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeIn(List<Date> values) {
            addCriterion("\"residence\".counttime in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotIn(List<Date> values) {
            addCriterion("\"residence\".counttime not in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeBetween(Date value1, Date value2) {
            addCriterion("\"residence\".counttime between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotBetween(Date value1, Date value2) {
            addCriterion("\"residence\".counttime not between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"residence\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"residence\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"residence\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"residence\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"residence\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"residence\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"residence\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"residence\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"residence\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"residence\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"residence\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"residence\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"residence\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"residence\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"residence\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"residence\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"residence\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"residence\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"residence\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"residence\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"residence\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"residence\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"residence\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"residence\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andArrMoodIsNull() {
            addCriterion("\"residence\".arr_mood is null");
            return (Criteria) this;
        }

        public Criteria andArrMoodIsNotNull() {
            addCriterion("\"residence\".arr_mood is not null");
            return (Criteria) this;
        }

        public Criteria andArrMoodEqualTo(Short value) {
            addCriterion("\"residence\".arr_mood =", value, "arrMood");
            return (Criteria) this;
        }

        public Criteria andArrMoodNotEqualTo(Short value) {
            addCriterion("\"residence\".arr_mood <>", value, "arrMood");
            return (Criteria) this;
        }

        public Criteria andArrMoodGreaterThan(Short value) {
            addCriterion("\"residence\".arr_mood >", value, "arrMood");
            return (Criteria) this;
        }

        public Criteria andArrMoodGreaterThanOrEqualTo(Short value) {
            addCriterion("\"residence\".arr_mood >=", value, "arrMood");
            return (Criteria) this;
        }

        public Criteria andArrMoodLessThan(Short value) {
            addCriterion("\"residence\".arr_mood <", value, "arrMood");
            return (Criteria) this;
        }

        public Criteria andArrMoodLessThanOrEqualTo(Short value) {
            addCriterion("\"residence\".arr_mood <=", value, "arrMood");
            return (Criteria) this;
        }

        public Criteria andArrMoodIn(List<Short> values) {
            addCriterion("\"residence\".arr_mood in", values, "arrMood");
            return (Criteria) this;
        }

        public Criteria andArrMoodNotIn(List<Short> values) {
            addCriterion("\"residence\".arr_mood not in", values, "arrMood");
            return (Criteria) this;
        }

        public Criteria andArrMoodBetween(Short value1, Short value2) {
            addCriterion("\"residence\".arr_mood between", value1, value2, "arrMood");
            return (Criteria) this;
        }

        public Criteria andArrMoodNotBetween(Short value1, Short value2) {
            addCriterion("\"residence\".arr_mood not between", value1, value2, "arrMood");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodIsNull() {
            addCriterion("\"residence\".leave_mood is null");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodIsNotNull() {
            addCriterion("\"residence\".leave_mood is not null");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodEqualTo(Short value) {
            addCriterion("\"residence\".leave_mood =", value, "leaveMood");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodNotEqualTo(Short value) {
            addCriterion("\"residence\".leave_mood <>", value, "leaveMood");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodGreaterThan(Short value) {
            addCriterion("\"residence\".leave_mood >", value, "leaveMood");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodGreaterThanOrEqualTo(Short value) {
            addCriterion("\"residence\".leave_mood >=", value, "leaveMood");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodLessThan(Short value) {
            addCriterion("\"residence\".leave_mood <", value, "leaveMood");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodLessThanOrEqualTo(Short value) {
            addCriterion("\"residence\".leave_mood <=", value, "leaveMood");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodIn(List<Short> values) {
            addCriterion("\"residence\".leave_mood in", values, "leaveMood");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodNotIn(List<Short> values) {
            addCriterion("\"residence\".leave_mood not in", values, "leaveMood");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodBetween(Short value1, Short value2) {
            addCriterion("\"residence\".leave_mood between", value1, value2, "leaveMood");
            return (Criteria) this;
        }

        public Criteria andLeaveMoodNotBetween(Short value1, Short value2) {
            addCriterion("\"residence\".leave_mood not between", value1, value2, "leaveMood");
            return (Criteria) this;
        }

        public Criteria andRealIsNull() {
            addCriterion("\"residence\".\"real\" is null");
            return (Criteria) this;
        }

        public Criteria andRealIsNotNull() {
            addCriterion("\"residence\".\"real\" is not null");
            return (Criteria) this;
        }

        public Criteria andRealEqualTo(Short value) {
            addCriterion("\"residence\".\"real\" =", value, "real");
            return (Criteria) this;
        }

        public Criteria andRealNotEqualTo(Short value) {
            addCriterion("\"residence\".\"real\" <>", value, "real");
            return (Criteria) this;
        }

        public Criteria andRealGreaterThan(Short value) {
            addCriterion("\"residence\".\"real\" >", value, "real");
            return (Criteria) this;
        }

        public Criteria andRealGreaterThanOrEqualTo(Short value) {
            addCriterion("\"residence\".\"real\" >=", value, "real");
            return (Criteria) this;
        }

        public Criteria andRealLessThan(Short value) {
            addCriterion("\"residence\".\"real\" <", value, "real");
            return (Criteria) this;
        }

        public Criteria andRealLessThanOrEqualTo(Short value) {
            addCriterion("\"residence\".\"real\" <=", value, "real");
            return (Criteria) this;
        }

        public Criteria andRealIn(List<Short> values) {
            addCriterion("\"residence\".\"real\" in", values, "real");
            return (Criteria) this;
        }

        public Criteria andRealNotIn(List<Short> values) {
            addCriterion("\"residence\".\"real\" not in", values, "real");
            return (Criteria) this;
        }

        public Criteria andRealBetween(Short value1, Short value2) {
            addCriterion("\"residence\".\"real\" between", value1, value2, "real");
            return (Criteria) this;
        }

        public Criteria andRealNotBetween(Short value1, Short value2) {
            addCriterion("\"residence\".\"real\" not between", value1, value2, "real");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"residence\".id as residence_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMallIdColumn() {
            addColumnStr("\"residence\".mall_id as residence_mall_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAccountIdColumn() {
            addColumnStr("\"residence\".account_id as residence_account_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasArrFacePicColumn() {
            addColumnStr("\"residence\".arr_face_pic as residence_arr_face_pic ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasArrBodyPicColumn() {
            addColumnStr("\"residence\".arr_body_pic as residence_arr_body_pic ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasLeaveBodyPicColumn() {
            addColumnStr("\"residence\".leave_body_pic as residence_leave_body_pic ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasLeaveFacePicColumn() {
            addColumnStr("\"residence\".leave_face_pic as residence_leave_face_pic ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasArrivalIdColumn() {
            addColumnStr("\"residence\".arrival_id as residence_arrival_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasArrivalUnidColumn() {
            addColumnStr("\"residence\".arrival_unid as residence_arrival_unid ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasLeaveIdColumn() {
            addColumnStr("\"residence\".leave_id as residence_leave_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasLeaveUnidColumn() {
            addColumnStr("\"residence\".leave_unid as residence_leave_unid ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAgeColumn() {
            addColumnStr("\"residence\".age as residence_age ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasGenderColumn() {
            addColumnStr("\"residence\".gender as residence_gender ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasArrivalTimeColumn() {
            addColumnStr("\"residence\".arrival_time as residence_arrival_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasLeaveTimeColumn() {
            addColumnStr("\"residence\".leave_time as residence_leave_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasResidenceTimeColumn() {
            addColumnStr("\"residence\".residence_time as residence_residence_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCountdateColumn() {
            addColumnStr("\"residence\".countdate as residence_countdate ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCounttimeColumn() {
            addColumnStr("\"residence\".counttime as residence_counttime ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"residence\".modify_time as residence_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"residence\".create_time as residence_create_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasArrMoodColumn() {
            addColumnStr("\"residence\".arr_mood as residence_arr_mood ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasLeaveMoodColumn() {
            addColumnStr("\"residence\".leave_mood as residence_leave_mood ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasRealColumn() {
            addColumnStr("\"residence\".\"real\" as \"residence_real\" ");
            return (ColumnContainer) this;
        }
    }
}