package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class HeatmapDataRawExample extends BaseExample {

    public HeatmapDataRawExample() {
        super();
        tableName = "d_heatmap_data_raw";
        tableAlias = "heatmapDataRaw";
        ignoreCase = false;
    }

    public DeviceExample.ColumnContainer createDeviceColumns() {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.ColumnContainer columnContainer = (DeviceExample.ColumnContainer) columnContainerMap.get(deviceExample.getTableName());
         if(columnContainer == null){
            columnContainer = deviceExample.createColumns();
            columnContainerMap.put(deviceExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public DeviceExample.Criteria andDeviceCriteria() {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.Criteria criteria = deviceExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public DeviceExample.Criteria orDeviceCriteria() {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.Criteria criteria = deviceExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public DeviceExample.Criteria andDeviceCriteria(Criteria criteria) {
        DeviceExample deviceExample = new DeviceExample();
        DeviceExample.Criteria newCriteria = deviceExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public ChannelExample.ColumnContainer createChannelColumns() {
        ChannelExample channelExample = new ChannelExample();
        ChannelExample.ColumnContainer columnContainer = (ChannelExample.ColumnContainer) columnContainerMap.get(channelExample.getTableName());
         if(columnContainer == null){
            columnContainer = channelExample.createColumns();
            columnContainerMap.put(channelExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public ChannelExample.Criteria andChannelCriteria() {
        ChannelExample channelExample = new ChannelExample();
        ChannelExample.Criteria criteria = channelExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public ChannelExample.Criteria orChannelCriteria() {
        ChannelExample channelExample = new ChannelExample();
        ChannelExample.Criteria criteria = channelExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public ChannelExample.Criteria andChannelCriteria(Criteria criteria) {
        ChannelExample channelExample = new ChannelExample();
        ChannelExample.Criteria newCriteria = channelExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "d_heatmap_data_raw";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("\"heatmapDataRaw\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"heatmapDataRaw\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"heatmapDataRaw\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"heatmapDataRaw\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"heatmapDataRaw\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"heatmapDataRaw\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"heatmapDataRaw\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"heatmapDataRaw\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"heatmapDataRaw\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"heatmapDataRaw\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"heatmapDataRaw\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"heatmapDataRaw\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIsNull() {
            addCriterion("\"heatmapDataRaw\".device_serialnum is null");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIsNotNull() {
            addCriterion("\"heatmapDataRaw\".device_serialnum is not null");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumEqualTo(String value) {
            addCriterion("\"heatmapDataRaw\".device_serialnum =", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotEqualTo(String value) {
            addCriterion("\"heatmapDataRaw\".device_serialnum <>", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumGreaterThan(String value) {
            addCriterion("\"heatmapDataRaw\".device_serialnum >", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumGreaterThanOrEqualTo(String value) {
            addCriterion("\"heatmapDataRaw\".device_serialnum >=", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLessThan(String value) {
            addCriterion("\"heatmapDataRaw\".device_serialnum <", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLessThanOrEqualTo(String value) {
            addCriterion("\"heatmapDataRaw\".device_serialnum <=", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLike(String value) {
            addCriterion("\"heatmapDataRaw\".device_serialnum like", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotLike(String value) {
            addCriterion("\"heatmapDataRaw\".device_serialnum not like", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIn(List<String> values) {
            addCriterion("\"heatmapDataRaw\".device_serialnum in", values, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotIn(List<String> values) {
            addCriterion("\"heatmapDataRaw\".device_serialnum not in", values, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumBetween(String value1, String value2) {
            addCriterion("\"heatmapDataRaw\".device_serialnum between", value1, value2, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotBetween(String value1, String value2) {
            addCriterion("\"heatmapDataRaw\".device_serialnum not between", value1, value2, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIsNull() {
            addCriterion("\"heatmapDataRaw\".channel_serialnum is null");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIsNotNull() {
            addCriterion("\"heatmapDataRaw\".channel_serialnum is not null");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumEqualTo(String value) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum =", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotEqualTo(String value) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum <>", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumGreaterThan(String value) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum >", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumGreaterThanOrEqualTo(String value) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum >=", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLessThan(String value) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum <", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLessThanOrEqualTo(String value) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum <=", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLike(String value) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum like", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotLike(String value) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum not like", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIn(List<String> values) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum in", values, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotIn(List<String> values) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum not in", values, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumBetween(String value1, String value2) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum between", value1, value2, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotBetween(String value1, String value2) {
            addCriterion("\"heatmapDataRaw\".channel_serialnum not between", value1, value2, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andXIsNull() {
            addCriterion("\"heatmapDataRaw\".x is null");
            return (Criteria) this;
        }

        public Criteria andXIsNotNull() {
            addCriterion("\"heatmapDataRaw\".x is not null");
            return (Criteria) this;
        }

        public Criteria andXEqualTo(Float value) {
            addCriterion("\"heatmapDataRaw\".x =", value, "x");
            return (Criteria) this;
        }

        public Criteria andXNotEqualTo(Float value) {
            addCriterion("\"heatmapDataRaw\".x <>", value, "x");
            return (Criteria) this;
        }

        public Criteria andXGreaterThan(Float value) {
            addCriterion("\"heatmapDataRaw\".x >", value, "x");
            return (Criteria) this;
        }

        public Criteria andXGreaterThanOrEqualTo(Float value) {
            addCriterion("\"heatmapDataRaw\".x >=", value, "x");
            return (Criteria) this;
        }

        public Criteria andXLessThan(Float value) {
            addCriterion("\"heatmapDataRaw\".x <", value, "x");
            return (Criteria) this;
        }

        public Criteria andXLessThanOrEqualTo(Float value) {
            addCriterion("\"heatmapDataRaw\".x <=", value, "x");
            return (Criteria) this;
        }

        public Criteria andXIn(List<Float> values) {
            addCriterion("\"heatmapDataRaw\".x in", values, "x");
            return (Criteria) this;
        }

        public Criteria andXNotIn(List<Float> values) {
            addCriterion("\"heatmapDataRaw\".x not in", values, "x");
            return (Criteria) this;
        }

        public Criteria andXBetween(Float value1, Float value2) {
            addCriterion("\"heatmapDataRaw\".x between", value1, value2, "x");
            return (Criteria) this;
        }

        public Criteria andXNotBetween(Float value1, Float value2) {
            addCriterion("\"heatmapDataRaw\".x not between", value1, value2, "x");
            return (Criteria) this;
        }

        public Criteria andYIsNull() {
            addCriterion("\"heatmapDataRaw\".y is null");
            return (Criteria) this;
        }

        public Criteria andYIsNotNull() {
            addCriterion("\"heatmapDataRaw\".y is not null");
            return (Criteria) this;
        }

        public Criteria andYEqualTo(Float value) {
            addCriterion("\"heatmapDataRaw\".y =", value, "y");
            return (Criteria) this;
        }

        public Criteria andYNotEqualTo(Float value) {
            addCriterion("\"heatmapDataRaw\".y <>", value, "y");
            return (Criteria) this;
        }

        public Criteria andYGreaterThan(Float value) {
            addCriterion("\"heatmapDataRaw\".y >", value, "y");
            return (Criteria) this;
        }

        public Criteria andYGreaterThanOrEqualTo(Float value) {
            addCriterion("\"heatmapDataRaw\".y >=", value, "y");
            return (Criteria) this;
        }

        public Criteria andYLessThan(Float value) {
            addCriterion("\"heatmapDataRaw\".y <", value, "y");
            return (Criteria) this;
        }

        public Criteria andYLessThanOrEqualTo(Float value) {
            addCriterion("\"heatmapDataRaw\".y <=", value, "y");
            return (Criteria) this;
        }

        public Criteria andYIn(List<Float> values) {
            addCriterion("\"heatmapDataRaw\".y in", values, "y");
            return (Criteria) this;
        }

        public Criteria andYNotIn(List<Float> values) {
            addCriterion("\"heatmapDataRaw\".y not in", values, "y");
            return (Criteria) this;
        }

        public Criteria andYBetween(Float value1, Float value2) {
            addCriterion("\"heatmapDataRaw\".y between", value1, value2, "y");
            return (Criteria) this;
        }

        public Criteria andYNotBetween(Float value1, Float value2) {
            addCriterion("\"heatmapDataRaw\".y not between", value1, value2, "y");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNull() {
            addCriterion("\"heatmapDataRaw\".counttime is null");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNotNull() {
            addCriterion("\"heatmapDataRaw\".counttime is not null");
            return (Criteria) this;
        }

        public Criteria andCounttimeEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".counttime =", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".counttime <>", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThan(Date value) {
            addCriterion("\"heatmapDataRaw\".counttime >", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".counttime >=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThan(Date value) {
            addCriterion("\"heatmapDataRaw\".counttime <", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThanOrEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".counttime <=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeIn(List<Date> values) {
            addCriterion("\"heatmapDataRaw\".counttime in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotIn(List<Date> values) {
            addCriterion("\"heatmapDataRaw\".counttime not in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeBetween(Date value1, Date value2) {
            addCriterion("\"heatmapDataRaw\".counttime between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotBetween(Date value1, Date value2) {
            addCriterion("\"heatmapDataRaw\".counttime not between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"heatmapDataRaw\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"heatmapDataRaw\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"heatmapDataRaw\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"heatmapDataRaw\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"heatmapDataRaw\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"heatmapDataRaw\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"heatmapDataRaw\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"heatmapDataRaw\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"heatmapDataRaw\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"heatmapDataRaw\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"heatmapDataRaw\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"heatmapDataRaw\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"heatmapDataRaw\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"heatmapDataRaw\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"heatmapDataRaw\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"heatmapDataRaw\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"heatmapDataRaw\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andSizeIsNull() {
            addCriterion("\"heatmapDataRaw\".\"size\" is null");
            return (Criteria) this;
        }

        public Criteria andSizeIsNotNull() {
            addCriterion("\"heatmapDataRaw\".\"size\" is not null");
            return (Criteria) this;
        }

        public Criteria andSizeEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".\"size\" =", value, "size");
            return (Criteria) this;
        }

        public Criteria andSizeNotEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".\"size\" <>", value, "size");
            return (Criteria) this;
        }

        public Criteria andSizeGreaterThan(Short value) {
            addCriterion("\"heatmapDataRaw\".\"size\" >", value, "size");
            return (Criteria) this;
        }

        public Criteria andSizeGreaterThanOrEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".\"size\" >=", value, "size");
            return (Criteria) this;
        }

        public Criteria andSizeLessThan(Short value) {
            addCriterion("\"heatmapDataRaw\".\"size\" <", value, "size");
            return (Criteria) this;
        }

        public Criteria andSizeLessThanOrEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".\"size\" <=", value, "size");
            return (Criteria) this;
        }

        public Criteria andSizeIn(List<Short> values) {
            addCriterion("\"heatmapDataRaw\".\"size\" in", values, "size");
            return (Criteria) this;
        }

        public Criteria andSizeNotIn(List<Short> values) {
            addCriterion("\"heatmapDataRaw\".\"size\" not in", values, "size");
            return (Criteria) this;
        }

        public Criteria andSizeBetween(Short value1, Short value2) {
            addCriterion("\"heatmapDataRaw\".\"size\" between", value1, value2, "size");
            return (Criteria) this;
        }

        public Criteria andSizeNotBetween(Short value1, Short value2) {
            addCriterion("\"heatmapDataRaw\".\"size\" not between", value1, value2, "size");
            return (Criteria) this;
        }

        public Criteria andScoreIsNull() {
            addCriterion("\"heatmapDataRaw\".score is null");
            return (Criteria) this;
        }

        public Criteria andScoreIsNotNull() {
            addCriterion("\"heatmapDataRaw\".score is not null");
            return (Criteria) this;
        }

        public Criteria andScoreEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".score =", value, "score");
            return (Criteria) this;
        }

        public Criteria andScoreNotEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".score <>", value, "score");
            return (Criteria) this;
        }

        public Criteria andScoreGreaterThan(Short value) {
            addCriterion("\"heatmapDataRaw\".score >", value, "score");
            return (Criteria) this;
        }

        public Criteria andScoreGreaterThanOrEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".score >=", value, "score");
            return (Criteria) this;
        }

        public Criteria andScoreLessThan(Short value) {
            addCriterion("\"heatmapDataRaw\".score <", value, "score");
            return (Criteria) this;
        }

        public Criteria andScoreLessThanOrEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".score <=", value, "score");
            return (Criteria) this;
        }

        public Criteria andScoreIn(List<Short> values) {
            addCriterion("\"heatmapDataRaw\".score in", values, "score");
            return (Criteria) this;
        }

        public Criteria andScoreNotIn(List<Short> values) {
            addCriterion("\"heatmapDataRaw\".score not in", values, "score");
            return (Criteria) this;
        }

        public Criteria andScoreBetween(Short value1, Short value2) {
            addCriterion("\"heatmapDataRaw\".score between", value1, value2, "score");
            return (Criteria) this;
        }

        public Criteria andScoreNotBetween(Short value1, Short value2) {
            addCriterion("\"heatmapDataRaw\".score not between", value1, value2, "score");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNull() {
            addCriterion("\"heatmapDataRaw\".countdate is null");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNotNull() {
            addCriterion("\"heatmapDataRaw\".countdate is not null");
            return (Criteria) this;
        }

        public Criteria andCountdateEqualTo(Date value) {
            addCriterionForJDBCDate("\"heatmapDataRaw\".countdate =", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotEqualTo(Date value) {
            addCriterionForJDBCDate("\"heatmapDataRaw\".countdate <>", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThan(Date value) {
            addCriterionForJDBCDate("\"heatmapDataRaw\".countdate >", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"heatmapDataRaw\".countdate >=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThan(Date value) {
            addCriterionForJDBCDate("\"heatmapDataRaw\".countdate <", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"heatmapDataRaw\".countdate <=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateIn(List<Date> values) {
            addCriterionForJDBCDate("\"heatmapDataRaw\".countdate in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotIn(List<Date> values) {
            addCriterionForJDBCDate("\"heatmapDataRaw\".countdate not in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"heatmapDataRaw\".countdate between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"heatmapDataRaw\".countdate not between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andHourIsNull() {
            addCriterion("\"heatmapDataRaw\".\"hour\" is null");
            return (Criteria) this;
        }

        public Criteria andHourIsNotNull() {
            addCriterion("\"heatmapDataRaw\".\"hour\" is not null");
            return (Criteria) this;
        }

        public Criteria andHourEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".\"hour\" =", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourNotEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".\"hour\" <>", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourGreaterThan(Short value) {
            addCriterion("\"heatmapDataRaw\".\"hour\" >", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourGreaterThanOrEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".\"hour\" >=", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourLessThan(Short value) {
            addCriterion("\"heatmapDataRaw\".\"hour\" <", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourLessThanOrEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".\"hour\" <=", value, "hour");
            return (Criteria) this;
        }

        public Criteria andHourIn(List<Short> values) {
            addCriterion("\"heatmapDataRaw\".\"hour\" in", values, "hour");
            return (Criteria) this;
        }

        public Criteria andHourNotIn(List<Short> values) {
            addCriterion("\"heatmapDataRaw\".\"hour\" not in", values, "hour");
            return (Criteria) this;
        }

        public Criteria andHourBetween(Short value1, Short value2) {
            addCriterion("\"heatmapDataRaw\".\"hour\" between", value1, value2, "hour");
            return (Criteria) this;
        }

        public Criteria andHourNotBetween(Short value1, Short value2) {
            addCriterion("\"heatmapDataRaw\".\"hour\" not between", value1, value2, "hour");
            return (Criteria) this;
        }

        public Criteria andRxIsNull() {
            addCriterion("\"heatmapDataRaw\".rx is null");
            return (Criteria) this;
        }

        public Criteria andRxIsNotNull() {
            addCriterion("\"heatmapDataRaw\".rx is not null");
            return (Criteria) this;
        }

        public Criteria andRxEqualTo(Integer value) {
            addCriterion("\"heatmapDataRaw\".rx =", value, "rx");
            return (Criteria) this;
        }

        public Criteria andRxNotEqualTo(Integer value) {
            addCriterion("\"heatmapDataRaw\".rx <>", value, "rx");
            return (Criteria) this;
        }

        public Criteria andRxGreaterThan(Integer value) {
            addCriterion("\"heatmapDataRaw\".rx >", value, "rx");
            return (Criteria) this;
        }

        public Criteria andRxGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"heatmapDataRaw\".rx >=", value, "rx");
            return (Criteria) this;
        }

        public Criteria andRxLessThan(Integer value) {
            addCriterion("\"heatmapDataRaw\".rx <", value, "rx");
            return (Criteria) this;
        }

        public Criteria andRxLessThanOrEqualTo(Integer value) {
            addCriterion("\"heatmapDataRaw\".rx <=", value, "rx");
            return (Criteria) this;
        }

        public Criteria andRxIn(List<Integer> values) {
            addCriterion("\"heatmapDataRaw\".rx in", values, "rx");
            return (Criteria) this;
        }

        public Criteria andRxNotIn(List<Integer> values) {
            addCriterion("\"heatmapDataRaw\".rx not in", values, "rx");
            return (Criteria) this;
        }

        public Criteria andRxBetween(Integer value1, Integer value2) {
            addCriterion("\"heatmapDataRaw\".rx between", value1, value2, "rx");
            return (Criteria) this;
        }

        public Criteria andRxNotBetween(Integer value1, Integer value2) {
            addCriterion("\"heatmapDataRaw\".rx not between", value1, value2, "rx");
            return (Criteria) this;
        }

        public Criteria andRyIsNull() {
            addCriterion("\"heatmapDataRaw\".ry is null");
            return (Criteria) this;
        }

        public Criteria andRyIsNotNull() {
            addCriterion("\"heatmapDataRaw\".ry is not null");
            return (Criteria) this;
        }

        public Criteria andRyEqualTo(Integer value) {
            addCriterion("\"heatmapDataRaw\".ry =", value, "ry");
            return (Criteria) this;
        }

        public Criteria andRyNotEqualTo(Integer value) {
            addCriterion("\"heatmapDataRaw\".ry <>", value, "ry");
            return (Criteria) this;
        }

        public Criteria andRyGreaterThan(Integer value) {
            addCriterion("\"heatmapDataRaw\".ry >", value, "ry");
            return (Criteria) this;
        }

        public Criteria andRyGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"heatmapDataRaw\".ry >=", value, "ry");
            return (Criteria) this;
        }

        public Criteria andRyLessThan(Integer value) {
            addCriterion("\"heatmapDataRaw\".ry <", value, "ry");
            return (Criteria) this;
        }

        public Criteria andRyLessThanOrEqualTo(Integer value) {
            addCriterion("\"heatmapDataRaw\".ry <=", value, "ry");
            return (Criteria) this;
        }

        public Criteria andRyIn(List<Integer> values) {
            addCriterion("\"heatmapDataRaw\".ry in", values, "ry");
            return (Criteria) this;
        }

        public Criteria andRyNotIn(List<Integer> values) {
            addCriterion("\"heatmapDataRaw\".ry not in", values, "ry");
            return (Criteria) this;
        }

        public Criteria andRyBetween(Integer value1, Integer value2) {
            addCriterion("\"heatmapDataRaw\".ry between", value1, value2, "ry");
            return (Criteria) this;
        }

        public Criteria andRyNotBetween(Integer value1, Integer value2) {
            addCriterion("\"heatmapDataRaw\".ry not between", value1, value2, "ry");
            return (Criteria) this;
        }

        public Criteria andFxIsNull() {
            addCriterion("\"heatmapDataRaw\".fx is null");
            return (Criteria) this;
        }

        public Criteria andFxIsNotNull() {
            addCriterion("\"heatmapDataRaw\".fx is not null");
            return (Criteria) this;
        }

        public Criteria andFxEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".fx =", value, "fx");
            return (Criteria) this;
        }

        public Criteria andFxNotEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".fx <>", value, "fx");
            return (Criteria) this;
        }

        public Criteria andFxGreaterThan(Short value) {
            addCriterion("\"heatmapDataRaw\".fx >", value, "fx");
            return (Criteria) this;
        }

        public Criteria andFxGreaterThanOrEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".fx >=", value, "fx");
            return (Criteria) this;
        }

        public Criteria andFxLessThan(Short value) {
            addCriterion("\"heatmapDataRaw\".fx <", value, "fx");
            return (Criteria) this;
        }

        public Criteria andFxLessThanOrEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".fx <=", value, "fx");
            return (Criteria) this;
        }

        public Criteria andFxIn(List<Short> values) {
            addCriterion("\"heatmapDataRaw\".fx in", values, "fx");
            return (Criteria) this;
        }

        public Criteria andFxNotIn(List<Short> values) {
            addCriterion("\"heatmapDataRaw\".fx not in", values, "fx");
            return (Criteria) this;
        }

        public Criteria andFxBetween(Short value1, Short value2) {
            addCriterion("\"heatmapDataRaw\".fx between", value1, value2, "fx");
            return (Criteria) this;
        }

        public Criteria andFxNotBetween(Short value1, Short value2) {
            addCriterion("\"heatmapDataRaw\".fx not between", value1, value2, "fx");
            return (Criteria) this;
        }

        public Criteria andFyIsNull() {
            addCriterion("\"heatmapDataRaw\".fy is null");
            return (Criteria) this;
        }

        public Criteria andFyIsNotNull() {
            addCriterion("\"heatmapDataRaw\".fy is not null");
            return (Criteria) this;
        }

        public Criteria andFyEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".fy =", value, "fy");
            return (Criteria) this;
        }

        public Criteria andFyNotEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".fy <>", value, "fy");
            return (Criteria) this;
        }

        public Criteria andFyGreaterThan(Short value) {
            addCriterion("\"heatmapDataRaw\".fy >", value, "fy");
            return (Criteria) this;
        }

        public Criteria andFyGreaterThanOrEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".fy >=", value, "fy");
            return (Criteria) this;
        }

        public Criteria andFyLessThan(Short value) {
            addCriterion("\"heatmapDataRaw\".fy <", value, "fy");
            return (Criteria) this;
        }

        public Criteria andFyLessThanOrEqualTo(Short value) {
            addCriterion("\"heatmapDataRaw\".fy <=", value, "fy");
            return (Criteria) this;
        }

        public Criteria andFyIn(List<Short> values) {
            addCriterion("\"heatmapDataRaw\".fy in", values, "fy");
            return (Criteria) this;
        }

        public Criteria andFyNotIn(List<Short> values) {
            addCriterion("\"heatmapDataRaw\".fy not in", values, "fy");
            return (Criteria) this;
        }

        public Criteria andFyBetween(Short value1, Short value2) {
            addCriterion("\"heatmapDataRaw\".fy between", value1, value2, "fy");
            return (Criteria) this;
        }

        public Criteria andFyNotBetween(Short value1, Short value2) {
            addCriterion("\"heatmapDataRaw\".fy not between", value1, value2, "fy");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"heatmapDataRaw\".id as heatmapDataRaw_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasDeviceSerialnumColumn() {
            addColumnStr("\"heatmapDataRaw\".device_serialnum as heatmapDataRaw_device_serialnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasChannelSerialnumColumn() {
            addColumnStr("\"heatmapDataRaw\".channel_serialnum as heatmapDataRaw_channel_serialnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasXColumn() {
            addColumnStr("\"heatmapDataRaw\".x as heatmapDataRaw_x ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasYColumn() {
            addColumnStr("\"heatmapDataRaw\".y as heatmapDataRaw_y ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCounttimeColumn() {
            addColumnStr("\"heatmapDataRaw\".counttime as heatmapDataRaw_counttime ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"heatmapDataRaw\".modify_time as heatmapDataRaw_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"heatmapDataRaw\".create_time as heatmapDataRaw_create_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasSizeColumn() {
            addColumnStr("\"heatmapDataRaw\".\"size\" as \"heatmapDataRaw_size\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasScoreColumn() {
            addColumnStr("\"heatmapDataRaw\".score as heatmapDataRaw_score ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCountdateColumn() {
            addColumnStr("\"heatmapDataRaw\".countdate as heatmapDataRaw_countdate ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasHourColumn() {
            addColumnStr("\"heatmapDataRaw\".\"hour\" as \"heatmapDataRaw_hour\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasRxColumn() {
            addColumnStr("\"heatmapDataRaw\".rx as heatmapDataRaw_rx ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasRyColumn() {
            addColumnStr("\"heatmapDataRaw\".ry as heatmapDataRaw_ry ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFxColumn() {
            addColumnStr("\"heatmapDataRaw\".fx as heatmapDataRaw_fx ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFyColumn() {
            addColumnStr("\"heatmapDataRaw\".fy as heatmapDataRaw_fy ");
            return (ColumnContainer) this;
        }
    }
}