package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class FaceRecognitionRawExample extends BaseExample {

    public FaceRecognitionRawExample() {
        super();
        tableName = "d_face_recognition_raw";
        tableAlias = "faceRecogRaw";
        ignoreCase = false;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "d_face_recognition_raw";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("\"faceRecogRaw\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"faceRecogRaw\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"faceRecogRaw\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"faceRecogRaw\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"faceRecogRaw\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"faceRecogRaw\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"faceRecogRaw\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"faceRecogRaw\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"faceRecogRaw\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"faceRecogRaw\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"faceRecogRaw\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"faceRecogRaw\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andPersonUnidIsNull() {
            addCriterion("\"faceRecogRaw\".person_unid is null");
            return (Criteria) this;
        }

        public Criteria andPersonUnidIsNotNull() {
            addCriterion("\"faceRecogRaw\".person_unid is not null");
            return (Criteria) this;
        }

        public Criteria andPersonUnidEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".person_unid =", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".person_unid <>", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".person_unid >", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".person_unid >=", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidLessThan(String value) {
            addCriterion("\"faceRecogRaw\".person_unid <", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".person_unid <=", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidLike(String value) {
            addCriterion("\"faceRecogRaw\".person_unid like", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidNotLike(String value) {
            addCriterion("\"faceRecogRaw\".person_unid not like", value, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".person_unid in", values, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".person_unid not in", values, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".person_unid between", value1, value2, "personUnid");
            return (Criteria) this;
        }

        public Criteria andPersonUnidNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".person_unid not between", value1, value2, "personUnid");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIsNull() {
            addCriterion("\"faceRecogRaw\".device_serialnum is null");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIsNotNull() {
            addCriterion("\"faceRecogRaw\".device_serialnum is not null");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".device_serialnum =", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".device_serialnum <>", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".device_serialnum >", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".device_serialnum >=", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLessThan(String value) {
            addCriterion("\"faceRecogRaw\".device_serialnum <", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".device_serialnum <=", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLike(String value) {
            addCriterion("\"faceRecogRaw\".device_serialnum like", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotLike(String value) {
            addCriterion("\"faceRecogRaw\".device_serialnum not like", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".device_serialnum in", values, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".device_serialnum not in", values, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".device_serialnum between", value1, value2, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".device_serialnum not between", value1, value2, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIsNull() {
            addCriterion("\"faceRecogRaw\".channel_serialnum is null");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIsNotNull() {
            addCriterion("\"faceRecogRaw\".channel_serialnum is not null");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".channel_serialnum =", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".channel_serialnum <>", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".channel_serialnum >", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".channel_serialnum >=", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLessThan(String value) {
            addCriterion("\"faceRecogRaw\".channel_serialnum <", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".channel_serialnum <=", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLike(String value) {
            addCriterion("\"faceRecogRaw\".channel_serialnum like", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotLike(String value) {
            addCriterion("\"faceRecogRaw\".channel_serialnum not like", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".channel_serialnum in", values, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".channel_serialnum not in", values, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".channel_serialnum between", value1, value2, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".channel_serialnum not between", value1, value2, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andFacePicIsNull() {
            addCriterion("\"faceRecogRaw\".face_pic is null");
            return (Criteria) this;
        }

        public Criteria andFacePicIsNotNull() {
            addCriterion("\"faceRecogRaw\".face_pic is not null");
            return (Criteria) this;
        }

        public Criteria andFacePicEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_pic =", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_pic <>", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".face_pic >", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_pic >=", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicLessThan(String value) {
            addCriterion("\"faceRecogRaw\".face_pic <", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_pic <=", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicLike(String value) {
            addCriterion("\"faceRecogRaw\".face_pic like", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicNotLike(String value) {
            addCriterion("\"faceRecogRaw\".face_pic not like", value, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".face_pic in", values, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".face_pic not in", values, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".face_pic between", value1, value2, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".face_pic not between", value1, value2, "facePic");
            return (Criteria) this;
        }

        public Criteria andFacePicExtIsNull() {
            addCriterion("\"faceRecogRaw\".face_pic_ext is null");
            return (Criteria) this;
        }

        public Criteria andFacePicExtIsNotNull() {
            addCriterion("\"faceRecogRaw\".face_pic_ext is not null");
            return (Criteria) this;
        }

        public Criteria andFacePicExtEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_pic_ext =", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_pic_ext <>", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".face_pic_ext >", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_pic_ext >=", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtLessThan(String value) {
            addCriterion("\"faceRecogRaw\".face_pic_ext <", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_pic_ext <=", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtLike(String value) {
            addCriterion("\"faceRecogRaw\".face_pic_ext like", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtNotLike(String value) {
            addCriterion("\"faceRecogRaw\".face_pic_ext not like", value, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".face_pic_ext in", values, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".face_pic_ext not in", values, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".face_pic_ext between", value1, value2, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andFacePicExtNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".face_pic_ext not between", value1, value2, "facePicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtIsNull() {
            addCriterion("\"faceRecogRaw\".body_pic_ext is null");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtIsNotNull() {
            addCriterion("\"faceRecogRaw\".body_pic_ext is not null");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_pic_ext =", value, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_pic_ext <>", value, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".body_pic_ext >", value, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_pic_ext >=", value, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtLessThan(String value) {
            addCriterion("\"faceRecogRaw\".body_pic_ext <", value, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_pic_ext <=", value, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtLike(String value) {
            addCriterion("\"faceRecogRaw\".body_pic_ext like", value, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtNotLike(String value) {
            addCriterion("\"faceRecogRaw\".body_pic_ext not like", value, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".body_pic_ext in", values, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".body_pic_ext not in", values, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".body_pic_ext between", value1, value2, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicExtNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".body_pic_ext not between", value1, value2, "bodyPicExt");
            return (Criteria) this;
        }

        public Criteria andBodyPicIsNull() {
            addCriterion("\"faceRecogRaw\".body_pic is null");
            return (Criteria) this;
        }

        public Criteria andBodyPicIsNotNull() {
            addCriterion("\"faceRecogRaw\".body_pic is not null");
            return (Criteria) this;
        }

        public Criteria andBodyPicEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_pic =", value, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andBodyPicNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_pic <>", value, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andBodyPicGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".body_pic >", value, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andBodyPicGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_pic >=", value, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andBodyPicLessThan(String value) {
            addCriterion("\"faceRecogRaw\".body_pic <", value, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andBodyPicLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_pic <=", value, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andBodyPicLike(String value) {
            addCriterion("\"faceRecogRaw\".body_pic like", value, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andBodyPicNotLike(String value) {
            addCriterion("\"faceRecogRaw\".body_pic not like", value, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andBodyPicIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".body_pic in", values, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andBodyPicNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".body_pic not in", values, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andBodyPicBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".body_pic between", value1, value2, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andBodyPicNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".body_pic not between", value1, value2, "bodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicIsNull() {
            addCriterion("\"faceRecogRaw\".showbody_pic is null");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicIsNotNull() {
            addCriterion("\"faceRecogRaw\".showbody_pic is not null");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic =", value, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic <>", value, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic >", value, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic >=", value, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicLessThan(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic <", value, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic <=", value, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicLike(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic like", value, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicNotLike(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic not like", value, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".showbody_pic in", values, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".showbody_pic not in", values, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".showbody_pic between", value1, value2, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".showbody_pic not between", value1, value2, "showbodyPic");
            return (Criteria) this;
        }

        public Criteria andMoodIsNull() {
            addCriterion("\"faceRecogRaw\".mood is null");
            return (Criteria) this;
        }

        public Criteria andMoodIsNotNull() {
            addCriterion("\"faceRecogRaw\".mood is not null");
            return (Criteria) this;
        }

        public Criteria andMoodEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".mood =", value, "mood");
            return (Criteria) this;
        }

        public Criteria andMoodNotEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".mood <>", value, "mood");
            return (Criteria) this;
        }

        public Criteria andMoodGreaterThan(Short value) {
            addCriterion("\"faceRecogRaw\".mood >", value, "mood");
            return (Criteria) this;
        }

        public Criteria andMoodGreaterThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".mood >=", value, "mood");
            return (Criteria) this;
        }

        public Criteria andMoodLessThan(Short value) {
            addCriterion("\"faceRecogRaw\".mood <", value, "mood");
            return (Criteria) this;
        }

        public Criteria andMoodLessThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".mood <=", value, "mood");
            return (Criteria) this;
        }

        public Criteria andMoodIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".mood in", values, "mood");
            return (Criteria) this;
        }

        public Criteria andMoodNotIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".mood not in", values, "mood");
            return (Criteria) this;
        }

        public Criteria andMoodBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".mood between", value1, value2, "mood");
            return (Criteria) this;
        }

        public Criteria andMoodNotBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".mood not between", value1, value2, "mood");
            return (Criteria) this;
        }

        public Criteria andAgeIsNull() {
            addCriterion("\"faceRecogRaw\".age is null");
            return (Criteria) this;
        }

        public Criteria andAgeIsNotNull() {
            addCriterion("\"faceRecogRaw\".age is not null");
            return (Criteria) this;
        }

        public Criteria andAgeEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".age =", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeNotEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".age <>", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeGreaterThan(Short value) {
            addCriterion("\"faceRecogRaw\".age >", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeGreaterThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".age >=", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeLessThan(Short value) {
            addCriterion("\"faceRecogRaw\".age <", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeLessThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".age <=", value, "age");
            return (Criteria) this;
        }

        public Criteria andAgeIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".age in", values, "age");
            return (Criteria) this;
        }

        public Criteria andAgeNotIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".age not in", values, "age");
            return (Criteria) this;
        }

        public Criteria andAgeBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".age between", value1, value2, "age");
            return (Criteria) this;
        }

        public Criteria andAgeNotBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".age not between", value1, value2, "age");
            return (Criteria) this;
        }

        public Criteria andGenderIsNull() {
            addCriterion("\"faceRecogRaw\".gender is null");
            return (Criteria) this;
        }

        public Criteria andGenderIsNotNull() {
            addCriterion("\"faceRecogRaw\".gender is not null");
            return (Criteria) this;
        }

        public Criteria andGenderEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".gender =", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderNotEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".gender <>", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderGreaterThan(Short value) {
            addCriterion("\"faceRecogRaw\".gender >", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderGreaterThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".gender >=", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderLessThan(Short value) {
            addCriterion("\"faceRecogRaw\".gender <", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderLessThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".gender <=", value, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".gender in", values, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderNotIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".gender not in", values, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".gender between", value1, value2, "gender");
            return (Criteria) this;
        }

        public Criteria andGenderNotBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".gender not between", value1, value2, "gender");
            return (Criteria) this;
        }

        public Criteria andDirectionIsNull() {
            addCriterion("\"faceRecogRaw\".direction is null");
            return (Criteria) this;
        }

        public Criteria andDirectionIsNotNull() {
            addCriterion("\"faceRecogRaw\".direction is not null");
            return (Criteria) this;
        }

        public Criteria andDirectionEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".direction =", value, "direction");
            return (Criteria) this;
        }

        public Criteria andDirectionNotEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".direction <>", value, "direction");
            return (Criteria) this;
        }

        public Criteria andDirectionGreaterThan(Short value) {
            addCriterion("\"faceRecogRaw\".direction >", value, "direction");
            return (Criteria) this;
        }

        public Criteria andDirectionGreaterThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".direction >=", value, "direction");
            return (Criteria) this;
        }

        public Criteria andDirectionLessThan(Short value) {
            addCriterion("\"faceRecogRaw\".direction <", value, "direction");
            return (Criteria) this;
        }

        public Criteria andDirectionLessThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".direction <=", value, "direction");
            return (Criteria) this;
        }

        public Criteria andDirectionIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".direction in", values, "direction");
            return (Criteria) this;
        }

        public Criteria andDirectionNotIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".direction not in", values, "direction");
            return (Criteria) this;
        }

        public Criteria andDirectionBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".direction between", value1, value2, "direction");
            return (Criteria) this;
        }

        public Criteria andDirectionNotBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".direction not between", value1, value2, "direction");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNull() {
            addCriterion("\"faceRecogRaw\".counttime is null");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNotNull() {
            addCriterion("\"faceRecogRaw\".counttime is not null");
            return (Criteria) this;
        }

        public Criteria andCounttimeEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".counttime =", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".counttime <>", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThan(Date value) {
            addCriterion("\"faceRecogRaw\".counttime >", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".counttime >=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThan(Date value) {
            addCriterion("\"faceRecogRaw\".counttime <", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThanOrEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".counttime <=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeIn(List<Date> values) {
            addCriterion("\"faceRecogRaw\".counttime in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotIn(List<Date> values) {
            addCriterion("\"faceRecogRaw\".counttime not in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeBetween(Date value1, Date value2) {
            addCriterion("\"faceRecogRaw\".counttime between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotBetween(Date value1, Date value2) {
            addCriterion("\"faceRecogRaw\".counttime not between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNull() {
            addCriterion("\"faceRecogRaw\".countdate is null");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNotNull() {
            addCriterion("\"faceRecogRaw\".countdate is not null");
            return (Criteria) this;
        }

        public Criteria andCountdateEqualTo(Date value) {
            addCriterionForJDBCDate("\"faceRecogRaw\".countdate =", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotEqualTo(Date value) {
            addCriterionForJDBCDate("\"faceRecogRaw\".countdate <>", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThan(Date value) {
            addCriterionForJDBCDate("\"faceRecogRaw\".countdate >", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"faceRecogRaw\".countdate >=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThan(Date value) {
            addCriterionForJDBCDate("\"faceRecogRaw\".countdate <", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"faceRecogRaw\".countdate <=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateIn(List<Date> values) {
            addCriterionForJDBCDate("\"faceRecogRaw\".countdate in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotIn(List<Date> values) {
            addCriterionForJDBCDate("\"faceRecogRaw\".countdate not in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"faceRecogRaw\".countdate between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"faceRecogRaw\".countdate not between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"faceRecogRaw\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"faceRecogRaw\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"faceRecogRaw\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"faceRecogRaw\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"faceRecogRaw\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"faceRecogRaw\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"faceRecogRaw\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"faceRecogRaw\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"faceRecogRaw\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"faceRecogRaw\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"faceRecogRaw\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"faceRecogRaw\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"faceRecogRaw\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"faceRecogRaw\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"faceRecogRaw\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"faceRecogRaw\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"faceRecogRaw\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtIsNull() {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext is null");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtIsNotNull() {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext is not null");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext =", value, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext <>", value, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext >", value, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext >=", value, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtLessThan(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext <", value, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext <=", value, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtLike(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext like", value, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtNotLike(String value) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext not like", value, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext in", values, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext not in", values, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext between", value1, value2, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andShowbodyPicExtNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".showbody_pic_ext not between", value1, value2, "showbodyPicExt");
            return (Criteria) this;
        }

        public Criteria andStatusIsNull() {
            addCriterion("\"faceRecogRaw\".\"status\" is null");
            return (Criteria) this;
        }

        public Criteria andStatusIsNotNull() {
            addCriterion("\"faceRecogRaw\".\"status\" is not null");
            return (Criteria) this;
        }

        public Criteria andStatusEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".\"status\" =", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".\"status\" <>", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThan(Short value) {
            addCriterion("\"faceRecogRaw\".\"status\" >", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".\"status\" >=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThan(Short value) {
            addCriterion("\"faceRecogRaw\".\"status\" <", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".\"status\" <=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".\"status\" in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".\"status\" not in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".\"status\" between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".\"status\" not between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureIsNull() {
            addCriterion("\"faceRecogRaw\".body_feature is null");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureIsNotNull() {
            addCriterion("\"faceRecogRaw\".body_feature is not null");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_feature =", value, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_feature <>", value, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".body_feature >", value, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_feature >=", value, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureLessThan(String value) {
            addCriterion("\"faceRecogRaw\".body_feature <", value, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".body_feature <=", value, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureLike(String value) {
            addCriterion("\"faceRecogRaw\".body_feature like", value, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureNotLike(String value) {
            addCriterion("\"faceRecogRaw\".body_feature not like", value, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".body_feature in", values, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".body_feature not in", values, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".body_feature between", value1, value2, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andBodyFeatureNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".body_feature not between", value1, value2, "bodyFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureIsNull() {
            addCriterion("\"faceRecogRaw\".face_feature is null");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureIsNotNull() {
            addCriterion("\"faceRecogRaw\".face_feature is not null");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_feature =", value, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_feature <>", value, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".face_feature >", value, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_feature >=", value, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureLessThan(String value) {
            addCriterion("\"faceRecogRaw\".face_feature <", value, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".face_feature <=", value, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureLike(String value) {
            addCriterion("\"faceRecogRaw\".face_feature like", value, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureNotLike(String value) {
            addCriterion("\"faceRecogRaw\".face_feature not like", value, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".face_feature in", values, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".face_feature not in", values, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".face_feature between", value1, value2, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andFaceFeatureNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".face_feature not between", value1, value2, "faceFeature");
            return (Criteria) this;
        }

        public Criteria andTrackInfoIsNull() {
            addCriterion("\"faceRecogRaw\".track_info is null");
            return (Criteria) this;
        }

        public Criteria andTrackInfoIsNotNull() {
            addCriterion("\"faceRecogRaw\".track_info is not null");
            return (Criteria) this;
        }

        public Criteria andTrackInfoEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".track_info =", value, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackInfoNotEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".track_info <>", value, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackInfoGreaterThan(String value) {
            addCriterion("\"faceRecogRaw\".track_info >", value, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackInfoGreaterThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".track_info >=", value, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackInfoLessThan(String value) {
            addCriterion("\"faceRecogRaw\".track_info <", value, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackInfoLessThanOrEqualTo(String value) {
            addCriterion("\"faceRecogRaw\".track_info <=", value, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackInfoLike(String value) {
            addCriterion("\"faceRecogRaw\".track_info like", value, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackInfoNotLike(String value) {
            addCriterion("\"faceRecogRaw\".track_info not like", value, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackInfoIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".track_info in", values, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackInfoNotIn(List<String> values) {
            addCriterion("\"faceRecogRaw\".track_info not in", values, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackInfoBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".track_info between", value1, value2, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackInfoNotBetween(String value1, String value2) {
            addCriterion("\"faceRecogRaw\".track_info not between", value1, value2, "trackInfo");
            return (Criteria) this;
        }

        public Criteria andTrackLengthIsNull() {
            addCriterion("\"faceRecogRaw\".track_length is null");
            return (Criteria) this;
        }

        public Criteria andTrackLengthIsNotNull() {
            addCriterion("\"faceRecogRaw\".track_length is not null");
            return (Criteria) this;
        }

        public Criteria andTrackLengthEqualTo(Integer value) {
            addCriterion("\"faceRecogRaw\".track_length =", value, "trackLength");
            return (Criteria) this;
        }

        public Criteria andTrackLengthNotEqualTo(Integer value) {
            addCriterion("\"faceRecogRaw\".track_length <>", value, "trackLength");
            return (Criteria) this;
        }

        public Criteria andTrackLengthGreaterThan(Integer value) {
            addCriterion("\"faceRecogRaw\".track_length >", value, "trackLength");
            return (Criteria) this;
        }

        public Criteria andTrackLengthGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"faceRecogRaw\".track_length >=", value, "trackLength");
            return (Criteria) this;
        }

        public Criteria andTrackLengthLessThan(Integer value) {
            addCriterion("\"faceRecogRaw\".track_length <", value, "trackLength");
            return (Criteria) this;
        }

        public Criteria andTrackLengthLessThanOrEqualTo(Integer value) {
            addCriterion("\"faceRecogRaw\".track_length <=", value, "trackLength");
            return (Criteria) this;
        }

        public Criteria andTrackLengthIn(List<Integer> values) {
            addCriterion("\"faceRecogRaw\".track_length in", values, "trackLength");
            return (Criteria) this;
        }

        public Criteria andTrackLengthNotIn(List<Integer> values) {
            addCriterion("\"faceRecogRaw\".track_length not in", values, "trackLength");
            return (Criteria) this;
        }

        public Criteria andTrackLengthBetween(Integer value1, Integer value2) {
            addCriterion("\"faceRecogRaw\".track_length between", value1, value2, "trackLength");
            return (Criteria) this;
        }

        public Criteria andTrackLengthNotBetween(Integer value1, Integer value2) {
            addCriterion("\"faceRecogRaw\".track_length not between", value1, value2, "trackLength");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateIsNull() {
            addCriterion("\"faceRecogRaw\".track_frame_rate is null");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateIsNotNull() {
            addCriterion("\"faceRecogRaw\".track_frame_rate is not null");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateEqualTo(Integer value) {
            addCriterion("\"faceRecogRaw\".track_frame_rate =", value, "trackFrameRate");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateNotEqualTo(Integer value) {
            addCriterion("\"faceRecogRaw\".track_frame_rate <>", value, "trackFrameRate");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateGreaterThan(Integer value) {
            addCriterion("\"faceRecogRaw\".track_frame_rate >", value, "trackFrameRate");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"faceRecogRaw\".track_frame_rate >=", value, "trackFrameRate");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateLessThan(Integer value) {
            addCriterion("\"faceRecogRaw\".track_frame_rate <", value, "trackFrameRate");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateLessThanOrEqualTo(Integer value) {
            addCriterion("\"faceRecogRaw\".track_frame_rate <=", value, "trackFrameRate");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateIn(List<Integer> values) {
            addCriterion("\"faceRecogRaw\".track_frame_rate in", values, "trackFrameRate");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateNotIn(List<Integer> values) {
            addCriterion("\"faceRecogRaw\".track_frame_rate not in", values, "trackFrameRate");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateBetween(Integer value1, Integer value2) {
            addCriterion("\"faceRecogRaw\".track_frame_rate between", value1, value2, "trackFrameRate");
            return (Criteria) this;
        }

        public Criteria andTrackFrameRateNotBetween(Integer value1, Integer value2) {
            addCriterion("\"faceRecogRaw\".track_frame_rate not between", value1, value2, "trackFrameRate");
            return (Criteria) this;
        }

        public Criteria andHappyConfIsNull() {
            addCriterion("\"faceRecogRaw\".happy_conf is null");
            return (Criteria) this;
        }

        public Criteria andHappyConfIsNotNull() {
            addCriterion("\"faceRecogRaw\".happy_conf is not null");
            return (Criteria) this;
        }

        public Criteria andHappyConfEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".happy_conf =", value, "happyConf");
            return (Criteria) this;
        }

        public Criteria andHappyConfNotEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".happy_conf <>", value, "happyConf");
            return (Criteria) this;
        }

        public Criteria andHappyConfGreaterThan(Short value) {
            addCriterion("\"faceRecogRaw\".happy_conf >", value, "happyConf");
            return (Criteria) this;
        }

        public Criteria andHappyConfGreaterThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".happy_conf >=", value, "happyConf");
            return (Criteria) this;
        }

        public Criteria andHappyConfLessThan(Short value) {
            addCriterion("\"faceRecogRaw\".happy_conf <", value, "happyConf");
            return (Criteria) this;
        }

        public Criteria andHappyConfLessThanOrEqualTo(Short value) {
            addCriterion("\"faceRecogRaw\".happy_conf <=", value, "happyConf");
            return (Criteria) this;
        }

        public Criteria andHappyConfIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".happy_conf in", values, "happyConf");
            return (Criteria) this;
        }

        public Criteria andHappyConfNotIn(List<Short> values) {
            addCriterion("\"faceRecogRaw\".happy_conf not in", values, "happyConf");
            return (Criteria) this;
        }

        public Criteria andHappyConfBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".happy_conf between", value1, value2, "happyConf");
            return (Criteria) this;
        }

        public Criteria andHappyConfNotBetween(Short value1, Short value2) {
            addCriterion("\"faceRecogRaw\".happy_conf not between", value1, value2, "happyConf");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"faceRecogRaw\".id as faceRecogRaw_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasPersonUnidColumn() {
            addColumnStr("\"faceRecogRaw\".person_unid as faceRecogRaw_person_unid ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasDeviceSerialnumColumn() {
            addColumnStr("\"faceRecogRaw\".device_serialnum as faceRecogRaw_device_serialnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasChannelSerialnumColumn() {
            addColumnStr("\"faceRecogRaw\".channel_serialnum as faceRecogRaw_channel_serialnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFacePicColumn() {
            addColumnStr("\"faceRecogRaw\".face_pic as faceRecogRaw_face_pic ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFacePicExtColumn() {
            addColumnStr("\"faceRecogRaw\".face_pic_ext as faceRecogRaw_face_pic_ext ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasBodyPicExtColumn() {
            addColumnStr("\"faceRecogRaw\".body_pic_ext as faceRecogRaw_body_pic_ext ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasBodyPicColumn() {
            addColumnStr("\"faceRecogRaw\".body_pic as faceRecogRaw_body_pic ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasShowbodyPicColumn() {
            addColumnStr("\"faceRecogRaw\".showbody_pic as faceRecogRaw_showbody_pic ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMoodColumn() {
            addColumnStr("\"faceRecogRaw\".mood as faceRecogRaw_mood ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAgeColumn() {
            addColumnStr("\"faceRecogRaw\".age as faceRecogRaw_age ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasGenderColumn() {
            addColumnStr("\"faceRecogRaw\".gender as faceRecogRaw_gender ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasDirectionColumn() {
            addColumnStr("\"faceRecogRaw\".direction as faceRecogRaw_direction ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCounttimeColumn() {
            addColumnStr("\"faceRecogRaw\".counttime as faceRecogRaw_counttime ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCountdateColumn() {
            addColumnStr("\"faceRecogRaw\".countdate as faceRecogRaw_countdate ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"faceRecogRaw\".modify_time as faceRecogRaw_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"faceRecogRaw\".create_time as faceRecogRaw_create_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasShowbodyPicExtColumn() {
            addColumnStr("\"faceRecogRaw\".showbody_pic_ext as faceRecogRaw_showbody_pic_ext ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasStatusColumn() {
            addColumnStr("\"faceRecogRaw\".\"status\" as \"faceRecogRaw_status\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasBodyFeatureColumn() {
            addColumnStr("\"faceRecogRaw\".body_feature as faceRecogRaw_body_feature ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasFaceFeatureColumn() {
            addColumnStr("\"faceRecogRaw\".face_feature as faceRecogRaw_face_feature ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasTrackInfoColumn() {
            addColumnStr("\"faceRecogRaw\".track_info as faceRecogRaw_track_info ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasTrackLengthColumn() {
            addColumnStr("\"faceRecogRaw\".track_length as faceRecogRaw_track_length ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasTrackFrameRateColumn() {
            addColumnStr("\"faceRecogRaw\".track_frame_rate as faceRecogRaw_track_frame_rate ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasHappyConfColumn() {
            addColumnStr("\"faceRecogRaw\".happy_conf as faceRecogRaw_happy_conf ");
            return (ColumnContainer) this;
        }
    }
}