package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.Date;
import java.util.List;

public class DeviceExample extends BaseExample {

    public DeviceExample() {
        super();
        tableName = "b_device";
        tableAlias = "device";
        ignoreCase = false;
    }

    public MallExample.ColumnContainer createMallColumns() {
        MallExample mallExample = new MallExample();
        MallExample.ColumnContainer columnContainer = (MallExample.ColumnContainer) columnContainerMap.get(mallExample.getTableName());
         if(columnContainer == null){
            columnContainer = mallExample.createColumns();
            columnContainerMap.put(mallExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public MallExample.Criteria andMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public MallExample.Criteria orMallCriteria() {
        MallExample mallExample = new MallExample();
        MallExample.Criteria criteria = mallExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public MallExample.Criteria andMallCriteria(Criteria criteria) {
        MallExample mallExample = new MallExample();
        MallExample.Criteria newCriteria = mallExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public AccountExample.ColumnContainer createAccountColumns() {
        AccountExample accountExample = new AccountExample();
        AccountExample.ColumnContainer columnContainer = (AccountExample.ColumnContainer) columnContainerMap.get(accountExample.getTableName());
         if(columnContainer == null){
            columnContainer = accountExample.createColumns();
            columnContainerMap.put(accountExample.getTableName(),columnContainer);
        }
        leftJoinTableSet.add(columnContainer.getTableName());
        return columnContainer;
    }

    public AccountExample.Criteria andAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        Criteria myCriteria = null;
        if (oredCriteria.size() == 0) {
            myCriteria =  createCriteriaInternal();
            oredCriteria.add(myCriteria);
        }else{
            myCriteria =  (Criteria)oredCriteria.get(0);
        }
        leftJoinTableSet.add(criteria.getTableName());
        criteria.setAllCriteria(myCriteria.getAllCriteria());
        return criteria;
    }

    public AccountExample.Criteria orAccountCriteria() {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria criteria = accountExample.createCriteria();
        leftJoinTableSet.add(criteria.getTableName());
        oredCriteria.add(criteria);
        return criteria;
    }

    public AccountExample.Criteria andAccountCriteria(Criteria criteria) {
        AccountExample accountExample = new AccountExample();
        AccountExample.Criteria newCriteria = accountExample.createCriteria();
        leftJoinTableSet.add(newCriteria.getTableName());
        newCriteria.setAllCriteria(criteria.getAllCriteria());
        return newCriteria;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "b_device";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        public Criteria andIdIsNull() {
            addCriterion("\"device\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"device\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"device\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"device\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"device\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"device\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"device\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"device\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"device\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"device\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"device\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"device\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andSerialnumIsNull() {
            addCriterion("\"device\".serialnum is null");
            return (Criteria) this;
        }

        public Criteria andSerialnumIsNotNull() {
            addCriterion("\"device\".serialnum is not null");
            return (Criteria) this;
        }

        public Criteria andSerialnumEqualTo(String value) {
            addCriterion("\"device\".serialnum =", value, "serialnum");
            return (Criteria) this;
        }

        public Criteria andSerialnumNotEqualTo(String value) {
            addCriterion("\"device\".serialnum <>", value, "serialnum");
            return (Criteria) this;
        }

        public Criteria andSerialnumGreaterThan(String value) {
            addCriterion("\"device\".serialnum >", value, "serialnum");
            return (Criteria) this;
        }

        public Criteria andSerialnumGreaterThanOrEqualTo(String value) {
            addCriterion("\"device\".serialnum >=", value, "serialnum");
            return (Criteria) this;
        }

        public Criteria andSerialnumLessThan(String value) {
            addCriterion("\"device\".serialnum <", value, "serialnum");
            return (Criteria) this;
        }

        public Criteria andSerialnumLessThanOrEqualTo(String value) {
            addCriterion("\"device\".serialnum <=", value, "serialnum");
            return (Criteria) this;
        }

        public Criteria andSerialnumLike(String value) {
            addCriterion("\"device\".serialnum like", value, "serialnum");
            return (Criteria) this;
        }

        public Criteria andSerialnumNotLike(String value) {
            addCriterion("\"device\".serialnum not like", value, "serialnum");
            return (Criteria) this;
        }

        public Criteria andSerialnumIn(List<String> values) {
            addCriterion("\"device\".serialnum in", values, "serialnum");
            return (Criteria) this;
        }

        public Criteria andSerialnumNotIn(List<String> values) {
            addCriterion("\"device\".serialnum not in", values, "serialnum");
            return (Criteria) this;
        }

        public Criteria andSerialnumBetween(String value1, String value2) {
            addCriterion("\"device\".serialnum between", value1, value2, "serialnum");
            return (Criteria) this;
        }

        public Criteria andSerialnumNotBetween(String value1, String value2) {
            addCriterion("\"device\".serialnum not between", value1, value2, "serialnum");
            return (Criteria) this;
        }

        public Criteria andNameIsNull() {
            addCriterion("\"device\".\"name\" is null");
            return (Criteria) this;
        }

        public Criteria andNameIsNotNull() {
            addCriterion("\"device\".\"name\" is not null");
            return (Criteria) this;
        }

        public Criteria andNameEqualTo(String value) {
            addCriterion("\"device\".\"name\" =", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotEqualTo(String value) {
            addCriterion("\"device\".\"name\" <>", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameGreaterThan(String value) {
            addCriterion("\"device\".\"name\" >", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameGreaterThanOrEqualTo(String value) {
            addCriterion("\"device\".\"name\" >=", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameLessThan(String value) {
            addCriterion("\"device\".\"name\" <", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameLessThanOrEqualTo(String value) {
            addCriterion("\"device\".\"name\" <=", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameLike(String value) {
            addCriterion("\"device\".\"name\" like", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotLike(String value) {
            addCriterion("\"device\".\"name\" not like", value, "name");
            return (Criteria) this;
        }

        public Criteria andNameIn(List<String> values) {
            addCriterion("\"device\".\"name\" in", values, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotIn(List<String> values) {
            addCriterion("\"device\".\"name\" not in", values, "name");
            return (Criteria) this;
        }

        public Criteria andNameBetween(String value1, String value2) {
            addCriterion("\"device\".\"name\" between", value1, value2, "name");
            return (Criteria) this;
        }

        public Criteria andNameNotBetween(String value1, String value2) {
            addCriterion("\"device\".\"name\" not between", value1, value2, "name");
            return (Criteria) this;
        }

        public Criteria andChannelCountIsNull() {
            addCriterion("\"device\".channel_count is null");
            return (Criteria) this;
        }

        public Criteria andChannelCountIsNotNull() {
            addCriterion("\"device\".channel_count is not null");
            return (Criteria) this;
        }

        public Criteria andChannelCountEqualTo(Short value) {
            addCriterion("\"device\".channel_count =", value, "channelCount");
            return (Criteria) this;
        }

        public Criteria andChannelCountNotEqualTo(Short value) {
            addCriterion("\"device\".channel_count <>", value, "channelCount");
            return (Criteria) this;
        }

        public Criteria andChannelCountGreaterThan(Short value) {
            addCriterion("\"device\".channel_count >", value, "channelCount");
            return (Criteria) this;
        }

        public Criteria andChannelCountGreaterThanOrEqualTo(Short value) {
            addCriterion("\"device\".channel_count >=", value, "channelCount");
            return (Criteria) this;
        }

        public Criteria andChannelCountLessThan(Short value) {
            addCriterion("\"device\".channel_count <", value, "channelCount");
            return (Criteria) this;
        }

        public Criteria andChannelCountLessThanOrEqualTo(Short value) {
            addCriterion("\"device\".channel_count <=", value, "channelCount");
            return (Criteria) this;
        }

        public Criteria andChannelCountIn(List<Short> values) {
            addCriterion("\"device\".channel_count in", values, "channelCount");
            return (Criteria) this;
        }

        public Criteria andChannelCountNotIn(List<Short> values) {
            addCriterion("\"device\".channel_count not in", values, "channelCount");
            return (Criteria) this;
        }

        public Criteria andChannelCountBetween(Short value1, Short value2) {
            addCriterion("\"device\".channel_count between", value1, value2, "channelCount");
            return (Criteria) this;
        }

        public Criteria andChannelCountNotBetween(Short value1, Short value2) {
            addCriterion("\"device\".channel_count not between", value1, value2, "channelCount");
            return (Criteria) this;
        }

        public Criteria andMacIsNull() {
            addCriterion("\"device\".mac is null");
            return (Criteria) this;
        }

        public Criteria andMacIsNotNull() {
            addCriterion("\"device\".mac is not null");
            return (Criteria) this;
        }

        public Criteria andMacEqualTo(String value) {
            addCriterion("\"device\".mac =", value, "mac");
            return (Criteria) this;
        }

        public Criteria andMacNotEqualTo(String value) {
            addCriterion("\"device\".mac <>", value, "mac");
            return (Criteria) this;
        }

        public Criteria andMacGreaterThan(String value) {
            addCriterion("\"device\".mac >", value, "mac");
            return (Criteria) this;
        }

        public Criteria andMacGreaterThanOrEqualTo(String value) {
            addCriterion("\"device\".mac >=", value, "mac");
            return (Criteria) this;
        }

        public Criteria andMacLessThan(String value) {
            addCriterion("\"device\".mac <", value, "mac");
            return (Criteria) this;
        }

        public Criteria andMacLessThanOrEqualTo(String value) {
            addCriterion("\"device\".mac <=", value, "mac");
            return (Criteria) this;
        }

        public Criteria andMacLike(String value) {
            addCriterion("\"device\".mac like", value, "mac");
            return (Criteria) this;
        }

        public Criteria andMacNotLike(String value) {
            addCriterion("\"device\".mac not like", value, "mac");
            return (Criteria) this;
        }

        public Criteria andMacIn(List<String> values) {
            addCriterion("\"device\".mac in", values, "mac");
            return (Criteria) this;
        }

        public Criteria andMacNotIn(List<String> values) {
            addCriterion("\"device\".mac not in", values, "mac");
            return (Criteria) this;
        }

        public Criteria andMacBetween(String value1, String value2) {
            addCriterion("\"device\".mac between", value1, value2, "mac");
            return (Criteria) this;
        }

        public Criteria andMacNotBetween(String value1, String value2) {
            addCriterion("\"device\".mac not between", value1, value2, "mac");
            return (Criteria) this;
        }

        public Criteria andLocalIpIsNull() {
            addCriterion("\"device\".local_ip is null");
            return (Criteria) this;
        }

        public Criteria andLocalIpIsNotNull() {
            addCriterion("\"device\".local_ip is not null");
            return (Criteria) this;
        }

        public Criteria andLocalIpEqualTo(String value) {
            addCriterion("\"device\".local_ip =", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpNotEqualTo(String value) {
            addCriterion("\"device\".local_ip <>", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpGreaterThan(String value) {
            addCriterion("\"device\".local_ip >", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpGreaterThanOrEqualTo(String value) {
            addCriterion("\"device\".local_ip >=", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpLessThan(String value) {
            addCriterion("\"device\".local_ip <", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpLessThanOrEqualTo(String value) {
            addCriterion("\"device\".local_ip <=", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpLike(String value) {
            addCriterion("\"device\".local_ip like", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpNotLike(String value) {
            addCriterion("\"device\".local_ip not like", value, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpIn(List<String> values) {
            addCriterion("\"device\".local_ip in", values, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpNotIn(List<String> values) {
            addCriterion("\"device\".local_ip not in", values, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpBetween(String value1, String value2) {
            addCriterion("\"device\".local_ip between", value1, value2, "localIp");
            return (Criteria) this;
        }

        public Criteria andLocalIpNotBetween(String value1, String value2) {
            addCriterion("\"device\".local_ip not between", value1, value2, "localIp");
            return (Criteria) this;
        }

        public Criteria andWanIpIsNull() {
            addCriterion("\"device\".wan_ip is null");
            return (Criteria) this;
        }

        public Criteria andWanIpIsNotNull() {
            addCriterion("\"device\".wan_ip is not null");
            return (Criteria) this;
        }

        public Criteria andWanIpEqualTo(String value) {
            addCriterion("\"device\".wan_ip =", value, "wanIp");
            return (Criteria) this;
        }

        public Criteria andWanIpNotEqualTo(String value) {
            addCriterion("\"device\".wan_ip <>", value, "wanIp");
            return (Criteria) this;
        }

        public Criteria andWanIpGreaterThan(String value) {
            addCriterion("\"device\".wan_ip >", value, "wanIp");
            return (Criteria) this;
        }

        public Criteria andWanIpGreaterThanOrEqualTo(String value) {
            addCriterion("\"device\".wan_ip >=", value, "wanIp");
            return (Criteria) this;
        }

        public Criteria andWanIpLessThan(String value) {
            addCriterion("\"device\".wan_ip <", value, "wanIp");
            return (Criteria) this;
        }

        public Criteria andWanIpLessThanOrEqualTo(String value) {
            addCriterion("\"device\".wan_ip <=", value, "wanIp");
            return (Criteria) this;
        }

        public Criteria andWanIpLike(String value) {
            addCriterion("\"device\".wan_ip like", value, "wanIp");
            return (Criteria) this;
        }

        public Criteria andWanIpNotLike(String value) {
            addCriterion("\"device\".wan_ip not like", value, "wanIp");
            return (Criteria) this;
        }

        public Criteria andWanIpIn(List<String> values) {
            addCriterion("\"device\".wan_ip in", values, "wanIp");
            return (Criteria) this;
        }

        public Criteria andWanIpNotIn(List<String> values) {
            addCriterion("\"device\".wan_ip not in", values, "wanIp");
            return (Criteria) this;
        }

        public Criteria andWanIpBetween(String value1, String value2) {
            addCriterion("\"device\".wan_ip between", value1, value2, "wanIp");
            return (Criteria) this;
        }

        public Criteria andWanIpNotBetween(String value1, String value2) {
            addCriterion("\"device\".wan_ip not between", value1, value2, "wanIp");
            return (Criteria) this;
        }

        public Criteria andSoftwareIsNull() {
            addCriterion("\"device\".software is null");
            return (Criteria) this;
        }

        public Criteria andSoftwareIsNotNull() {
            addCriterion("\"device\".software is not null");
            return (Criteria) this;
        }

        public Criteria andSoftwareEqualTo(String value) {
            addCriterion("\"device\".software =", value, "software");
            return (Criteria) this;
        }

        public Criteria andSoftwareNotEqualTo(String value) {
            addCriterion("\"device\".software <>", value, "software");
            return (Criteria) this;
        }

        public Criteria andSoftwareGreaterThan(String value) {
            addCriterion("\"device\".software >", value, "software");
            return (Criteria) this;
        }

        public Criteria andSoftwareGreaterThanOrEqualTo(String value) {
            addCriterion("\"device\".software >=", value, "software");
            return (Criteria) this;
        }

        public Criteria andSoftwareLessThan(String value) {
            addCriterion("\"device\".software <", value, "software");
            return (Criteria) this;
        }

        public Criteria andSoftwareLessThanOrEqualTo(String value) {
            addCriterion("\"device\".software <=", value, "software");
            return (Criteria) this;
        }

        public Criteria andSoftwareLike(String value) {
            addCriterion("\"device\".software like", value, "software");
            return (Criteria) this;
        }

        public Criteria andSoftwareNotLike(String value) {
            addCriterion("\"device\".software not like", value, "software");
            return (Criteria) this;
        }

        public Criteria andSoftwareIn(List<String> values) {
            addCriterion("\"device\".software in", values, "software");
            return (Criteria) this;
        }

        public Criteria andSoftwareNotIn(List<String> values) {
            addCriterion("\"device\".software not in", values, "software");
            return (Criteria) this;
        }

        public Criteria andSoftwareBetween(String value1, String value2) {
            addCriterion("\"device\".software between", value1, value2, "software");
            return (Criteria) this;
        }

        public Criteria andSoftwareNotBetween(String value1, String value2) {
            addCriterion("\"device\".software not between", value1, value2, "software");
            return (Criteria) this;
        }

        public Criteria andHardwareIsNull() {
            addCriterion("\"device\".hardware is null");
            return (Criteria) this;
        }

        public Criteria andHardwareIsNotNull() {
            addCriterion("\"device\".hardware is not null");
            return (Criteria) this;
        }

        public Criteria andHardwareEqualTo(String value) {
            addCriterion("\"device\".hardware =", value, "hardware");
            return (Criteria) this;
        }

        public Criteria andHardwareNotEqualTo(String value) {
            addCriterion("\"device\".hardware <>", value, "hardware");
            return (Criteria) this;
        }

        public Criteria andHardwareGreaterThan(String value) {
            addCriterion("\"device\".hardware >", value, "hardware");
            return (Criteria) this;
        }

        public Criteria andHardwareGreaterThanOrEqualTo(String value) {
            addCriterion("\"device\".hardware >=", value, "hardware");
            return (Criteria) this;
        }

        public Criteria andHardwareLessThan(String value) {
            addCriterion("\"device\".hardware <", value, "hardware");
            return (Criteria) this;
        }

        public Criteria andHardwareLessThanOrEqualTo(String value) {
            addCriterion("\"device\".hardware <=", value, "hardware");
            return (Criteria) this;
        }

        public Criteria andHardwareLike(String value) {
            addCriterion("\"device\".hardware like", value, "hardware");
            return (Criteria) this;
        }

        public Criteria andHardwareNotLike(String value) {
            addCriterion("\"device\".hardware not like", value, "hardware");
            return (Criteria) this;
        }

        public Criteria andHardwareIn(List<String> values) {
            addCriterion("\"device\".hardware in", values, "hardware");
            return (Criteria) this;
        }

        public Criteria andHardwareNotIn(List<String> values) {
            addCriterion("\"device\".hardware not in", values, "hardware");
            return (Criteria) this;
        }

        public Criteria andHardwareBetween(String value1, String value2) {
            addCriterion("\"device\".hardware between", value1, value2, "hardware");
            return (Criteria) this;
        }

        public Criteria andHardwareNotBetween(String value1, String value2) {
            addCriterion("\"device\".hardware not between", value1, value2, "hardware");
            return (Criteria) this;
        }

        public Criteria andStatusIsNull() {
            addCriterion("\"device\".\"status\" is null");
            return (Criteria) this;
        }

        public Criteria andStatusIsNotNull() {
            addCriterion("\"device\".\"status\" is not null");
            return (Criteria) this;
        }

        public Criteria andStatusEqualTo(Short value) {
            addCriterion("\"device\".\"status\" =", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotEqualTo(Short value) {
            addCriterion("\"device\".\"status\" <>", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThan(Short value) {
            addCriterion("\"device\".\"status\" >", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThanOrEqualTo(Short value) {
            addCriterion("\"device\".\"status\" >=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThan(Short value) {
            addCriterion("\"device\".\"status\" <", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThanOrEqualTo(Short value) {
            addCriterion("\"device\".\"status\" <=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusIn(List<Short> values) {
            addCriterion("\"device\".\"status\" in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotIn(List<Short> values) {
            addCriterion("\"device\".\"status\" not in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusBetween(Short value1, Short value2) {
            addCriterion("\"device\".\"status\" between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotBetween(Short value1, Short value2) {
            addCriterion("\"device\".\"status\" not between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNull() {
            addCriterion("\"device\".mall_id is null");
            return (Criteria) this;
        }

        public Criteria andMallIdIsNotNull() {
            addCriterion("\"device\".mall_id is not null");
            return (Criteria) this;
        }

        public Criteria andMallIdEqualTo(Long value) {
            addCriterion("\"device\".mall_id =", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotEqualTo(Long value) {
            addCriterion("\"device\".mall_id <>", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThan(Long value) {
            addCriterion("\"device\".mall_id >", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"device\".mall_id >=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThan(Long value) {
            addCriterion("\"device\".mall_id <", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdLessThanOrEqualTo(Long value) {
            addCriterion("\"device\".mall_id <=", value, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdIn(List<Long> values) {
            addCriterion("\"device\".mall_id in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotIn(List<Long> values) {
            addCriterion("\"device\".mall_id not in", values, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdBetween(Long value1, Long value2) {
            addCriterion("\"device\".mall_id between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andMallIdNotBetween(Long value1, Long value2) {
            addCriterion("\"device\".mall_id not between", value1, value2, "mallId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNull() {
            addCriterion("\"device\".account_id is null");
            return (Criteria) this;
        }

        public Criteria andAccountIdIsNotNull() {
            addCriterion("\"device\".account_id is not null");
            return (Criteria) this;
        }

        public Criteria andAccountIdEqualTo(Long value) {
            addCriterion("\"device\".account_id =", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotEqualTo(Long value) {
            addCriterion("\"device\".account_id <>", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThan(Long value) {
            addCriterion("\"device\".account_id >", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"device\".account_id >=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThan(Long value) {
            addCriterion("\"device\".account_id <", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdLessThanOrEqualTo(Long value) {
            addCriterion("\"device\".account_id <=", value, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdIn(List<Long> values) {
            addCriterion("\"device\".account_id in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotIn(List<Long> values) {
            addCriterion("\"device\".account_id not in", values, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdBetween(Long value1, Long value2) {
            addCriterion("\"device\".account_id between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andAccountIdNotBetween(Long value1, Long value2) {
            addCriterion("\"device\".account_id not between", value1, value2, "accountId");
            return (Criteria) this;
        }

        public Criteria andIntroIsNull() {
            addCriterion("\"device\".intro is null");
            return (Criteria) this;
        }

        public Criteria andIntroIsNotNull() {
            addCriterion("\"device\".intro is not null");
            return (Criteria) this;
        }

        public Criteria andIntroEqualTo(String value) {
            addCriterion("\"device\".intro =", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotEqualTo(String value) {
            addCriterion("\"device\".intro <>", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroGreaterThan(String value) {
            addCriterion("\"device\".intro >", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroGreaterThanOrEqualTo(String value) {
            addCriterion("\"device\".intro >=", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroLessThan(String value) {
            addCriterion("\"device\".intro <", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroLessThanOrEqualTo(String value) {
            addCriterion("\"device\".intro <=", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroLike(String value) {
            addCriterion("\"device\".intro like", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotLike(String value) {
            addCriterion("\"device\".intro not like", value, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroIn(List<String> values) {
            addCriterion("\"device\".intro in", values, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotIn(List<String> values) {
            addCriterion("\"device\".intro not in", values, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroBetween(String value1, String value2) {
            addCriterion("\"device\".intro between", value1, value2, "intro");
            return (Criteria) this;
        }

        public Criteria andIntroNotBetween(String value1, String value2) {
            addCriterion("\"device\".intro not between", value1, value2, "intro");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"device\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"device\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"device\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"device\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"device\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"device\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"device\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"device\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"device\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"device\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"device\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"device\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"device\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"device\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"device\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"device\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"device\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"device\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"device\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"device\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"device\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"device\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"device\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"device\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andSortIpIsNull() {
            addCriterion("\"device\".sort_ip is null");
            return (Criteria) this;
        }

        public Criteria andSortIpIsNotNull() {
            addCriterion("\"device\".sort_ip is not null");
            return (Criteria) this;
        }

        public Criteria andSortIpEqualTo(Long value) {
            addCriterion("\"device\".sort_ip =", value, "sortIp");
            return (Criteria) this;
        }

        public Criteria andSortIpNotEqualTo(Long value) {
            addCriterion("\"device\".sort_ip <>", value, "sortIp");
            return (Criteria) this;
        }

        public Criteria andSortIpGreaterThan(Long value) {
            addCriterion("\"device\".sort_ip >", value, "sortIp");
            return (Criteria) this;
        }

        public Criteria andSortIpGreaterThanOrEqualTo(Long value) {
            addCriterion("\"device\".sort_ip >=", value, "sortIp");
            return (Criteria) this;
        }

        public Criteria andSortIpLessThan(Long value) {
            addCriterion("\"device\".sort_ip <", value, "sortIp");
            return (Criteria) this;
        }

        public Criteria andSortIpLessThanOrEqualTo(Long value) {
            addCriterion("\"device\".sort_ip <=", value, "sortIp");
            return (Criteria) this;
        }

        public Criteria andSortIpIn(List<Long> values) {
            addCriterion("\"device\".sort_ip in", values, "sortIp");
            return (Criteria) this;
        }

        public Criteria andSortIpNotIn(List<Long> values) {
            addCriterion("\"device\".sort_ip not in", values, "sortIp");
            return (Criteria) this;
        }

        public Criteria andSortIpBetween(Long value1, Long value2) {
            addCriterion("\"device\".sort_ip between", value1, value2, "sortIp");
            return (Criteria) this;
        }

        public Criteria andSortIpNotBetween(Long value1, Long value2) {
            addCriterion("\"device\".sort_ip not between", value1, value2, "sortIp");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"device\".id as device_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasSerialnumColumn() {
            addColumnStr("\"device\".serialnum as device_serialnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasNameColumn() {
            addColumnStr("\"device\".\"name\" as \"device_name\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasChannelCountColumn() {
            addColumnStr("\"device\".channel_count as device_channel_count ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMacColumn() {
            addColumnStr("\"device\".mac as device_mac ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasLocalIpColumn() {
            addColumnStr("\"device\".local_ip as device_local_ip ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasWanIpColumn() {
            addColumnStr("\"device\".wan_ip as device_wan_ip ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasSoftwareColumn() {
            addColumnStr("\"device\".software as device_software ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasHardwareColumn() {
            addColumnStr("\"device\".hardware as device_hardware ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasStatusColumn() {
            addColumnStr("\"device\".\"status\" as \"device_status\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasMallIdColumn() {
            addColumnStr("\"device\".mall_id as device_mall_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasAccountIdColumn() {
            addColumnStr("\"device\".account_id as device_account_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasIntroColumn() {
            addColumnStr("\"device\".intro as device_intro ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"device\".modify_time as device_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"device\".create_time as device_create_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasSortIpColumn() {
            addColumnStr("\"device\".sort_ip as device_sort_ip ");
            return (ColumnContainer) this;
        }
    }
}