package com.viontech.mall.model;

import com.viontech.keliu.base.BaseExample;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class CountDataExample extends BaseExample {

    public CountDataExample() {
        super();
        tableName = "d_count_data";
        tableAlias = "countData";
        ignoreCase = false;
    }

    public Criteria or() {
        Criteria criteria = createCriteriaInternal();
        oredCriteria.add(criteria);
        return criteria;
    }

    public Criteria createCriteria() {
        Criteria criteria = createCriteriaInternal();
        if (oredCriteria.size() == 0) {
            oredCriteria.add(criteria);
        }
        return criteria;
    }

    protected Criteria createCriteriaInternal() {
        Criteria criteria = new Criteria(this.tableName,this.ignoreCase);
        return criteria;
    }

    public ColumnContainer createColumns() {
        ColumnContainer columnContainer = (ColumnContainer) columnContainerMap.get(this.tableName);
        if(columnContainer == null){
            columnContainer = new ColumnContainer(this.tableName);
            columnContainerMap.put(this.tableName,columnContainer);
        }
        return (ColumnContainer)columnContainer;
    }

    public static class Criteria extends GeneratedCriteria {

        protected Criteria(String tableName) {
            super(tableName);
            tableName = "d_count_data";
        }

        protected Criteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public boolean isValid() {
            return criteria.size() > 0;
        }

        public List<Criterion> getAllCriteria() {
            return criteria;
        }

        public void setAllCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        protected void addCriterion(String condition) {
            if (condition == null) {
                throw new RuntimeException("Value for condition cannot be null");
            }
            criteria.add(new Criterion(condition));
        }

        protected void addCriterion(String condition, Object value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value,ignoreCase));
        }

        protected void addCriterion(String condition, Object value1, Object value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            criteria.add(new Criterion(condition, value1, value2));
        }

        protected void addCriterionForJDBCDate(String condition, Date value, String property) {
            if (value == null) {
                throw new RuntimeException("Value for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value.getTime()), property);
        }

        protected void addCriterionForJDBCDate(String condition, List<Date> values, String property) {
            if (values == null || values.size() == 0) {
                throw new RuntimeException("Value list for " + property + " cannot be null or empty");
            }
            List<java.sql.Date> dateList = new ArrayList<java.sql.Date>();
            Iterator<Date> iter = values.iterator();
            while (iter.hasNext()) {
                dateList.add(new java.sql.Date(iter.next().getTime()));
            }
            addCriterion(condition, dateList, property);
        }

        protected void addCriterionForJDBCDate(String condition, Date value1, Date value2, String property) {
            if (value1 == null || value2 == null) {
                throw new RuntimeException("Between values for " + property + " cannot be null");
            }
            addCriterion(condition, new java.sql.Date(value1.getTime()), new java.sql.Date(value2.getTime()), property);
        }

        public Criteria andIdIsNull() {
            addCriterion("\"countData\".id is null");
            return (Criteria) this;
        }

        public Criteria andIdIsNotNull() {
            addCriterion("\"countData\".id is not null");
            return (Criteria) this;
        }

        public Criteria andIdEqualTo(Long value) {
            addCriterion("\"countData\".id =", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotEqualTo(Long value) {
            addCriterion("\"countData\".id <>", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThan(Long value) {
            addCriterion("\"countData\".id >", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"countData\".id >=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThan(Long value) {
            addCriterion("\"countData\".id <", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdLessThanOrEqualTo(Long value) {
            addCriterion("\"countData\".id <=", value, "id");
            return (Criteria) this;
        }

        public Criteria andIdIn(List<Long> values) {
            addCriterion("\"countData\".id in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotIn(List<Long> values) {
            addCriterion("\"countData\".id not in", values, "id");
            return (Criteria) this;
        }

        public Criteria andIdBetween(Long value1, Long value2) {
            addCriterion("\"countData\".id between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andIdNotBetween(Long value1, Long value2) {
            addCriterion("\"countData\".id not between", value1, value2, "id");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIsNull() {
            addCriterion("\"countData\".device_serialnum is null");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIsNotNull() {
            addCriterion("\"countData\".device_serialnum is not null");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumEqualTo(String value) {
            addCriterion("\"countData\".device_serialnum =", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotEqualTo(String value) {
            addCriterion("\"countData\".device_serialnum <>", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumGreaterThan(String value) {
            addCriterion("\"countData\".device_serialnum >", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumGreaterThanOrEqualTo(String value) {
            addCriterion("\"countData\".device_serialnum >=", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLessThan(String value) {
            addCriterion("\"countData\".device_serialnum <", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLessThanOrEqualTo(String value) {
            addCriterion("\"countData\".device_serialnum <=", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumLike(String value) {
            addCriterion("\"countData\".device_serialnum like", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotLike(String value) {
            addCriterion("\"countData\".device_serialnum not like", value, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumIn(List<String> values) {
            addCriterion("\"countData\".device_serialnum in", values, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotIn(List<String> values) {
            addCriterion("\"countData\".device_serialnum not in", values, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumBetween(String value1, String value2) {
            addCriterion("\"countData\".device_serialnum between", value1, value2, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andDeviceSerialnumNotBetween(String value1, String value2) {
            addCriterion("\"countData\".device_serialnum not between", value1, value2, "deviceSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIsNull() {
            addCriterion("\"countData\".channel_serialnum is null");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIsNotNull() {
            addCriterion("\"countData\".channel_serialnum is not null");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumEqualTo(String value) {
            addCriterion("\"countData\".channel_serialnum =", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotEqualTo(String value) {
            addCriterion("\"countData\".channel_serialnum <>", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumGreaterThan(String value) {
            addCriterion("\"countData\".channel_serialnum >", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumGreaterThanOrEqualTo(String value) {
            addCriterion("\"countData\".channel_serialnum >=", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLessThan(String value) {
            addCriterion("\"countData\".channel_serialnum <", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLessThanOrEqualTo(String value) {
            addCriterion("\"countData\".channel_serialnum <=", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumLike(String value) {
            addCriterion("\"countData\".channel_serialnum like", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotLike(String value) {
            addCriterion("\"countData\".channel_serialnum not like", value, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumIn(List<String> values) {
            addCriterion("\"countData\".channel_serialnum in", values, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotIn(List<String> values) {
            addCriterion("\"countData\".channel_serialnum not in", values, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumBetween(String value1, String value2) {
            addCriterion("\"countData\".channel_serialnum between", value1, value2, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andChannelSerialnumNotBetween(String value1, String value2) {
            addCriterion("\"countData\".channel_serialnum not between", value1, value2, "channelSerialnum");
            return (Criteria) this;
        }

        public Criteria andInnumIsNull() {
            addCriterion("\"countData\".innum is null");
            return (Criteria) this;
        }

        public Criteria andInnumIsNotNull() {
            addCriterion("\"countData\".innum is not null");
            return (Criteria) this;
        }

        public Criteria andInnumEqualTo(Integer value) {
            addCriterion("\"countData\".innum =", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumNotEqualTo(Integer value) {
            addCriterion("\"countData\".innum <>", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumGreaterThan(Integer value) {
            addCriterion("\"countData\".innum >", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"countData\".innum >=", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumLessThan(Integer value) {
            addCriterion("\"countData\".innum <", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumLessThanOrEqualTo(Integer value) {
            addCriterion("\"countData\".innum <=", value, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumIn(List<Integer> values) {
            addCriterion("\"countData\".innum in", values, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumNotIn(List<Integer> values) {
            addCriterion("\"countData\".innum not in", values, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumBetween(Integer value1, Integer value2) {
            addCriterion("\"countData\".innum between", value1, value2, "innum");
            return (Criteria) this;
        }

        public Criteria andInnumNotBetween(Integer value1, Integer value2) {
            addCriterion("\"countData\".innum not between", value1, value2, "innum");
            return (Criteria) this;
        }

        public Criteria andOutnumIsNull() {
            addCriterion("\"countData\".outnum is null");
            return (Criteria) this;
        }

        public Criteria andOutnumIsNotNull() {
            addCriterion("\"countData\".outnum is not null");
            return (Criteria) this;
        }

        public Criteria andOutnumEqualTo(Integer value) {
            addCriterion("\"countData\".outnum =", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumNotEqualTo(Integer value) {
            addCriterion("\"countData\".outnum <>", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumGreaterThan(Integer value) {
            addCriterion("\"countData\".outnum >", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumGreaterThanOrEqualTo(Integer value) {
            addCriterion("\"countData\".outnum >=", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumLessThan(Integer value) {
            addCriterion("\"countData\".outnum <", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumLessThanOrEqualTo(Integer value) {
            addCriterion("\"countData\".outnum <=", value, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumIn(List<Integer> values) {
            addCriterion("\"countData\".outnum in", values, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumNotIn(List<Integer> values) {
            addCriterion("\"countData\".outnum not in", values, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumBetween(Integer value1, Integer value2) {
            addCriterion("\"countData\".outnum between", value1, value2, "outnum");
            return (Criteria) this;
        }

        public Criteria andOutnumNotBetween(Integer value1, Integer value2) {
            addCriterion("\"countData\".outnum not between", value1, value2, "outnum");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNull() {
            addCriterion("\"countData\".counttime is null");
            return (Criteria) this;
        }

        public Criteria andCounttimeIsNotNull() {
            addCriterion("\"countData\".counttime is not null");
            return (Criteria) this;
        }

        public Criteria andCounttimeEqualTo(Date value) {
            addCriterion("\"countData\".counttime =", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotEqualTo(Date value) {
            addCriterion("\"countData\".counttime <>", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThan(Date value) {
            addCriterion("\"countData\".counttime >", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"countData\".counttime >=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThan(Date value) {
            addCriterion("\"countData\".counttime <", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeLessThanOrEqualTo(Date value) {
            addCriterion("\"countData\".counttime <=", value, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeIn(List<Date> values) {
            addCriterion("\"countData\".counttime in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotIn(List<Date> values) {
            addCriterion("\"countData\".counttime not in", values, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeBetween(Date value1, Date value2) {
            addCriterion("\"countData\".counttime between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andCounttimeNotBetween(Date value1, Date value2) {
            addCriterion("\"countData\".counttime not between", value1, value2, "counttime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNull() {
            addCriterion("\"countData\".modify_time is null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIsNotNull() {
            addCriterion("\"countData\".modify_time is not null");
            return (Criteria) this;
        }

        public Criteria andModifyTimeEqualTo(Date value) {
            addCriterion("\"countData\".modify_time =", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotEqualTo(Date value) {
            addCriterion("\"countData\".modify_time <>", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThan(Date value) {
            addCriterion("\"countData\".modify_time >", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"countData\".modify_time >=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThan(Date value) {
            addCriterion("\"countData\".modify_time <", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"countData\".modify_time <=", value, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeIn(List<Date> values) {
            addCriterion("\"countData\".modify_time in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotIn(List<Date> values) {
            addCriterion("\"countData\".modify_time not in", values, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeBetween(Date value1, Date value2) {
            addCriterion("\"countData\".modify_time between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andModifyTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"countData\".modify_time not between", value1, value2, "modifyTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNull() {
            addCriterion("\"countData\".create_time is null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIsNotNull() {
            addCriterion("\"countData\".create_time is not null");
            return (Criteria) this;
        }

        public Criteria andCreateTimeEqualTo(Date value) {
            addCriterion("\"countData\".create_time =", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotEqualTo(Date value) {
            addCriterion("\"countData\".create_time <>", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThan(Date value) {
            addCriterion("\"countData\".create_time >", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeGreaterThanOrEqualTo(Date value) {
            addCriterion("\"countData\".create_time >=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThan(Date value) {
            addCriterion("\"countData\".create_time <", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeLessThanOrEqualTo(Date value) {
            addCriterion("\"countData\".create_time <=", value, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeIn(List<Date> values) {
            addCriterion("\"countData\".create_time in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotIn(List<Date> values) {
            addCriterion("\"countData\".create_time not in", values, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeBetween(Date value1, Date value2) {
            addCriterion("\"countData\".create_time between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCreateTimeNotBetween(Date value1, Date value2) {
            addCriterion("\"countData\".create_time not between", value1, value2, "createTime");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNull() {
            addCriterion("\"countData\".countdate is null");
            return (Criteria) this;
        }

        public Criteria andCountdateIsNotNull() {
            addCriterion("\"countData\".countdate is not null");
            return (Criteria) this;
        }

        public Criteria andCountdateEqualTo(Date value) {
            addCriterionForJDBCDate("\"countData\".countdate =", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotEqualTo(Date value) {
            addCriterionForJDBCDate("\"countData\".countdate <>", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThan(Date value) {
            addCriterionForJDBCDate("\"countData\".countdate >", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateGreaterThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"countData\".countdate >=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThan(Date value) {
            addCriterionForJDBCDate("\"countData\".countdate <", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateLessThanOrEqualTo(Date value) {
            addCriterionForJDBCDate("\"countData\".countdate <=", value, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateIn(List<Date> values) {
            addCriterionForJDBCDate("\"countData\".countdate in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotIn(List<Date> values) {
            addCriterionForJDBCDate("\"countData\".countdate not in", values, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"countData\".countdate between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andCountdateNotBetween(Date value1, Date value2) {
            addCriterionForJDBCDate("\"countData\".countdate not between", value1, value2, "countdate");
            return (Criteria) this;
        }

        public Criteria andStatusIsNull() {
            addCriterion("\"countData\".\"status\" is null");
            return (Criteria) this;
        }

        public Criteria andStatusIsNotNull() {
            addCriterion("\"countData\".\"status\" is not null");
            return (Criteria) this;
        }

        public Criteria andStatusEqualTo(Short value) {
            addCriterion("\"countData\".\"status\" =", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotEqualTo(Short value) {
            addCriterion("\"countData\".\"status\" <>", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThan(Short value) {
            addCriterion("\"countData\".\"status\" >", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusGreaterThanOrEqualTo(Short value) {
            addCriterion("\"countData\".\"status\" >=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThan(Short value) {
            addCriterion("\"countData\".\"status\" <", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusLessThanOrEqualTo(Short value) {
            addCriterion("\"countData\".\"status\" <=", value, "status");
            return (Criteria) this;
        }

        public Criteria andStatusIn(List<Short> values) {
            addCriterion("\"countData\".\"status\" in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotIn(List<Short> values) {
            addCriterion("\"countData\".\"status\" not in", values, "status");
            return (Criteria) this;
        }

        public Criteria andStatusBetween(Short value1, Short value2) {
            addCriterion("\"countData\".\"status\" between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andStatusNotBetween(Short value1, Short value2) {
            addCriterion("\"countData\".\"status\" not between", value1, value2, "status");
            return (Criteria) this;
        }

        public Criteria andGateIdIsNull() {
            addCriterion("\"countData\".gate_id is null");
            return (Criteria) this;
        }

        public Criteria andGateIdIsNotNull() {
            addCriterion("\"countData\".gate_id is not null");
            return (Criteria) this;
        }

        public Criteria andGateIdEqualTo(Long value) {
            addCriterion("\"countData\".gate_id =", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdNotEqualTo(Long value) {
            addCriterion("\"countData\".gate_id <>", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdGreaterThan(Long value) {
            addCriterion("\"countData\".gate_id >", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdGreaterThanOrEqualTo(Long value) {
            addCriterion("\"countData\".gate_id >=", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdLessThan(Long value) {
            addCriterion("\"countData\".gate_id <", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdLessThanOrEqualTo(Long value) {
            addCriterion("\"countData\".gate_id <=", value, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdIn(List<Long> values) {
            addCriterion("\"countData\".gate_id in", values, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdNotIn(List<Long> values) {
            addCriterion("\"countData\".gate_id not in", values, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdBetween(Long value1, Long value2) {
            addCriterion("\"countData\".gate_id between", value1, value2, "gateId");
            return (Criteria) this;
        }

        public Criteria andGateIdNotBetween(Long value1, Long value2) {
            addCriterion("\"countData\".gate_id not between", value1, value2, "gateId");
            return (Criteria) this;
        }
    }

    public static class ColumnContainer extends ColumnContainerBase {

        protected ColumnContainer(String tableName) {
            super(tableName);
        }

        public ColumnContainer hasIdColumn() {
            addColumnStr("\"countData\".id as countData_id ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasDeviceSerialnumColumn() {
            addColumnStr("\"countData\".device_serialnum as countData_device_serialnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasChannelSerialnumColumn() {
            addColumnStr("\"countData\".channel_serialnum as countData_channel_serialnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasInnumColumn() {
            addColumnStr("\"countData\".innum as countData_innum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasOutnumColumn() {
            addColumnStr("\"countData\".outnum as countData_outnum ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCounttimeColumn() {
            addColumnStr("\"countData\".counttime as countData_counttime ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasModifyTimeColumn() {
            addColumnStr("\"countData\".modify_time as countData_modify_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCreateTimeColumn() {
            addColumnStr("\"countData\".create_time as countData_create_time ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasCountdateColumn() {
            addColumnStr("\"countData\".countdate as countData_countdate ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasStatusColumn() {
            addColumnStr("\"countData\".\"status\" as \"countData_status\" ");
            return (ColumnContainer) this;
        }

        public ColumnContainer hasGateIdColumn() {
            addColumnStr("\"countData\".gate_id as countData_gate_id ");
            return (ColumnContainer) this;
        }
    }
}