package com.viontech.mall.mapper;

import com.viontech.mall.vo.FaceRecognitionComparedVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

@Mapper
public interface FaceRecognitionComparedMapper {

    @Select(
            "SELECT" +
            " df.face_path||df.face_pic as path," +
            " df.age as age," +
            " dfr.age as raw_age," +
            " df.gender as gender," +
            " dfr.gender as raw_gender," +
            " df.direction as direction," +
            " dfr.direction as raw_direction," +
            " df.counttime as date" +
            " FROM" +
            " d_face_recognition df," +
            " d_face_recognition_raw dfr" +
            " WHERE" +
            " df.countdate = '${date}'" +
            " AND df.direction = ${direction}" +
            " AND df.gate_id in(${gateIds})" +
            " and df.mall_id = ${mallId}" +
            " AND df.unid = dfr.person_unid" +
            " AND df.counttime = dfr.counttime" +
            " ORDER BY df.id")
    List<FaceRecognitionComparedVo> getComparedResult(@Param("date") String date,
                                                      @Param("direction") Short direction,
                                                      @Param("gateIds") String gateIds,
                                                      @Param("mallId") Long mallId);

}
