/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.util;

import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class NumberUtil {
    public static boolean isInteger(Object value) {
        if (value == null || value.toString().isEmpty()) {
            return false;
        }
        String mstr = value.toString();
        Pattern pattern = Pattern.compile("^-?\\d+{1}");
        return pattern.matcher(mstr).matches();
    }

    public static boolean isDigit(Object value) {
        if (value == null || value.toString().isEmpty()) {
            return false;
        }
        String mstr = value.toString();
        Pattern pattern = Pattern.compile("^-?[0-9]*.?[0-9]*{1}");
        return pattern.matcher(mstr).matches();
    }

    public static String format(Object value, Integer precision) {
        Double number = 0.0;
        if (NumberUtil.isDigit(value)) {
            number = new Double(value.toString());
        }
        precision = precision == null || precision < 0 ? 2 : precision;
        BigDecimal bigDecimal = new BigDecimal(number);
        return bigDecimal.setScale((int)precision, 4).toString();
    }

    public static String format(Object value) {
        return NumberUtil.format(value, 2);
    }

    public static Integer parseInteger(Object value, Integer replace) {
        if (!NumberUtil.isInteger(value)) {
            return replace;
        }
        return new Integer(value.toString());
    }

    public static Integer parseInteger(Object value) {
        return NumberUtil.parseInteger(value, 0);
    }

    public static Long parseLong(Object value, Long replace) {
        if (!NumberUtil.isInteger(value)) {
            return replace;
        }
        return new Long(value.toString());
    }

    public static Long parseLong(Object value) {
        return NumberUtil.parseLong(value, 0L);
    }

    public static Double parseDouble(Object value, Double replace) {
        if (!NumberUtil.isDigit(value)) {
            return replace;
        }
        return new Double(value.toString());
    }

    public static Double parseDouble(Object value) {
        return NumberUtil.parseDouble(value, 0.0);
    }

    public static byte[] toBytes(char value) {
        byte[] bt = new byte[2];
        for (int i = 0; i < bt.length; ++i) {
            bt[i] = (byte)(value >>> i * 8);
        }
        return bt;
    }

    public static byte[] toBytes(short value) {
        byte[] bt = new byte[2];
        for (int i = 0; i < bt.length; ++i) {
            bt[i] = (byte)(value >>> i * 8);
        }
        return bt;
    }

    public static byte[] toBytes(int value) {
        byte[] bt = new byte[4];
        for (int i = 0; i < bt.length; ++i) {
            bt[i] = (byte)(value >>> i * 8);
        }
        return bt;
    }

    public static byte[] toBytes(long value) {
        byte[] bt = new byte[8];
        for (int i = 0; i < bt.length; ++i) {
            bt[i] = (byte)(value >>> i * 8);
        }
        return bt;
    }

    public static void insert(int index, byte[] values, short value) {
        byte[] bt = NumberUtil.toBytes(value);
        System.arraycopy(bt, 0, values, index, 2);
    }

    public static void insert(int index, byte[] values, int value) {
        byte[] bt = NumberUtil.toBytes(value);
        System.arraycopy(bt, 0, values, index, 4);
    }

    public static void insert(int index, byte[] values, long value) {
        byte[] bt = NumberUtil.toBytes(value);
        System.arraycopy(bt, 0, values, index, 8);
    }

    public static int byteToInt(byte value) {
        if (value < 0) {
            return value + 256;
        }
        return value;
    }

    public static float formatRoundUp(float number, int digit) {
        BigDecimal b = new BigDecimal(number);
        return b.setScale(digit, 0).floatValue();
    }

    public static double formatRoundUp(double number, int digit) {
        BigDecimal b = new BigDecimal(number);
        return b.setScale(digit, 0).doubleValue();
    }

    public static float formatRoundHalfUp(float number, int digit) {
        BigDecimal b = new BigDecimal(number);
        return b.setScale(digit, 4).floatValue();
    }

    public static Double formatRoundHalfUp(double number, int digit) {
        BigDecimal b = new BigDecimal(number);
        return b.setScale(digit, 4).doubleValue();
    }

    public static BigDecimal formatRoundUp(BigDecimal number, int digit) {
        return number.setScale(digit, 0);
    }

    public static BigDecimal formatRoundHalfUp(BigDecimal number, int digit) {
        return number.setScale(digit, 4);
    }

    public static Integer getAvg(TIntArrayList values) {
        int sum = values.sum();
        int count = values.size();
        Double result = NumberUtil.divide(sum, count, 0);
        if (result == null) {
            return null;
        }
        return result.intValue();
    }

    public static double getAvg(TDoubleArrayList values, int digit) {
        double sum = values.sum();
        int count = values.size();
        return NumberUtil.divide(sum, count, digit);
    }

    public static Double divide(Number dividend, Number divisor, int digit) {
        if (dividend == null || divisor == null) {
            return null;
        }
        BigDecimal dividendBD = new BigDecimal(dividend.toString());
        BigDecimal divisorBD = new BigDecimal(divisor.toString());
        try {
            return dividendBD.divide(divisorBD, digit, 4).doubleValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Double subtract(Number minuend, Number subtrahend) {
        if (minuend == null || subtrahend == null) {
            return null;
        }
        BigDecimal minuendBD = new BigDecimal(minuend.toString());
        BigDecimal subtrahendBD = new BigDecimal(subtrahend.toString());
        try {
            return minuendBD.subtract(subtrahendBD).doubleValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static String growthRate(Number newData, Number oldData) {
        if (newData == null || oldData == null) {
            return null;
        }
        Double rd = NumberUtil.divide(NumberUtil.subtract(newData, oldData), oldData, 6);
        if (rd == null) {
            return null;
        }
        String result = NumberUtil.formatRoundHalfUp(rd * 100.0, 2) + "%";
        return result;
    }

    public static Double percentage(Number dividend, Number divisor, int digit) {
        if (dividend == null || divisor == null) {
            return null;
        }
        Double result = NumberUtil.divide(dividend, divisor, digit + 2);
        if (result == null) {
            return null;
        }
        result = NumberUtil.formatRoundUp(result * 100.0, digit);
        return result;
    }

    public static BigDecimal conver2BigDecimal(Number number) {
        if (number == null) {
            return null;
        }
        return new BigDecimal(number.toString());
    }

    public static Object valueAdd(Object t1, Object t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        BigDecimal sum = new BigDecimal(t1.toString()).add(new BigDecimal(t2.toString()));
        if (t1 instanceof Double) {
            return new Double(sum.doubleValue());
        }
        if (t1 instanceof Integer) {
            return new Integer(sum.intValue());
        }
        if (t1 instanceof Float) {
            return new Float(sum.floatValue());
        }
        if (t1 instanceof Long) {
            return new Long(sum.longValue());
        }
        return new Double(sum.doubleValue());
    }

    public static void main(String[] args) {
    }
}

