package com.viontech.keliu.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

/**
 * Created by vion on 2018/8/7.
 */
public abstract class PathStorage<T> implements Storage<T> {

    protected StoragePathGenerator storagePathGenerator = (name)-> name;

    public StoragePathGenerator getStoragePathGenerator() {
        return storagePathGenerator;
    }

    public void setStoragePathGenerator(StoragePathGenerator storagePathGenerator) {
        this.storagePathGenerator = storagePathGenerator;
    }

    protected byte[] readFile(File file) throws IOException {
        FileInputStream fi = null;
        try {
            long fileSize = file.length();
            if (fileSize > Integer.MAX_VALUE) {
                return null;
            }
            fi = new FileInputStream(file);
            byte[] buffer = new byte[(int) fileSize];
            int offset = 0;
            int numRead = 0;
            while (offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0) {
                offset += numRead;
            }
            // 确保所有数据均被读取
            if (offset != buffer.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            return buffer;
        } catch (Exception e){
            return null;
        }finally {
            if(fi != null) {
                fi.close();
            }
        }

    }

    protected String readFile2Json(File file) throws IOException {
        FileInputStream fi = null;
        try {
            long fileSize = file.length();
            if (fileSize > Integer.MAX_VALUE) {
                return null;
            }
            fi = new FileInputStream(file);
            byte[] buffer = new byte[(int) fileSize];
            int offset = 0;
            int numRead = 0;
            while (offset < buffer.length && (numRead = fi.read(buffer, offset, buffer.length - offset)) >= 0) {
                offset += numRead;
            }
            // 确保所有数据均被读取
            if (offset != buffer.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            return new String(buffer,0,buffer.length);
        } catch (Exception e){
            return null;
        }finally {
            if(fi != null) {
                fi.close();
            }
        }

    }
}
