package com.viontech.keliu.storage;

import com.viontech.keliu.oss.OssClientHelper;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

/**
 * @author 谢明辉
 * @createDate 2018-10-27
 * @description
 */

public class OssImageStorage extends PathStorage<BufferedImage> {
    private OssClientHelper ossClientHelper;

    @Override
    public void setItem(String key, BufferedImage item) {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            ImageIO.write(item, "jpg", outputStream);
            byte[] bytes = outputStream.toByteArray();
            ossClientHelper.storeFile(storagePathGenerator.generator(key), bytes);
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public BufferedImage getItem(String key) {
        try {
            return ossClientHelper.getBufferedImage(storagePathGenerator.generator(key));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public byte[] getByteArrayItem(String key) {
        try {
            return ossClientHelper.getByteArrayImage(storagePathGenerator.generator(key));
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public OssClientHelper getOssClientHelper() {
        return ossClientHelper;
    }

    public void setOssClientHelper(OssClientHelper ossClientHelper) {
        this.ossClientHelper = ossClientHelper;
    }
}
