package com.viontech.keliu.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class LocalFeatureStorage extends PathStorage<String> {
    private String basePath;

    @Override
    public void setItem(String key, String item) {
        FileOutputStream fos = null;
        try {
            File file = new File(basePath, storagePathGenerator.generator(key));
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fos = new FileOutputStream(file);
            int jsonLength = item.length();
            byte[] jsonBytes = item.getBytes();
            fos.write(jsonBytes, 0, jsonLength);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (fos != null) {
                try {
                    fos.flush();
                    fos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }

            }
        }
    }


    @Override
    public String getItem(String key) {
        String json = getJsonArrayItem(key);
        if (json == null) {
            return null;
        }
        try {
            return json;
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


    @Override
    public byte[] getByteArrayItem(String key) {
        File file = new File(basePath, storagePathGenerator.generator(key));
        try {
            return readFile(file);
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getJsonArrayItem(String key) {
        File file = new File(basePath, storagePathGenerator.generator(key));
        try {
            String s = readFile2Json(file);
            return s;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String getBasePath() {
        return basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}
