package com.viontech.keliu.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.*;

/**
 * @author 谢明辉
 * @createDate 2018-10-27
 * @description
 */

public class OssClientHelper {
    Logger log = LoggerFactory.getLogger(OssClientHelper.class);
    private String key;
    private String secret;
    private String endPoint;
    private String bucket;
    private static OSSClient ossClient;

    public OSSClient getClient() {
        if (ossClient == null) {
            ClientConfiguration conf=new ClientConfiguration();
            conf.setRequestTimeoutEnabled(true);
            conf.setRequestTimeout(10000000);
            conf.setConnectionTimeout(10000000);
//            conf.setSocketTimeout(10000000);
//            conf.setConnectionRequestTimeout(10000000);
//            conf.setConnectionRequestTimeout(10000000);
            ossClient = new OSSClient(endPoint, key, secret,conf);
        }
        return ossClient;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String storeFile(String remoteFile, InputStream stream) {
        log.info("oss-store--stream");
        OSSClient ossClient = getClient();
        return ossClient.putObject(bucket, remoteFile, stream).getETag();
    }

    public String storeFile(String remoteFile, byte[] content) {
        log.info("oss--store--byte");
        OSSClient ossClient = getClient();
        return ossClient.putObject(bucket, remoteFile, new ByteArrayInputStream(content)).getETag();
    }

    public String getItem(String key) {
        BufferedReader br = new BufferedReader(new InputStreamReader(getClient().getObject(bucket, key).getObjectContent()));
        StringBuilder sb = new StringBuilder();
        String s;
        try {
            while ((s = br.readLine()) != null) {
                sb.append(s);
            }
        } catch (Exception e) {
            log.info("oss getItem error");
            e.printStackTrace();
        } finally {
            try {
                br.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public byte[] getByteArray(String key) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            return IOUtils.readStreamAsByteArray(getClient().getObject(bucket, key).getObjectContent());
        } catch (IOException e) {
            log.info("oss getByteArray error");
            e.printStackTrace();
            return new byte[0];
        }
    }

    public BufferedImage getBufferedImage(String key) {
        try {
            return ImageIO.read(getClient().getObject(bucket, key).getObjectContent());
        } catch (IOException e) {
            log.info("oss getBufferedImage error");
            e.printStackTrace();
        }
        return null;
    }

    public byte[] getByteArrayImage(String key) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            return IOUtils.readStreamAsByteArray(getClient().getObject(bucket, key).getObjectContent());
        } catch (IOException e) {
            log.error("oss getByteArrayImage error");
            e.printStackTrace();
        }
        return null;
    }
}
