/*
 *  Copyright 2009 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.mybatis.generator.codegen.mybatis3.model;

import org.mybatis.generator.api.*;
import org.mybatis.generator.api.dom.java.*;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import org.mybatis.generator.codegen.RootClassInfo;

import java.util.ArrayList;
import java.util.List;

import static org.mybatis.generator.internal.util.JavaBeansUtil.*;
import static org.mybatis.generator.internal.util.messages.Messages.getString;

/**
 * 
 * @author Jeff Butler
 * 
 */
public class BaseRecordVoBaseGenerator extends AbstractJavaGenerator  {

	public static final String VO_BASE_INTERFACE = "com.viontech.keliu.base.VoInterface";

	public BaseRecordVoBaseGenerator() {
		super();
	}
	
	
	@Override
	public List<CompilationUnit> getCompilationUnits() {
		FullyQualifiedTable table = introspectedTable.getFullyQualifiedTable();
		progressCallback.startTask(getString("Progress.8", table.toString()));
		Plugin plugins = context.getPlugins();
		CommentGenerator commentGenerator = context.getCommentGenerator();

		FullyQualifiedJavaType type = new FullyQualifiedJavaType(introspectedTable.getBaseRecordVoBaseType());
		TopLevelClass topLevelClass = new TopLevelClass(type);
		topLevelClass.setVisibility(JavaVisibility.PUBLIC);
		commentGenerator.addJavaFileComment(topLevelClass);

		FullyQualifiedJavaType superClass = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
		if (superClass != null) {
			topLevelClass.setSuperClass(superClass);
			topLevelClass.addImportedType(superClass);
		}
		FullyQualifiedJavaType rootInterface = new FullyQualifiedJavaType(VO_BASE_INTERFACE+"<"+superClass.getShortName()+">");
		if (rootInterface != null) {
			topLevelClass.addSuperInterface(rootInterface);
			topLevelClass.addImportedType(rootInterface);
		}
		addVoBaseConstructor(topLevelClass);
		Method getModelMethod = new Method("getModel");
		getModelMethod.addAnnotation("@JsonIgnore");
		getModelMethod.setVisibility(JavaVisibility.PUBLIC);
		getModelMethod.setReturnType(superClass);
		StringBuilder sb = new StringBuilder();
		sb.append("return ").append(getValidPropertyName(superClass.getShortName()));
		sb.append(";");
		getModelMethod.addBodyLine(sb.toString());
		topLevelClass.addMethod(getModelMethod);
		
		
		Method setModelMethod = new Method("setModel");
		setModelMethod.setVisibility(JavaVisibility.PUBLIC);
		setModelMethod.addParameter(new Parameter(superClass,getValidPropertyName(superClass.getShortName())));
		sb.setLength(0);
		sb.append("this.").append(getValidPropertyName(superClass.getShortName())).append(" = ");
		sb.append(getValidPropertyName(superClass.getShortName()));
		sb.append(";");
		setModelMethod.addBodyLine(sb.toString());
		
		topLevelClass.addMethod(setModelMethod);
		
		List<IntrospectedColumn> introspectedColumns = getColumnsInThisClass();

	
		if (introspectedTable.isConstructorBased()) {
			addParameterizedConstructor(topLevelClass);

			if (!introspectedTable.isImmutable()) {
				addDefaultConstructor(topLevelClass);
			}
			
		}

		String rootClass = getRootClass();
		topLevelClass.addImportedType( new FullyQualifiedJavaType("com.fasterxml.jackson.annotation.JsonIgnore"));
		for (IntrospectedColumn introspectedColumn : introspectedColumns) {
			if (RootClassInfo.getInstance(rootClass, warnings).containsProperty(introspectedColumn)) {
				continue;
			}
			if(introspectedColumn.isNullable()) {
				FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
				String property = introspectedColumn.getJavaProperty();
				Field field = new Field();
				field.setVisibility(JavaVisibility.PRIVATE);
				FullyQualifiedJavaType t = new FullyQualifiedJavaType("java.lang.Boolean");
				field.setType(t);
				field.setName(property + "_null");

				field.addAnnotation("@JsonIgnore");
				topLevelClass.addField(field);
				topLevelClass.addImportedType(t);

				Method method = new Method();
				method.setName(getGetterMethodName(field.getName(), fqjt));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.setReturnType(t);
				method.addBodyLine("return " + property + "_null;");
				topLevelClass.addMethod(method);

				method = new Method();
				method.setName(getSetterMethodName(field.getName()));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.addParameter(new Parameter(t, property + "_null"));
				method.addBodyLine("this." + property + "_null = " + property + "_null;");
				topLevelClass.addMethod(method);
			}
			//introspectedColumn.getIntrospectedImportColumn() != null || introspectedColumn.isIdentity()
			if(1==1){//外键
				FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
				String property = introspectedColumn.getJavaProperty();
				Field field = new Field();
				field.setVisibility(JavaVisibility.PRIVATE);
				FullyQualifiedJavaType t = new FullyQualifiedJavaType("java.util.ArrayList<"+fqjt.getShortName()+">");
				field.setType(t);
				field.setName(property+"_arr");
				
				field.addAnnotation("@JsonIgnore");
				topLevelClass.addField(field);
				topLevelClass.addImportedType(t);
				
				Method method = new Method();
				method.setName(getGetterMethodName(field.getName(),fqjt));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.setReturnType(t);
				method.addBodyLine("return "+property+"_arr;");
				topLevelClass.addMethod(method);
				
				method = new Method();
				method.setName(getSetterMethodName(field.getName()));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.addParameter(new Parameter(t,property+"_arr"));
				method.addBodyLine("this."+property+"_arr = "+property+"_arr;" );
				topLevelClass.addMethod(method);
			}
			if (introspectedColumn.isJdbcCharacterColumn()) {//字符串
				FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
				String property = introspectedColumn.getJavaProperty();
				Field field = new Field();
				field.setVisibility(JavaVisibility.PRIVATE);
				field.setType(fqjt);
				field.setName(property+"_like");
				field.addAnnotation("@JsonIgnore");
				topLevelClass.addField(field);
				// _like 属性的get方法
				Method method = new Method();
				method.setName(getGetterMethodName(field.getName(),fqjt));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.setReturnType(fqjt);
				method.addBodyLine("return "+property+"_like;");
				topLevelClass.addMethod(method);

				// _like 属性的set方法
				method = new Method();
				method.setName(getSetterMethodName(field.getName()));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.addParameter(new Parameter(fqjt,property+"_like"));
				method.addBodyLine("this."+property+"_like = "+property+"_like;" );
				topLevelClass.addMethod(method);
				
				
			}else{
				FullyQualifiedJavaType fqjt = introspectedColumn.getFullyQualifiedJavaType();
				
				String property = introspectedColumn.getJavaProperty();
				Field field = new Field();
				field.setVisibility(JavaVisibility.PRIVATE);
				field.setType(fqjt);
				field.setName(property+"_gt");
				field.addAnnotation("@JsonIgnore");
				topLevelClass.addField(field);
				topLevelClass.addImportedType(field.getType());
				
				
				Method method = new Method();
				method.setName(getGetterMethodName(field.getName(),fqjt));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.setReturnType(fqjt);
				method.addBodyLine("return "+property+"_gt;");
				topLevelClass.addMethod(method);
				
				method = new Method();
				method.setName(getSetterMethodName(field.getName()));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.addParameter(new Parameter(fqjt,property+"_gt"));
				method.addBodyLine("this."+property+"_gt = "+property+"_gt;" );
				topLevelClass.addMethod(method);
				
				
				
				
				field = new Field();
				field.setVisibility(JavaVisibility.PRIVATE);
				field.setType(fqjt);
				field.setName(property+"_lt");
				field.addAnnotation("@JsonIgnore");
				topLevelClass.addField(field);
				
				method = new Method();
				method.setName(getGetterMethodName(field.getName(),fqjt));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.setReturnType(fqjt);
				method.addBodyLine("return "+property+"_lt;");
				topLevelClass.addMethod(method);
				
				method = new Method();
				method.setName(getSetterMethodName(field.getName()));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.addParameter(new Parameter(fqjt,property+"_lt"));
				method.addBodyLine("this."+property+"_lt = "+property+"_lt;" );
				topLevelClass.addMethod(method);
				
				
				
				field = new Field();
				field.setVisibility(JavaVisibility.PRIVATE);
				field.setType(fqjt);
				field.setName(property+"_gte");
				field.addAnnotation("@JsonIgnore");
				topLevelClass.addField(field);
				
				method = new Method();
				method.setName(getGetterMethodName(field.getName(),fqjt));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.setReturnType(fqjt);
				method.addBodyLine("return "+property+"_gte;");
				topLevelClass.addMethod(method);
				
				method = new Method();
				method.setName(getSetterMethodName(field.getName()));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.addParameter(new Parameter(fqjt,property+"_gte"));
				method.addBodyLine("this."+property+"_gte = "+property+"_gte;" );
				topLevelClass.addMethod(method);
				
				field = new Field();
				field.setVisibility(JavaVisibility.PRIVATE);
				field.setType(fqjt);
				field.setName(property+"_lte");
				field.addAnnotation("@JsonIgnore");
				topLevelClass.addField(field);
				
				method = new Method();
				method.setName(getGetterMethodName(field.getName(),fqjt));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.setReturnType(fqjt);
				method.addBodyLine("return "+property+"_lte;");
				topLevelClass.addMethod(method);
				
				method = new Method();
				method.setName(getSetterMethodName(field.getName()));
				method.setVisibility(JavaVisibility.PUBLIC);
				method.addParameter(new Parameter(fqjt,property+"_lte"));
				method.addBodyLine("this."+property+"_lte = "+property+"_lte;" );
				topLevelClass.addMethod(method);
				
			}
			
			
			
			
			

			Method method = getJavaBeansGetter(introspectedColumn, context, introspectedTable);
			if (plugins.modelGetterMethodGenerated(method, topLevelClass, introspectedColumn, introspectedTable, Plugin.ModelClassType.BASE_RECORD)) {
				method.getBodyLines().clear();
				
				method.addBodyLine("if(getModel() == null ){");
				method.addBodyLine("throw new RuntimeException(\"model is null\");");
				method.addBodyLine("}");
				
				sb.setLength(0);
				sb.append("return "); //$NON-NLS-1$
				sb.append("this.");
				sb.append("getModel()").append(".");
				sb.append(method.getName()).append("(");
				sb.append(")");
				sb.append(';');
				method.addBodyLine(sb.toString());
				topLevelClass.addMethod(method);
			}

			if (!introspectedTable.isImmutable()) {
				method = getJavaBeansSetter(introspectedColumn, context, introspectedTable);
				if (plugins.modelSetterMethodGenerated(method, topLevelClass, introspectedColumn, introspectedTable, Plugin.ModelClassType.BASE_RECORD)) {
					method.getBodyLines().clear();

					method.addBodyLine("if(getModel() == null ){");
					method.addBodyLine("throw new RuntimeException(\"model is null\");");
					method.addBodyLine("}");
					sb.setLength(0);
					sb.append("this.");
					sb.append("getModel()").append(".");
					sb.append(method.getName()).append("(");
					sb.append(introspectedColumn.getJavaProperty());
					sb.append(")");
					sb.append(';');
					method.addBodyLine(sb.toString());
					topLevelClass.addMethod(method);
				}
			}
		}
		
		// add by suman start
				for (IntrospectedColumn introspectedColumn : introspectedColumns) {
					if (RootClassInfo.getInstance(rootClass, warnings).containsProperty(introspectedColumn)) {
						continue;
					}
					IntrospectedColumn introspectedImportColumn = introspectedColumn.getIntrospectedImportColumn();
					if(introspectedImportColumn == null ){
						continue;
					}
					
					IntrospectedTable introspectedImportTable = introspectedImportColumn.getIntrospectedTable();
					
					FullyQualifiedJavaType importType = new FullyQualifiedJavaType(introspectedImportTable.getBaseRecordType());
					topLevelClass.addImportedType(importType);
				
					Method method = getImportJavaBeansGetter(introspectedColumn, context);
					if (plugins.modelGetterMethodGenerated(method, topLevelClass, introspectedColumn, introspectedTable, Plugin.ModelClassType.BASE_RECORD)) {
						method.getBodyLines().clear();
						method.addBodyLine("if(getModel() == null ){");
						method.addBodyLine("throw new RuntimeException(\"model is null\");");
						method.addBodyLine("}");
						
						sb.setLength(0);
						sb.append("return "); //$NON-NLS-1$
						sb.append("this.");
						sb.append("getModel()").append(".");
						sb.append(method.getName()).append("(");
						sb.append(")");
						sb.append(';');
						method.addBodyLine(sb.toString());
						topLevelClass.addMethod(method);
					}

					if (!introspectedTable.isImmutable()) {
						method = getImportJavaBeansSetter(introspectedColumn, context);
						if (plugins.modelSetterMethodGenerated(method, topLevelClass, introspectedColumn, introspectedTable, Plugin.ModelClassType.BASE_RECORD)) {
							method.getBodyLines().clear();

							method.addBodyLine("if(getModel() == null ){");
							method.addBodyLine("throw new RuntimeException(\"model is null\");");
							method.addBodyLine("}");
							
							String property = getValidPropertyName(importType.getShortName());
							
							sb.setLength(0);
							sb.append("this.");
							sb.append("getModel()").append(".");
							sb.append(method.getName()).append("(");
							sb.append(property);
							sb.append(")");
							sb.append(';');
							method.addBodyLine(sb.toString());
							topLevelClass.addMethod(method);
						}
					}
				}
				// add by suman end
		List<CompilationUnit> answer = new ArrayList<CompilationUnit>();
		if (context.getPlugins().modelBaseRecordClassGenerated(topLevelClass, introspectedTable)) {
			answer.add(topLevelClass);
		}
		return answer;
	}

	private void addVoBaseConstructor(TopLevelClass topLevelClass) {
		
		FullyQualifiedJavaType baseModelType = new FullyQualifiedJavaType(introspectedTable.getBaseRecordType());
		Field field = new Field();
		field.setVisibility(JavaVisibility.PRIVATE);
		field.setType(baseModelType);
		field.setName(getValidPropertyName(baseModelType.getShortName()));
		topLevelClass.addField(field);
		topLevelClass.addImportedType(field.getType());
		
		Method method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setConstructor(true);
		method.setName(topLevelClass.getType().getShortName());
		method.addBodyLine("this(null);");
		context.getCommentGenerator().addGeneralMethodComment(method, introspectedTable);
		topLevelClass.addMethod(method);
		method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setConstructor(true);
		method.setName(topLevelClass.getType().getShortName());
		context.getCommentGenerator().addGeneralMethodComment(method, introspectedTable);
		
		method.addParameter(new Parameter(baseModelType,getValidPropertyName(baseModelType.getShortName()) ));
		
		StringBuilder sb = new StringBuilder();
		sb.append("if(");
		sb.append(getValidPropertyName(baseModelType.getShortName())).append(" == null");
		sb.append(") {");
		method.addBodyLine(sb.toString());
		sb.setLength(0);
		sb.append(getValidPropertyName(baseModelType.getShortName())).append(" = new ").append(baseModelType.getShortName()).append("();");
		method.addBodyLine(sb.toString());
		method.addBodyLine("}");
		
		sb.setLength(0);
		sb.append("this.").append(field.getName()).append(" = ").append(getValidPropertyName(baseModelType.getShortName())).append(";");
		method.addBodyLine(sb.toString());
		topLevelClass.addMethod(method);
	}


	private FullyQualifiedJavaType getSuperClass() {
		FullyQualifiedJavaType superClass;
		if (introspectedTable.getRules().generatePrimaryKeyClass()) {
			superClass = new FullyQualifiedJavaType(introspectedTable.getPrimaryKeyType());
		} else {
			String rootClass = getRootClass();
			if (rootClass != null) {
				superClass = new FullyQualifiedJavaType(rootClass);
			} else {
				superClass = null;
			}
		}

		return superClass;
	}

	private boolean includePrimaryKeyColumns() {
		return !introspectedTable.getRules().generatePrimaryKeyClass() && introspectedTable.hasPrimaryKeyColumns();
	}

	private boolean includeBLOBColumns() {
		return !introspectedTable.getRules().generateRecordWithBLOBsClass() && introspectedTable.hasBLOBColumns();
	}

	private void addParameterizedConstructor(TopLevelClass topLevelClass) {
		Method method = new Method();
		method.setVisibility(JavaVisibility.PUBLIC);
		method.setConstructor(true);
		method.setName(topLevelClass.getType().getShortName());
		context.getCommentGenerator().addGeneralMethodComment(method, introspectedTable);

		List<IntrospectedColumn> constructorColumns = includeBLOBColumns() ? introspectedTable.getAllColumns() : introspectedTable.getNonBLOBColumns();

		for (IntrospectedColumn introspectedColumn : constructorColumns) {
			method.addParameter(new Parameter(introspectedColumn.getFullyQualifiedJavaType(), introspectedColumn.getJavaProperty()));
			topLevelClass.addImportedType(introspectedColumn.getFullyQualifiedJavaType());
		}

		StringBuilder sb = new StringBuilder();
		if (introspectedTable.getRules().generatePrimaryKeyClass()) {
			boolean comma = false;
			sb.append("super(");
			for (IntrospectedColumn introspectedColumn : introspectedTable.getPrimaryKeyColumns()) {
				if (comma) {
					sb.append(", ");
				} else {
					comma = true;
				}
				sb.append(introspectedColumn.getJavaProperty());
			}
			sb.append(");");
			method.addBodyLine(sb.toString());
		}

		List<IntrospectedColumn> introspectedColumns = getColumnsInThisClass();

		for (IntrospectedColumn introspectedColumn : introspectedColumns) {
			sb.setLength(0);
			sb.append("this.");
			sb.append(introspectedColumn.getJavaProperty());
			sb.append(" = ");
			sb.append(introspectedColumn.getJavaProperty());
			sb.append(';');
			method.addBodyLine(sb.toString());
		}

		topLevelClass.addMethod(method);
	}

	private List<IntrospectedColumn> getColumnsInThisClass() {
		List<IntrospectedColumn> introspectedColumns;
		if (includePrimaryKeyColumns()) {
			if (includeBLOBColumns()) {
				introspectedColumns = introspectedTable.getAllColumns();
			} else {
				introspectedColumns = introspectedTable.getNonBLOBColumns();
			}
		} else {
			if (includeBLOBColumns()) {
				introspectedColumns = introspectedTable.getNonPrimaryKeyColumns();
			} else {
				introspectedColumns = introspectedTable.getBaseColumns();
			}
		}

		return introspectedColumns;
	}
}
