/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc;

import java.sql.Connection;
import net.sf.log4jdbc.ConnectionSpy;
import net.sf.log4jdbc.DriverSpy;
import net.sf.log4jdbc.RdbmsSpecifics;
import net.sf.log4jdbc.SpyLogFactory;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class DataSourceSpyInterceptor
implements MethodInterceptor {
    private RdbmsSpecifics rdbmsSpecifics = null;

    private RdbmsSpecifics getRdbmsSpecifics(Connection conn) {
        if (this.rdbmsSpecifics == null) {
            this.rdbmsSpecifics = DriverSpy.getRdbmsSpecifics((Connection)conn);
        }
        return this.rdbmsSpecifics;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = invocation.proceed();
        if (SpyLogFactory.getSpyLogDelegator().isJdbcLoggingEnabled() && result instanceof Connection) {
            Connection conn = (Connection)result;
            return new ConnectionSpy(conn, this.getRdbmsSpecifics(conn));
        }
        return result;
    }
}

