/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.redis;

import com.viontech.keliu.redis.KryoRedisSerializer;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.CachingConfigurerSupport;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;

@Configuration
@EnableCaching
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class RedisConfiguration
extends CachingConfigurerSupport {
    Logger logger = LoggerFactory.getLogger(RedisConfiguration.class);

    public RedisConfiguration() {
        System.out.println();
    }

    @Bean
    public KeyGenerator keyGenerator() {
        return new KeyGenerator(){

            public Object generate(Object target, Method method, Object ... params) {
                System.out.println("******************\u751f\u6210\u7f13\u5b58key");
                StringBuffer sb = new StringBuffer();
                sb.append(target.getClass().getName()).append(":");
                sb.append(method.getName()).append(":");
                for (Object obj : params) {
                    sb.append(obj.toString()).append(":");
                }
                sb.setLength(sb.length() - 1);
                return sb.toString();
            }
        };
    }

    @Bean
    CacheManager cacheManager(RedisConnectionFactory connectionFactory) {
        RedisCacheConfiguration userCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(30L)).disableCachingNullValues().prefixKeysWith("user");
        RedisCacheConfiguration productCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig().entryTtl(Duration.ofMinutes(10L)).disableCachingNullValues().prefixKeysWith("product");
        HashMap<String, RedisCacheConfiguration> redisCacheConfigurationMap = new HashMap<String, RedisCacheConfiguration>();
        redisCacheConfigurationMap.put("user", userCacheConfiguration);
        redisCacheConfigurationMap.put("product", productCacheConfiguration);
        RedisCacheWriter redisCacheWriter = RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)connectionFactory);
        KryoRedisSerializer kryoRedisSerializer = new KryoRedisSerializer();
        RedisSerializationContext.SerializationPair pair = RedisSerializationContext.SerializationPair.fromSerializer(kryoRedisSerializer);
        RedisCacheConfiguration defaultCacheConfig = RedisCacheConfiguration.defaultCacheConfig().serializeValuesWith(pair);
        defaultCacheConfig.entryTtl(Duration.ofSeconds(30L));
        RedisCacheManager cacheManager = new RedisCacheManager(redisCacheWriter, defaultCacheConfig, redisCacheConfigurationMap);
        return cacheManager;
    }

    @Bean
    @Primary
    public StringRedisTemplate redisTemplate(@Autowired(required=false) RedisConnectionFactory factory) {
        if (factory == null) {
            return null;
        }
        StringRedisTemplate template = new StringRedisTemplate(factory);
        this.setSerializer(template);
        template.afterPropertiesSet();
        return template;
    }

    private void setSerializer(StringRedisTemplate template) {
        this.logger.info("\u5f00\u59cb\u8bbe\u7f6eRedis\u5e8f\u5217\u5316\u65b9\u5f0f\u4e3aKryo");
        KryoRedisSerializer kryoRedisSerializer = new KryoRedisSerializer();
        template.setValueSerializer(kryoRedisSerializer);
        template.setHashValueSerializer(kryoRedisSerializer);
    }
}

