/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.base;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.base.BaseMapper;
import com.viontech.keliu.base.BaseModel;
import com.viontech.keliu.base.BaseService;
import com.viontech.keliu.redis.annotation.RedisCache;
import com.viontech.keliu.redis.contants.RedisConstants;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseServiceImpl<T extends BaseModel>
implements BaseService<T> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, String> columnNamePropertyMap = null;

    @Override
    public T selectByPrimaryKey(Object id) {
        return this.getMapper().selectByPrimaryKey(id);
    }

    @Override
    @RedisCache(methodType=RedisConstants.MethodType.ADD)
    public T insert(T record) {
        this.getMapper().insert(record);
        return record;
    }

    @Override
    @RedisCache(methodType=RedisConstants.MethodType.ADD)
    public T insertSelective(T record) {
        this.getMapper().insertSelective(record);
        return record;
    }

    @Override
    @RedisCache(methodType=RedisConstants.MethodType.DELETE)
    public int deleteByPrimaryKey(Object b) {
        return this.getMapper().deleteByPrimaryKey(b);
    }

    @Override
    @RedisCache(methodType=RedisConstants.MethodType.UPDATE)
    public int updateByPrimaryKey(T record) {
        return this.getMapper().updateByPrimaryKey(record);
    }

    @Override
    @RedisCache(methodType=RedisConstants.MethodType.UPDATE)
    public int updateByPrimaryKeySelective(T record) {
        return this.getMapper().updateByPrimaryKeySelective(record);
    }

    @Override
    public PageInfo<T> pagedQuery(BaseExample example, int pageNum, int pageSize) {
        if (pageSize > 0) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
            Page result = (Page)this.getMapper().selectByExample(example);
            PageInfo pageInfo = new PageInfo((List)result);
            return pageInfo;
        }
        List result = this.getMapper().selectByExample(example);
        Page p = new Page();
        p.addAll(result);
        PageInfo pageInfo = new PageInfo((List)p);
        return pageInfo;
    }

    @Override
    public int countByExample(BaseExample example) {
        return this.getMapper().countByExample(example);
    }

    @Override
    @RedisCache(methodType=RedisConstants.MethodType.DELETE)
    public int deleteByExample(BaseExample example) {
        return this.getMapper().deleteByExample(example);
    }

    @Override
    public List<T> selectByExample(BaseExample example) {
        return this.getMapper().selectByExample(example);
    }

    @Override
    @RedisCache(methodType=RedisConstants.MethodType.UPDATE)
    public int updateByExampleSelective(T record, BaseExample example) {
        return this.getMapper().updateByExampleSelective(record, example);
    }

    @Override
    @RedisCache(methodType=RedisConstants.MethodType.UPDATE)
    public int updateByExample(T record, BaseExample example) {
        return this.getMapper().updateByExample(record, example);
    }

    @Override
    public List<Object> getIdsByByExample(BaseExample example) {
        List<T> list = this.selectByExample(example);
        ArrayList<Object> result = new ArrayList<Object>();
        for (BaseModel t : list) {
            Object pk = this.getPKByModel(t);
            if (pk == null) continue;
            result.add(pk);
        }
        return result;
    }

    @Override
    public Object getPKByModel(BaseModel baseModel) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getColumnNameByProperty(String property) {
        if (this.columnNamePropertyMap == null) {
            this.columnNamePropertyMap = this.getColumnNamePropertyMap();
        }
        return this.columnNamePropertyMap.get(property);
    }

    public Map getColumnNamePropertyMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            SqlSession sqlSession = this.getSqlSessionByMapper(this.getMapper());
            ResultMap resultMap = sqlSession.getConfiguration().getResultMap(this.getMapperClassByMapper(this.getMapper()).getName() + ".BaseResultMapRoot");
            List propertyResultMappings = resultMap.getPropertyResultMappings();
            for (ResultMapping resultMapping : propertyResultMappings) {
                result.put(resultMapping.getProperty(), resultMapping.getColumn());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private SqlSession getSqlSessionByMapper(BaseMapper mapper) throws Exception {
        Proxy cfr_ignored_0 = (Proxy)((Object)mapper);
        InvocationHandler mapperProxy = Proxy.getInvocationHandler(mapper);
        Field sqlSession = mapperProxy.getClass().getDeclaredField("sqlSession");
        sqlSession.setAccessible(true);
        return (SqlSession)sqlSession.get(mapperProxy);
    }

    private Class getMapperClassByMapper(BaseMapper mapper) throws Exception {
        Proxy cfr_ignored_0 = (Proxy)((Object)mapper);
        InvocationHandler mapperProxy = Proxy.getInvocationHandler(mapper);
        Field mapperInterface = mapperProxy.getClass().getDeclaredField("mapperInterface");
        mapperInterface.setAccessible(true);
        return (Class)mapperInterface.get(mapperProxy);
    }
}

