/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseExample {
    protected String orderByClause;
    protected String groupByClause;
    protected boolean distinct;
    protected boolean ignoreCase;
    protected String tableName;
    protected String tableAlias;
    protected List<GeneratedCriteria> oredCriteria = new ArrayList<GeneratedCriteria>();
    protected Map<String, ColumnContainerBase> columnContainerMap = new HashMap<String, ColumnContainerBase>();
    protected Set<String> leftJoinTableSet = new HashSet<String>();

    public void setOrderByClause(String orderByClause) {
        this.orderByClause = orderByClause;
    }

    public String getOrderByClause() {
        if (this.orderByClause == null) {
            return this.getTableAlias() + ".id";
        }
        return this.orderByClause;
    }

    public void setGroupByClause(String groupByClause) {
        this.groupByClause = groupByClause;
    }

    public String getGroupByClause() {
        return this.groupByClause;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableAlias() {
        return "\"" + this.tableAlias + "\"";
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.oredCriteria.forEach(item -> item.setIgnoreCase(this.ignoreCase));
    }

    public List<GeneratedCriteria> getOredCriteria() {
        return this.oredCriteria;
    }

    public Set<ColumnContainerBase> getColumnContainerSet() {
        if (this.columnContainerMap.size() == 0) {
            this.columnContainerMap.put(this.getTableName(), this.createColumns());
        }
        return new HashSet<ColumnContainerBase>(this.columnContainerMap.values());
    }

    public Set<String> getLeftJoinTableSet() {
        return this.leftJoinTableSet;
    }

    public void or(GeneratedCriteria criteria) {
        this.oredCriteria.add(criteria);
        if (!criteria.getTableName().equals(this.getTableName())) {
            this.leftJoinTableSet.add(criteria.getTableName());
        }
    }

    public GeneratedCriteria and(GeneratedCriteria criteria) {
        GeneratedCriteria oldCriteria = criteria;
        if (this.oredCriteria.size() <= 0) {
            this.oredCriteria.add(criteria);
        } else {
            oldCriteria = this.oredCriteria.get(this.oredCriteria.size() - 1);
            oldCriteria.getCriteria().addAll(criteria.getCriteria());
        }
        if (!criteria.getTableName().equals(this.getTableName())) {
            this.leftJoinTableSet.add(criteria.getTableName());
        }
        return oldCriteria;
    }

    public abstract GeneratedCriteria createCriteria();

    protected abstract GeneratedCriteria createCriteriaInternal();

    protected abstract ColumnContainerBase createColumns();

    public void clear() {
        this.oredCriteria.clear();
        this.columnContainerMap.clear();
        this.leftJoinTableSet.clear();
        this.orderByClause = null;
        this.groupByClause = null;
        this.distinct = false;
        this.ignoreCase = false;
    }

    protected static class ColumnContainerBase {
        private StringBuffer columnContainerStr = new StringBuffer();
        private String tableName;

        protected ColumnContainerBase(String tableName) {
            this.tableName = tableName;
        }

        public boolean isValid() {
            return this.columnContainerStr.length() > 0;
        }

        public StringBuffer getAllColumn() {
            return this.columnContainerStr;
        }

        public StringBuffer getColumnContainerStr() {
            return this.columnContainerStr;
        }

        public void addColumnStr(String column) {
            if (this.columnContainerStr.toString().indexOf(column) != -1) {
                return;
            }
            if (this.columnContainerStr.length() > 0) {
                this.columnContainerStr.append(",");
            }
            this.columnContainerStr.append(column);
        }

        public String getTableName() {
            return this.tableName;
        }
    }

    public static class Criterion {
        private String condition;
        private Object value;
        private Object secondValue;
        private boolean noValue;
        private boolean singleValue;
        private boolean betweenValue;
        private boolean listValue;
        private String typeHandler;
        private boolean ignoreCase;

        public String getCondition() {
            return this.condition;
        }

        public void setCondition(String condition) {
            this.condition = condition;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public Object getSecondValue() {
            return this.secondValue;
        }

        public boolean isNoValue() {
            return this.noValue;
        }

        public boolean isSingleValue() {
            return this.singleValue;
        }

        public void setSingleValue(boolean singleValue) {
            this.singleValue = singleValue;
        }

        public boolean isBetweenValue() {
            return this.betweenValue;
        }

        public boolean isListValue() {
            return this.listValue;
        }

        public void setListValue(boolean listValue) {
            this.listValue = listValue;
        }

        public String getTypeHandler() {
            return this.typeHandler;
        }

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public void setIgnoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            if (ignoreCase && this.value instanceof String) {
                String[] conditions = this.condition.split(" ");
                this.condition = "\"upper\"(" + conditions[0] + ") " + conditions[1];
                this.value = String.valueOf(this.value).toUpperCase();
            }
        }

        public Criterion(String condition) {
            this.condition = condition;
            this.typeHandler = null;
            this.noValue = true;
        }

        public Criterion(String condition, Object value, String typeHandler) {
            this(condition, value, typeHandler, false);
        }

        public Criterion(String condition, Object value, String typeHandler, boolean ignoreCase) {
            this.condition = condition;
            this.value = value;
            this.typeHandler = typeHandler;
            if (value instanceof List) {
                this.listValue = true;
            } else {
                this.singleValue = true;
            }
            if (ignoreCase && value instanceof String) {
                String[] conditions = condition.split(" ");
                this.condition = "\"upper\"(" + conditions[0] + ") " + conditions[1];
                this.value = String.valueOf(value).toUpperCase();
            }
        }

        public Criterion(String condition, Object value) {
            this(condition, value, false);
        }

        public Criterion(String condition, Object value, boolean ignoreCase) {
            this(condition, value, null, ignoreCase);
        }

        public Criterion(String condition, Object value, Object secondValue, String typeHandler) {
            this.condition = condition;
            this.value = value;
            this.secondValue = secondValue;
            this.typeHandler = typeHandler;
            this.betweenValue = true;
        }

        public Criterion(String condition, Object value, Object secondValue) {
            this(condition, value, secondValue, null);
        }
    }

    public static abstract class GeneratedCriteria {
        protected List<Criterion> criteria = new ArrayList<Criterion>();
        protected boolean ignoreCase = false;
        private String tableName;

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }

        public void setIgnoreCase(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
            this.criteria.forEach(item -> item.setIgnoreCase(ignoreCase));
        }

        protected GeneratedCriteria(String tableName) {
            this.tableName = tableName;
        }

        protected GeneratedCriteria(String tableName, boolean ignoreCase) {
            this(tableName);
            this.ignoreCase = ignoreCase;
        }

        public List<Criterion> getCriteria() {
            return this.criteria;
        }

        public void setCriteria(List<Criterion> criteria) {
            this.criteria = criteria;
        }

        public String getTableName() {
            return this.tableName;
        }
    }
}

