package com.viontech.keliu.converter;

import org.springframework.core.convert.converter.Converter;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/** 
 * SpringMVC 自定义 日期转换器 
 * 
 * @author :<a href="mailto:zyj@freshz.cn">章英杰</a> 
 * @date :2016-09-05 14:03:54 
 */
public class DateConverter implements Converter<String, Date>  {  
  
    /** 
     * 可格式化 的日期 字串 
     */  
    private static final List<String> formarts = new ArrayList();

    public DateConverter() {
        System.out.println("["+new Date()+"] [INFO] ("+this.getClass().getName()+")  -   日期格式化组件创建成功");
    }

    static{
        formarts.add("yyyy-MM");  
        formarts.add("yyyy-MM-dd");  
        formarts.add("yyyy-MM-dd HH:mm");
        formarts.add("yyyy-MM-dd HH:mm:ss");
        formarts.add("HH:mm:ss");
        formarts.add("HH:mm");
    }
  
    @Override  
    public Date convert(String source) {  
        String value = source.trim();  
        if ("".equals(value)) {  
            return null;  
        }  
        if(source.matches("^\\d{4}-\\d{1,2}$")){   
            return parseDate(source, formarts.get(0));  
        }else if(source.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$")){  
            return parseDate(source, formarts.get(1));  
        }else if(source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}$")){  
            return parseDate(source, formarts.get(2));  
        }else if(source.matches("^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{1,2}:\\d{1,2}:\\d{1,2}$")){  
            return parseDate(source, formarts.get(3));  
        }else if(source.matches("([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]")){
            return parseDate(source, formarts.get(4));
        }else if(source.matches("([01][0-9]|2[0-3]):[0-5][0-9]")){
            return parseDate(source, formarts.get(5));
        }else {
            throw new IllegalArgumentException("Invalid boolean value '" + source + "'");  
        }  
    }  
  
    /** 
     * 功能描述：格式化日期 
     * 
     * @param dateStr String 字符型日期 
     * @param format  String 格式 
     * @return Date 日期 
     */  
    public  Date parseDate(String dateStr, String format) {  
        Date date=null;  
        try {  
            DateFormat dateFormat = new SimpleDateFormat(format);  
            date = (Date) dateFormat.parse(dateStr);  
        } catch (Exception e) {  
        }  
        return date;  
    }  
  
    public static void main(String[] args) {  
        System.err.println(new DateConverter().convert("12:00"));
    }  
}  