package com.viontech.keliu.configuration;

import com.viontech.keliu.converter.DateConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.Date;

/**
 * 
 * @author vion
 *
 */

@Configuration
public class WebConfiguration implements WebMvcConfigurer {
	@Bean
    public Converter<String, Date> addNewConvert() {
        return new DateConverter();
    }
	
  @Override  
    public void addCorsMappings(CorsRegistry registry) {  
        registry.addMapping("/**")
                .allowedOrigins("*")  
                .allowCredentials(true)  
                .allowedMethods("GET", "POST", "DELETE", "PUT")  
                .maxAge(3600);  
    }
	
}

