package com.viontech.keliu.controller.web;

import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.configuration.WxMpConfig;
import com.viontech.keliu.controller.base.TemplateBaseController;
import com.viontech.keliu.i18n.util.LocalMessageUtil;
import com.viontech.keliu.model.*;
import com.viontech.keliu.service.adapter.UserService;
import com.viontech.keliu.service.impl.TemplateServiceImpl;
import com.viontech.keliu.service.impl.UserResourceMointorServiceImpl;
import com.viontech.keliu.util.JsonMessageUtil;
import com.viontech.keliu.vo.TemplateVo;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.*;
import java.util.stream.Collectors;

@Controller
@RequestMapping("/templates")
public class TemplateController extends TemplateBaseController {

    @Autowired
    private UserService userService;

    @Autowired
    UserResourceMointorServiceImpl userResourceMointorService;

    @Autowired
    TemplateServiceImpl templateService;

    @Autowired
    WxMpConfig wxMpConfig;

    @Override
    protected BaseExample getExample(TemplateVo templateVo, int type) {
        TemplateExample templateExample = (TemplateExample)super.getExample(templateVo,type);
        return templateExample;
    }

    @Override
    @PostMapping("")
    @ResponseBody
    public Object add(@RequestBody TemplateVo templateVo) {

        templateVo.setUnid(UUID.randomUUID().toString().replaceAll("-",""));
        Template template= templateService.insertSelective(templateVo);

        return JsonMessageUtil.getSuccessJsonMsg(LocalMessageUtil.getMessage("addSuccess", this.getClass()), template);
    }

    @PostMapping("/{templateId}")
    @ResponseBody
    public Object updateTemplate(@RequestBody TemplateVo templateVo, @PathVariable(name = "templateId") Long templateId)
    {
        TemplateExample templateExample=new TemplateExample();
        templateExample.createCriteria().andIdEqualTo(templateId);
        List<Template> templateList= templateService.selectByExample(templateExample);
        if(templateList.size()>0)
        {
            Template template=templateList.get(0);
            templateVo.setId(template.getId());
            templateVo.setUnid(template.getUnid());
            templateService.updateByPrimaryKey(templateVo);
        }
        return JsonMessageUtil.getSuccessJsonMsg(LocalMessageUtil.getMessage("addSuccess", this.getClass()), templateVo);
    }

    @RequestMapping(
            value = {"/{id}/fdsfdsfds/fdsfdsf"},
            method = {RequestMethod.GET}
    )
    @ResponseBody
    public Object selOne(@PathVariable("id") Long id) {
        return null;
    }

    @GetMapping("/{id}")
    @ResponseBody
    public Object getTemplateById(@PathVariable(name = "id") Long id)
    {
        TemplateExample templateExample=new TemplateExample();
        templateExample.createCriteria().andIdEqualTo(id);
        List<Template> templateList= templateService.selectByExample(templateExample);
        Template template=new Template();
        if(templateList.size()>0)
        {
            template= templateList.get(0);
        }
        return JsonMessageUtil.getSuccessJsonMsg(LocalMessageUtil.getMessage("addSuccess", this.getClass()), template);
    }

    @PostMapping("/send")
    @ResponseBody
    public Object unbindResource(@RequestBody  ArrayList<Alarm> alarms) {
        List<String> resourceUnids = new ArrayList<>();
        Map<String,List<Alarm>> alarmMap = new HashMap<>();
        for(Alarm alarm:alarms){
            String resourceUnid=alarm.getResourceUnid();
            resourceUnids.add(resourceUnid);
            List<Alarm> alarmList = alarmMap.get(resourceUnid);
            if(alarmList == null){
                alarmList = new ArrayList<>();
                alarmMap.put(resourceUnid,alarmList);
            }

            alarmList.add(alarm);
        }
        UserResourceMointorExample userResourceMointorExample = new UserResourceMointorExample();
        userResourceMointorExample.createCriteria().andResourceUnidIn(resourceUnids);
        List<UserResourceMointor> userResourceMointors = userResourceMointorService.selectByExample(userResourceMointorExample);
        Map<String, List<UserResourceMointor>> userResourceMap = userResourceMointors.stream().collect(Collectors.groupingBy(UserResourceMointor::getUserUnid));

        if(userResourceMap.size()<=0){
            System.out.println("找不到用户和资源绑定关系");

            return JsonMessageUtil.getSuccessJsonMsg("本次需要报警的资源没有用户关注");
        }
        UserExample userExample = new UserExample();
        userExample.createCriteria().andUnidIn(new ArrayList(userResourceMap.keySet()));
        List<User> users = userService.selectByExample(userExample);
        Map<String, String> userCodeMap = users.stream().collect(Collectors.toMap(User::getUnid, User::getCode));
        userResourceMap.forEach((userUnid,value)->{
            List<Alarm> alarmList = new ArrayList<>();
            for (UserResourceMointor userResourceMointor : value) {
                List<Alarm> as = alarmMap.get(userResourceMointor.getResourceUnid());
                if(as == null || as.isEmpty()) continue;
                alarmList.addAll(as);
            }
            alarmList = polymerize(alarmList);
            String code =  userCodeMap.get(userUnid);
            for (Alarm alarm : alarmList) {
                //给 user 发送 消息
                WxMpService wxMpService=wxMpConfig.wxMpService();
                WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder()
                        .toUser(code).templateId(alarm.getTemplateId()).build();

                templateMessage.addData(new WxMpTemplateData("first", alarm.getData().getFirst().getValue().toString(),null));
                Data data = alarm.getData();
                if(data.getKeyword1()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword1", data.getKeyword1().getValue().toString(), null));
                if(data.getKeyword2()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword2", data.getKeyword2().getValue().toString(), null));
                if(data.getKeyword3()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword3", data.getKeyword3().getValue().toString(), null));
                if(data.getKeyword4()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword4", data.getKeyword4().getValue().toString(), null));
                if(data.getKeyword5()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword5", data.getKeyword5().getValue().toString(), null));
                if(data.getKeyword6()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword6", data.getKeyword6().getValue().toString(), null));
                if(data.getKeyword7()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword7", data.getKeyword7().getValue().toString(), null));
                if(data.getKeyword8()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword8", data.getKeyword8().getValue().toString(), null));
                if(data.getKeyword9()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword9", data.getKeyword9().getValue().toString(), null));
                if(data.getKeyword10()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword10", data.getKeyword10().getValue().toString(), null));
                if(data.getRemark()!=null)
                    templateMessage.addData(new WxMpTemplateData("remark", data.getRemark().getValue().toString(), null));

                try {
                    wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
                } catch (WxErrorException e) {
                    e.printStackTrace();
                }
                System.out.println("给用户"+code+"发送消息："+alarm.toString());
            }
        });
        return JsonMessageUtil.getSuccessJsonMsg(LocalMessageUtil.getMessage("addSuccess", this.getClass()));
    }


    @PostMapping("/error/send")
    @ResponseBody
    public Object unbindResourceTemp(@RequestBody  Alarm alarm) {
                //给 user 发送 消息
                WxMpService wxMpService=wxMpConfig.wxMpService();
                WxMpTemplateMessage templateMessage = WxMpTemplateMessage.builder()
                        .toUser("o69nr1UOP2mNXQCZdqPKBfESHvTs").templateId(alarm.getTemplateId()).build();
                templateMessage.addData(new WxMpTemplateData("first", alarm.getData().getFirst().getValue().toString(),null));
                Data data = alarm.getData();
                if(data.getKeyword1()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword1", data.getKeyword1().getValue().toString(), null));
                if(data.getKeyword2()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword2", data.getKeyword2().getValue().toString(), null));
                if(data.getKeyword3()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword3", data.getKeyword3().getValue().toString(), null));
                if(data.getKeyword4()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword4", data.getKeyword4().getValue().toString(), null));
                if(data.getKeyword5()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword5", data.getKeyword5().getValue().toString(), null));
                if(data.getKeyword6()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword6", data.getKeyword6().getValue().toString(), null));
                if(data.getKeyword7()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword7", data.getKeyword7().getValue().toString(), null));
                if(data.getKeyword8()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword8", data.getKeyword8().getValue().toString(), null));
                if(data.getKeyword9()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword9", data.getKeyword9().getValue().toString(), null));
                if(data.getKeyword10()!=null)
                    templateMessage.addData(new WxMpTemplateData("keyword10", data.getKeyword10().getValue().toString(), null));
                if(data.getRemark()!=null)
                    templateMessage.addData(new WxMpTemplateData("remark", data.getRemark().getValue().toString(), null));

                try {
                    wxMpService.getTemplateMsgService().sendTemplateMsg(templateMessage);
                } catch (WxErrorException e) {
                    e.printStackTrace();
                }
                System.out.println("给管理员发送消息："+alarm.toString());
        return JsonMessageUtil.getSuccessJsonMsg(LocalMessageUtil.getMessage("addSuccess", this.getClass()));
    }

    private List<Alarm> polymerize(List<Alarm> alarms){
       List<Alarm> result = new ArrayList<>();
       for(Alarm currentAlarm:alarms){
           Alarm resultAlarm = findEqualsAlarm(result,currentAlarm);//去结果集中查找是否有相同的Alarm  如果有返回  没有 返回null
           if(resultAlarm == null){//如果没有相同的可以聚合的报警 那么将该报警 添加到结果集中
               result.add(currentAlarm);
           }else{// 如果有相同的可以聚合的报警  将当前报警聚合到结果集里面的报警中
               resultAlarm.getData().getRemark().setValue(resultAlarm.getData().getRemark().getValue()+","+currentAlarm.getData().getRemark().getValue());
           }
       }
       return result;
    }

    private Alarm findEqualsAlarm(List<Alarm> result,Alarm alarm){
        for (Alarm alarm1 : result) {
            if(alarmEquals(alarm,alarm1)){
                return alarm1;
            }
        }
        return null;
    }

    private boolean alarmEquals(Alarm alarm1 , Alarm alarm2){
        Data data1 = alarm1.getData();
        Data data2 = alarm2.getData();
        if(!keyWordEquals(data1.getFirst(),data2.getFirst())){
            return false;
        }
        if(!keyWordEquals(data1.getKeyword1(),data2.getKeyword1())){
            return false;
        }
        if(!keyWordEquals(data1.getKeyword2(),data2.getKeyword2())){
            return false;
        }
        if(!keyWordEquals(data1.getKeyword3(),data2.getKeyword3())){
            return false;
        }
        if(!keyWordEquals(data1.getKeyword4(),data2.getKeyword4())){
            return false;
        }
        if(!keyWordEquals(data1.getKeyword5(),data2.getKeyword5())){
            return false;
        }
        if(!keyWordEquals(data1.getKeyword6(),data2.getKeyword6())){
            return false;
        }
        if(!keyWordEquals(data1.getKeyword7(),data2.getKeyword7())){
            return false;
        }
        if(!keyWordEquals(data1.getKeyword8(),data2.getKeyword8())){
            return false;
        }
        if(!keyWordEquals(data1.getKeyword9(),data2.getKeyword9())){
            return false;
        }
        if(!keyWordEquals(data1.getKeyword10(),data2.getKeyword10())){
            return false;
        }
        return true;
    }

    private boolean keyWordEquals(DataItem keyword1,DataItem keyword2){
        if(keyword1==null && keyword2 ==null){
            return true;
        }
        if(keyword1==null || keyword2 == null){
            return false;
        }
        if(keyword1.getValue() == null && keyword2.getValue() == null){
            return true;
        }
        if(keyword1.getValue() == null || keyword2.getValue() == null){
            return false;
        }
        if(!keyword1.getValue().equals(keyword2.getValue())){
            return false;
        }
        return true;
    }
}