package com.viontech.keliu.controller.base;

import com.viontech.keliu.base.BaseController;
import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.base.BaseMapper;
import com.viontech.keliu.base.BaseService;
import com.viontech.keliu.mapper.UserMapper;
import com.viontech.keliu.model.User;
import com.viontech.keliu.model.UserExample;
import com.viontech.keliu.service.adapter.UserService;
import com.viontech.keliu.vo.UserVo;
import javax.annotation.Resource;

public abstract class UserBaseController extends BaseController<User, UserVo> {
    @Resource
    protected UserService userService;

    @Override
    protected BaseExample getExample(UserVo userVo, int type) {
        UserExample userExample = new UserExample();
        UserExample.Criteria criteria = userExample.createCriteria();
        if(userVo.getId() != null) {
            criteria.andIdEqualTo(userVo.getId());
        }
        if(userVo.getId_arr() != null) {
            criteria.andIdIn(userVo.getId_arr());
        }
        if(userVo.getId_gt() != null) {
            criteria.andIdGreaterThan(userVo.getId_gt());
        }
        if(userVo.getId_lt() != null) {
            criteria.andIdLessThan(userVo.getId_lt());
        }
        if(userVo.getId_gte() != null) {
            criteria.andIdGreaterThanOrEqualTo(userVo.getId_gte());
        }
        if(userVo.getId_lte() != null) {
            criteria.andIdLessThanOrEqualTo(userVo.getId_lte());
        }
        if(userVo.getUnid() != null) {
            criteria.andUnidEqualTo(userVo.getUnid());
        }
        if(userVo.getUnid_like() != null) {
            criteria.andUnidLike(userVo.getUnid_like());
        }
        if(userVo.getType() != null) {
            criteria.andTypeEqualTo(userVo.getType());
        }
        if(userVo.getType_like() != null) {
            criteria.andTypeLike(userVo.getType_like());
        }
        if(userVo.getCode() != null) {
            criteria.andCodeEqualTo(userVo.getCode());
        }
        if(userVo.getCode_like() != null) {
            criteria.andCodeLike(userVo.getCode_like());
        }
        if(userVo.getModifyTime() != null) {
            criteria.andModifyTimeEqualTo(userVo.getModifyTime());
        }
        if(userVo.getModifyTime_gt() != null) {
            criteria.andModifyTimeGreaterThan(userVo.getModifyTime_gt());
        }
        if(userVo.getModifyTime_lt() != null) {
            criteria.andModifyTimeLessThan(userVo.getModifyTime_lt());
        }
        if(userVo.getModifyTime_gte() != null) {
            criteria.andModifyTimeGreaterThanOrEqualTo(userVo.getModifyTime_gte());
        }
        if(userVo.getModifyTime_lte() != null) {
            criteria.andModifyTimeLessThanOrEqualTo(userVo.getModifyTime_lte());
        }
        if(userVo.getCreateTime() != null) {
            criteria.andCreateTimeEqualTo(userVo.getCreateTime());
        }
        if(userVo.getCreateTime_gt() != null) {
            criteria.andCreateTimeGreaterThan(userVo.getCreateTime_gt());
        }
        if(userVo.getCreateTime_lt() != null) {
            criteria.andCreateTimeLessThan(userVo.getCreateTime_lt());
        }
        if(userVo.getCreateTime_gte() != null) {
            criteria.andCreateTimeGreaterThanOrEqualTo(userVo.getCreateTime_gte());
        }
        if(userVo.getCreateTime_lte() != null) {
            criteria.andCreateTimeLessThanOrEqualTo(userVo.getCreateTime_lte());
        }
        if(userVo.getIsActive() != null) {
            criteria.andIsActiveEqualTo(userVo.getIsActive());
        }
        if(userVo.getIsActive_gt() != null) {
            criteria.andIsActiveGreaterThan(userVo.getIsActive_gt());
        }
        if(userVo.getIsActive_lt() != null) {
            criteria.andIsActiveLessThan(userVo.getIsActive_lt());
        }
        if(userVo.getIsActive_gte() != null) {
            criteria.andIsActiveGreaterThanOrEqualTo(userVo.getIsActive_gte());
        }
        if(userVo.getIsActive_lte() != null) {
            criteria.andIsActiveLessThanOrEqualTo(userVo.getIsActive_lte());
        }
        return userExample;
    }

    @Override
    protected BaseService<User> getService() {
        return userService;
    }
}