package com.viontech.keliu.controller.base;

import com.viontech.keliu.base.BaseController;
import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.base.BaseMapper;
import com.viontech.keliu.base.BaseService;
import com.viontech.keliu.mapper.TemplateMapper;
import com.viontech.keliu.model.Template;
import com.viontech.keliu.model.TemplateExample;
import com.viontech.keliu.service.adapter.TemplateService;
import com.viontech.keliu.vo.TemplateVo;
import javax.annotation.Resource;

public abstract class TemplateBaseController extends BaseController<Template, TemplateVo> {
    @Resource
    protected TemplateService templateService;

    @Override
    protected BaseExample getExample(TemplateVo templateVo, int type) {
        TemplateExample templateExample = new TemplateExample();
        TemplateExample.Criteria criteria = templateExample.createCriteria();
        if(templateVo.getId() != null) {
            criteria.andIdEqualTo(templateVo.getId());
        }
        if(templateVo.getId_arr() != null) {
            criteria.andIdIn(templateVo.getId_arr());
        }
        if(templateVo.getId_gt() != null) {
            criteria.andIdGreaterThan(templateVo.getId_gt());
        }
        if(templateVo.getId_lt() != null) {
            criteria.andIdLessThan(templateVo.getId_lt());
        }
        if(templateVo.getId_gte() != null) {
            criteria.andIdGreaterThanOrEqualTo(templateVo.getId_gte());
        }
        if(templateVo.getId_lte() != null) {
            criteria.andIdLessThanOrEqualTo(templateVo.getId_lte());
        }
        if(templateVo.getUnid() != null) {
            criteria.andUnidEqualTo(templateVo.getUnid());
        }
        if(templateVo.getUnid_like() != null) {
            criteria.andUnidLike(templateVo.getUnid_like());
        }
        if(templateVo.getWechatUnid() != null) {
            criteria.andWechatUnidEqualTo(templateVo.getWechatUnid());
        }
        if(templateVo.getWechatUnid_like() != null) {
            criteria.andWechatUnidLike(templateVo.getWechatUnid_like());
        }
        if(templateVo.getMessageUnid() != null) {
            criteria.andMessageUnidEqualTo(templateVo.getMessageUnid());
        }
        if(templateVo.getMessageUnid_like() != null) {
            criteria.andMessageUnidLike(templateVo.getMessageUnid_like());
        }
        if(templateVo.getEmailUnid() != null) {
            criteria.andEmailUnidEqualTo(templateVo.getEmailUnid());
        }
        if(templateVo.getEmailUnid_like() != null) {
            criteria.andEmailUnidLike(templateVo.getEmailUnid_like());
        }
        if(templateVo.getTitle() != null) {
            criteria.andTitleEqualTo(templateVo.getTitle());
        }
        if(templateVo.getTitle_like() != null) {
            criteria.andTitleLike(templateVo.getTitle_like());
        }
        if(templateVo.getPrimaryIndustry() != null) {
            criteria.andPrimaryIndustryEqualTo(templateVo.getPrimaryIndustry());
        }
        if(templateVo.getPrimaryIndustry_like() != null) {
            criteria.andPrimaryIndustryLike(templateVo.getPrimaryIndustry_like());
        }
        if(templateVo.getDeputyIndustry() != null) {
            criteria.andDeputyIndustryEqualTo(templateVo.getDeputyIndustry());
        }
        if(templateVo.getDeputyIndustry_like() != null) {
            criteria.andDeputyIndustryLike(templateVo.getDeputyIndustry_like());
        }
        if(templateVo.getContent() != null) {
            criteria.andContentEqualTo(templateVo.getContent());
        }
        if(templateVo.getContent_like() != null) {
            criteria.andContentLike(templateVo.getContent_like());
        }
        if(templateVo.getExample() != null) {
            criteria.andExampleEqualTo(templateVo.getExample());
        }
        if(templateVo.getExample_like() != null) {
            criteria.andExampleLike(templateVo.getExample_like());
        }
        if(templateVo.getModifyTime() != null) {
            criteria.andModifyTimeEqualTo(templateVo.getModifyTime());
        }
        if(templateVo.getModifyTime_gt() != null) {
            criteria.andModifyTimeGreaterThan(templateVo.getModifyTime_gt());
        }
        if(templateVo.getModifyTime_lt() != null) {
            criteria.andModifyTimeLessThan(templateVo.getModifyTime_lt());
        }
        if(templateVo.getModifyTime_gte() != null) {
            criteria.andModifyTimeGreaterThanOrEqualTo(templateVo.getModifyTime_gte());
        }
        if(templateVo.getModifyTime_lte() != null) {
            criteria.andModifyTimeLessThanOrEqualTo(templateVo.getModifyTime_lte());
        }
        if(templateVo.getCreateTime() != null) {
            criteria.andCreateTimeEqualTo(templateVo.getCreateTime());
        }
        if(templateVo.getCreateTime_gt() != null) {
            criteria.andCreateTimeGreaterThan(templateVo.getCreateTime_gt());
        }
        if(templateVo.getCreateTime_lt() != null) {
            criteria.andCreateTimeLessThan(templateVo.getCreateTime_lt());
        }
        if(templateVo.getCreateTime_gte() != null) {
            criteria.andCreateTimeGreaterThanOrEqualTo(templateVo.getCreateTime_gte());
        }
        if(templateVo.getCreateTime_lte() != null) {
            criteria.andCreateTimeLessThanOrEqualTo(templateVo.getCreateTime_lte());
        }
        if(templateVo.getStatus() != null) {
            criteria.andStatusEqualTo(templateVo.getStatus());
        }
        if(templateVo.getStatus_gt() != null) {
            criteria.andStatusGreaterThan(templateVo.getStatus_gt());
        }
        if(templateVo.getStatus_lt() != null) {
            criteria.andStatusLessThan(templateVo.getStatus_lt());
        }
        if(templateVo.getStatus_gte() != null) {
            criteria.andStatusGreaterThanOrEqualTo(templateVo.getStatus_gte());
        }
        if(templateVo.getStatus_lte() != null) {
            criteria.andStatusLessThanOrEqualTo(templateVo.getStatus_lte());
        }
        return templateExample;
    }

    @Override
    protected BaseService<Template> getService() {
        return templateService;
    }
}