package com.viontech.keliu.controller.base;

import com.viontech.keliu.base.BaseController;
import com.viontech.keliu.base.BaseExample;
import com.viontech.keliu.base.BaseMapper;
import com.viontech.keliu.base.BaseService;
import com.viontech.keliu.mapper.GroupMapper;
import com.viontech.keliu.model.Group;
import com.viontech.keliu.model.GroupExample;
import com.viontech.keliu.service.adapter.GroupService;
import com.viontech.keliu.vo.GroupVo;
import javax.annotation.Resource;

public abstract class GroupBaseController extends BaseController<Group, GroupVo> {
    @Resource
    protected GroupService groupService;

    @Override
    protected BaseExample getExample(GroupVo groupVo, int type) {
        GroupExample groupExample = new GroupExample();
        GroupExample.Criteria criteria = groupExample.createCriteria();
        if(groupVo.getId() != null) {
            criteria.andIdEqualTo(groupVo.getId());
        }
        if(groupVo.getId_arr() != null) {
            criteria.andIdIn(groupVo.getId_arr());
        }
        if(groupVo.getId_gt() != null) {
            criteria.andIdGreaterThan(groupVo.getId_gt());
        }
        if(groupVo.getId_lt() != null) {
            criteria.andIdLessThan(groupVo.getId_lt());
        }
        if(groupVo.getId_gte() != null) {
            criteria.andIdGreaterThanOrEqualTo(groupVo.getId_gte());
        }
        if(groupVo.getId_lte() != null) {
            criteria.andIdLessThanOrEqualTo(groupVo.getId_lte());
        }
        if(groupVo.getUnid() != null) {
            criteria.andUnidEqualTo(groupVo.getUnid());
        }
        if(groupVo.getUnid_like() != null) {
            criteria.andUnidLike(groupVo.getUnid_like());
        }
        if(groupVo.getEndTime() != null) {
            criteria.andEndTimeEqualTo(groupVo.getEndTime());
        }
        if(groupVo.getEndTime_gt() != null) {
            criteria.andEndTimeGreaterThan(groupVo.getEndTime_gt());
        }
        if(groupVo.getEndTime_lt() != null) {
            criteria.andEndTimeLessThan(groupVo.getEndTime_lt());
        }
        if(groupVo.getEndTime_gte() != null) {
            criteria.andEndTimeGreaterThanOrEqualTo(groupVo.getEndTime_gte());
        }
        if(groupVo.getEndTime_lte() != null) {
            criteria.andEndTimeLessThanOrEqualTo(groupVo.getEndTime_lte());
        }
        if(groupVo.getModifyTime() != null) {
            criteria.andModifyTimeEqualTo(groupVo.getModifyTime());
        }
        if(groupVo.getModifyTime_gt() != null) {
            criteria.andModifyTimeGreaterThan(groupVo.getModifyTime_gt());
        }
        if(groupVo.getModifyTime_lt() != null) {
            criteria.andModifyTimeLessThan(groupVo.getModifyTime_lt());
        }
        if(groupVo.getModifyTime_gte() != null) {
            criteria.andModifyTimeGreaterThanOrEqualTo(groupVo.getModifyTime_gte());
        }
        if(groupVo.getModifyTime_lte() != null) {
            criteria.andModifyTimeLessThanOrEqualTo(groupVo.getModifyTime_lte());
        }
        if(groupVo.getCreateTime() != null) {
            criteria.andCreateTimeEqualTo(groupVo.getCreateTime());
        }
        if(groupVo.getCreateTime_gt() != null) {
            criteria.andCreateTimeGreaterThan(groupVo.getCreateTime_gt());
        }
        if(groupVo.getCreateTime_lt() != null) {
            criteria.andCreateTimeLessThan(groupVo.getCreateTime_lt());
        }
        if(groupVo.getCreateTime_gte() != null) {
            criteria.andCreateTimeGreaterThanOrEqualTo(groupVo.getCreateTime_gte());
        }
        if(groupVo.getCreateTime_lte() != null) {
            criteria.andCreateTimeLessThanOrEqualTo(groupVo.getCreateTime_lte());
        }
        return groupExample;
    }

    @Override
    protected BaseService<Group> getService() {
        return groupService;
    }
}