package com.viontech.keliu.configuration;

import com.viontech.keliu.util.JsonMessageUtil;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.api.WxMpInMemoryConfigStorage;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.result.WxMpOAuth2AccessToken;
import me.chanjar.weixin.mp.bean.result.WxMpUser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WxMpConfig {

    @Value("${wx.AppId:}")
    private String AppId;
    @Value("${wx.Secret:}")
    private String Secret;

    @Bean("wxMpService")
    public WxMpService wxMpService(){
        WxMpService wxMpService=new WxMpServiceImpl();
        WxMpInMemoryConfigStorage config = new WxMpInMemoryConfigStorage();
        config.setAppId(AppId); // 设置微信公众号的appid
        config.setSecret(Secret); // 设置微信公众号的app corpSecret
        wxMpService.setWxMpConfigStorage(config);
        return wxMpService;
    }
}
