/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public final class MessageUtil {
    protected static Logger logger = LoggerFactory.getLogger(MessageUtil.class);
    private static WebApplicationContext webApplicationContext;
    private static Locale locale;

    public static String getMessage(String code) {
        return MessageUtil.getMessage((String)code, null, null);
    }

    public static String getMessage(String code, Object[] args) {
        return MessageUtil.getMessage((String)code, (Object[])args, null);
    }

    public static String getMessage(String code, Class objectClass) {
        return MessageUtil.getMessage((String)code, null, (Class)objectClass);
    }

    public static String getMessage(String code, Object[] args, Class objectClass) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String codeKey = code;
        if (objectClass != null) {
            StringBuilder sb = new StringBuilder(objectClass.getSimpleName());
            sb.append(".");
            sb.append(code);
            codeKey = sb.toString();
        }
        try {
            if (request != null) {
                return MessageUtil.getMessageByRequest((String)codeKey, (Object[])args, (HttpServletRequest)request);
            }
            return MessageUtil.getMessageByResourceBundle((String)codeKey, (Object[])args);
        }
        catch (Exception sb) {
            try {
                if (request != null) {
                    return MessageUtil.getMessageByRequest((String)code, (Object[])args, (HttpServletRequest)request);
                }
                return MessageUtil.getMessageByResourceBundle((String)code, (Object[])args);
            }
            catch (Exception e) {
                StringBuilder sb2 = new StringBuilder();
                sb2.append("\u8bf7\u5728 ");
                sb2.append(locale.toString());
                sb2.append(" \u8d44\u6e90\u6587\u4ef6\u4e2d\u914d\u7f6e ");
                sb2.append(code);
                sb2.append(" \u6216 ");
                sb2.append(codeKey);
                logger.error(sb2.toString(), (Throwable)e);
                return codeKey;
            }
        }
    }

    private static String getMessageByRequest(String code, Object[] args, HttpServletRequest request) {
        if (webApplicationContext == null) {
            webApplicationContext = (WebApplicationContext)request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        Locale locale = Locale.CHINA;
        try {
            LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
            locale = localeResolver.resolveLocale(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return webApplicationContext.getMessage(code, args, locale);
    }

    public static Locale getLocale() {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (servletRequestAttributes == null) {
            return locale;
        }
        HttpServletRequest request = servletRequestAttributes.getRequest();
        if (request == null) {
            return locale;
        }
        if (webApplicationContext == null) {
            webApplicationContext = (WebApplicationContext)request.getAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        }
        Locale l = locale;
        try {
            LocaleResolver localeResolver = RequestContextUtils.getLocaleResolver((HttpServletRequest)request);
            l = localeResolver.resolveLocale(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public static boolean isEn() {
        Locale l = MessageUtil.getLocale();
        return l != null && "en".equalsIgnoreCase(l.getLanguage());
    }

    private static String getMessageByResourceBundle(String code, Object[] args) {
        ResourceBundle myResourcesCN = ResourceBundle.getBundle("messages/message", locale);
        return MessageFormat.format(myResourcesCN.getString(code), args);
    }

    public static void setLocale(Locale localeVal) {
        locale = localeVal;
    }

    static {
        locale = Locale.CHINA;
    }
}

