/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.content.CountDataContent;
import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.dao.CountDataDao;
import com.viontech.keliu.dao.FaceRecognitionDao;
import com.viontech.keliu.dao.FaceRecognitionRawDao;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.CountData;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class WorkQueueProcessService {
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private FaceRecognitionRawDao faceRecognitionRawDao;
    @Autowired
    private FaceRecognitionDao faceRecognitionDao;
    @Autowired
    private CountDataDao countDataDao;
    @Autowired
    private OrgCacheService orgCacheService;
    private ThreadLocal<SimpleDateFormat> shortFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMdd"));
    private ThreadLocal<SimpleDateFormat> longFormat = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyyMMddHHmmss"));
    private Logger logger = LoggerFactory.getLogger(WorkQueueProcessService.class);

    public boolean isRawFaceDataInDB(Map<String, Set> dbKeyMap, FaceDataContent faceDataContent) {
        Date countDate = faceDataContent.getCountDate();
        String shortDateStr = DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)countDate);
        String key = "faceData:" + shortDateStr;
        HashSet<String> set = dbKeyMap.get(key);
        SimpleDateFormat simpleLongFormat = (SimpleDateFormat)this.longFormat.get();
        if (set == null || set.size() <= 0) {
            set = new HashSet<String>();
            List faceRecognitions = this.faceRecognitionRawDao.selCacheInfo(countDate);
            for (FaceRecognition faceRecognition : faceRecognitions) {
                String unid = faceRecognition.getUnid();
                Date counttime = faceRecognition.getCounttime();
                String channelSerialnum = faceRecognition.getChannelSerialnum();
                String dateStr = simpleLongFormat.format(counttime);
                set.add(channelSerialnum + ":" + dateStr + ":" + unid);
            }
            dbKeyMap.put(key, set);
        }
        String channelSerialnum = faceDataContent.getChannelSerialnum();
        String dateStr = simpleLongFormat.format(countDate);
        String unid = faceDataContent.getPersonId();
        String redisKey = channelSerialnum + ":" + dateStr + ":" + unid;
        if (set.contains(redisKey)) {
            return true;
        }
        this.redisTemplate.boundSetOps((Object)("faceRecognitionRawKey:" + shortDateStr)).remove(new Object[]{redisKey});
        return false;
    }

    public Boolean isCountDataInDB(Map<String, Set> keyMap, CountDataContent countDataContent) {
        Date countDate = countDataContent.getCountdate();
        String key = "countDataRawKey:" + DateUtil.format((String)"yyyyMMdd", (Date)countDate);
        HashSet<String> set = keyMap.get(key);
        if (set == null || set.size() <= 0) {
            set = new HashSet<String>();
            List countDatas = this.countDataDao.selCacheInfo(countDate);
            for (CountData countData : countDatas) {
                Date countTime = countData.getCountTime();
                String channelSerialnum = countData.getChannelSerialnum();
                String format = ((SimpleDateFormat)this.longFormat.get()).format(countTime);
                set.add(channelSerialnum + ":" + format);
            }
            keyMap.put(key, set);
        }
        String channelSerialnumItem = countDataContent.getChannelno();
        String formatItem = ((SimpleDateFormat)this.longFormat.get()).format(countDataContent.getCountdate());
        String redisKey = channelSerialnumItem + ":" + formatItem;
        if (set.contains(redisKey)) {
            return true;
        }
        this.redisTemplate.boundSetOps((Object)("countDataRawKey:" + ((SimpleDateFormat)this.shortFormat.get()).format(countDate))).remove(new Object[]{redisKey});
        return false;
    }

    public Boolean isFaceDataInDB(Map<String, Set> keyMap, FaceDataContent faceDataContent, Map<String, Channel> channelMap) {
        Date countDate = faceDataContent.getCountDate();
        String key = "faceRecognitionList:" + ((SimpleDateFormat)this.shortFormat.get()).format(countDate);
        HashSet<String> set = keyMap.get(key);
        if (set == null || set.size() <= 0) {
            set = new HashSet<String>();
            Date date = null;
            try {
                date = DateUtil.parse((String)"yyyy-MM-dd 00:00:00", (String)DateUtil.format((String)"yyyy-MM-dd 00:00:00", (Date)countDate));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            List faceRecognitions = this.faceRecognitionDao.selCacheInfo(date);
            for (FaceRecognition faceRecognition : faceRecognitions) {
                String unid = faceRecognition.getUnid();
                Date counttime = faceRecognition.getCounttime();
                String channelSerialnum = faceRecognition.getChannelSerialnum();
                String dateStr = ((SimpleDateFormat)this.longFormat.get()).format(counttime);
                set.add(channelSerialnum + ":" + dateStr + ":" + unid);
            }
            keyMap.put(key, set);
        }
        String channelSerialnum = faceDataContent.getChannelSerialnum();
        String dateStr = ((SimpleDateFormat)this.longFormat.get()).format(faceDataContent.getCountDate());
        String unid = faceDataContent.getPersonId();
        String redisKey = channelSerialnum + ":" + dateStr + ":" + unid;
        if (set.contains(redisKey)) {
            return true;
        }
        Channel channel = channelMap.get(faceDataContent.getChannelSerialnum());
        if (channel != null && channel.getMallId() != null) {
            this.redisTemplate.boundSetOps((Object)("faceRecognitionKey:" + ((SimpleDateFormat)this.shortFormat.get()).format(faceDataContent.getCountDate()) + ":" + channel.getMallId())).remove(new Object[]{redisKey});
        } else {
            this.logger.warn("\u65e0\u6cd5\u79fb\u9664faceRecognitionKey {}", (Object)redisKey);
        }
        return false;
    }
}

