/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.dao.StaffBodyDao;
import com.viontech.keliu.dao.StaffDao;
import com.viontech.keliu.dao.StaffFaceDao;
import com.viontech.keliu.match.AbstractMatchService;
import com.viontech.keliu.model.BodyFeature;
import com.viontech.keliu.model.Data;
import com.viontech.keliu.model.FaceFeature;
import com.viontech.keliu.model.Feature;
import com.viontech.keliu.model.Mall;
import com.viontech.keliu.model.MatchParam;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.model.Staff;
import com.viontech.keliu.model.StaffBody;
import com.viontech.keliu.model.StaffFace;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.websocket.AlgApiClient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import sun.misc.BASE64Encoder;

@Service
public class StaffMatchService
extends AbstractMatchService {
    private Logger logger = LoggerFactory.getLogger(StaffMatchService.class);
    @Autowired(required=false)
    private AlgApiClient algApiClientFeature;
    @Autowired
    private OrgCacheService orgCacheService;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired
    private StaffDao staffDao;
    @Autowired
    private StaffFaceDao staffFaceDao;
    @Autowired
    private StaffBodyDao staffBodyDao;
    @Autowired
    private Storage simpleStringStorage;
    BASE64Encoder base64Encoder = new /* Unavailable Anonymous Inner Class!! */;

    protected List<Person> getPersons(Long mallId, String type) {
        ArrayList<Person> persons = new ArrayList<Person>();
        List staffs = this.staffDao.selectBySerialnum(mallId);
        for (Staff staff : staffs) {
            Person person = new Person();
            persons.add(person);
            person.setPersonId(staff.getPersonUnid());
            List staffFaces = this.staffFaceDao.selectByStaffId(staff.getId());
            ArrayList<FaceFeature> faceFeatures = new ArrayList<FaceFeature>();
            person.setFaceFeatures(faceFeatures);
            for (StaffFace staffFace : staffFaces) {
                FaceFeature faceFeature = new FaceFeature();
                String facePic = staffFace.getFeature() != null ? staffFace.getFeature() : staffFace.getFacePic().replace("staff/face", "staff/feature") + ".feature";
                faceFeature.setPicName(facePic);
                faceFeature.setFid(facePic);
                faceFeatures.add(faceFeature);
            }
            List staffbodys = this.staffBodyDao.selectByStaffId(staff.getId());
            ArrayList<BodyFeature> bodyFeatures = new ArrayList<BodyFeature>();
            person.setBodyFeatures(bodyFeatures);
            for (StaffBody staffBody : staffbodys) {
                BodyFeature bodyFeature = new BodyFeature();
                String bodyPic = staffBody.getFeature() != null ? staffBody.getFeature() : staffBody.getBodyPic().replace("staff/body", "staff/feature") + ".feature";
                bodyFeature.setPicName(bodyPic);
                bodyFeature.setBid(bodyPic);
                bodyFeatures.add(bodyFeature);
            }
        }
        return persons;
    }

    protected Map<String, String> buildPoolName(MatchParam matchParam) {
        HashMap<String, String> poolNameMap = new HashMap<String, String>();
        Long mallId = matchParam.getMallId();
        Map mallMap = this.orgCacheService.getMallMap();
        Mall mall = (Mall)mallMap.get(String.valueOf(mallId));
        String poolName = this.applicationName + "_staffPool_";
        poolName = mall != null ? poolName + mall.getUnid() : poolName + mallId;
        poolNameMap.put(poolName, null);
        return poolNameMap;
    }

    protected String readFeature(String file) {
        Object jsonObj = this.simpleStringStorage.getItem(file);
        if ((jsonObj == null || !"server".contains(jsonObj.toString())) && file.contains("face-0.jpg")) {
            file = file.replace("face-0.jpg", "face-F.jpg");
            jsonObj = this.simpleStringStorage.getItem(file);
        }
        return (String)jsonObj;
    }

    protected String reExractFaceFeature(String file) {
        return this.reExractFeature(file, "face");
    }

    private String reExractFeature(String file, String type) {
        if (file == null) {
            return null;
        }
        Feature feature = null;
        try {
            String featureStr = new String(this.simpleStringStorage.getByteArrayItem(file));
            feature = (Feature)this.objectMapper.readValue(featureStr, Feature.class);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u53d6\u7279\u5f81\u5931\u8d25", (Throwable)e);
            return null;
        }
        String pic = file.replace("staff/feature", "staff/" + type).replace(".feature", "");
        this.logger.info("{}\u7279\u5f81\u4e0d\u5b58\u5728\u5f00\u59cb\u91cd\u63d0", (Object)pic);
        byte[] picBytes = this.simpleStringStorage.getByteArrayItem(pic);
        if (picBytes == null) {
            this.logger.warn("{},\u56fe\u7247\u8bfb\u53d6\u4e0d\u5230", (Object)pic);
            return null;
        }
        String imageBase64 = this.base64Encoder.encode(picBytes);
        if ("body".equals(type) && (feature.getBody_roi() == null || feature.getBody_roi().isEmpty())) {
            this.logger.warn("\u4eba\u4f53\u56fe\u7247\u7279\u5f81\u6587\u4ef6{}\u4e2d\u627e\u4e0d\u5230\u7279\u5f81ROI", (Object)file);
            return null;
        }
        try {
            CompletableFuture responseFuture;
            JSONObject response;
            HashMap options = new HashMap();
            if ("body".equals(type) && feature.getBody_roi() != null && !feature.getBody_roi().isEmpty()) {
                options.put("body_roi", feature.getBody_roi().get(0));
            }
            if ((response = (JSONObject)(responseFuture = this.algApiClientFeature.getFeatureAndAttr(imageBase64, type, "jpg", feature.getKey_point(), options)).get(120L, TimeUnit.SECONDS)).keySet().contains(type + "Feature")) {
                JSONObject bodyFeature = response.getJSONObject("faceFeature");
                ArrayList<Data> datas = feature.getDatas();
                if (datas == null) {
                    datas = new ArrayList<Data>();
                    feature.setDatas(datas);
                }
                Data data = new Data();
                data.setType("server");
                data.setData(bodyFeature.getJSONArray("feature").toList().toArray(new Double[0]));
                datas.add(data);
                String featureStr = this.objectMapper.writeValueAsString((Object)feature);
                this.simpleStringStorage.setItem(file, (Object)featureStr);
                return featureStr;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(pic + "\u7279\u5f81\u91cd\u63d0\u5931\u8d25", (Throwable)e);
        }
        return null;
    }

    protected String reExractBodyFeature(String file) {
        return this.reExractFeature(file, "body");
    }
}

