/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.springframework.stereotype.Service;

@Service
public class RedissonService {
    @Resource
    private RedissonClient redissonClient;

    public void lockAndRun(String lockName, Long leaseTime, Runnable runnable) {
        this.lockAndRun(lockName, leaseTime, TimeUnit.SECONDS, runnable);
    }

    public void lockAndRun(String lockName, Long tryTime, Long leaseTime, Runnable runnable) {
        this.lockAndRun(lockName, tryTime, leaseTime, TimeUnit.SECONDS, runnable);
    }

    public void lockAndRun(String lockName, Long leaseTime, TimeUnit timeUnit, Runnable runnable) {
        this.lockAndRun(lockName, null, leaseTime, timeUnit, runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockAndRun(String lockName, Long tryTime, Long leaseTime, TimeUnit timeUnit, Runnable runnable) {
        RLock lock = this.redissonClient.getLock(lockName);
        try {
            boolean isLock = true;
            if (tryTime != null) {
                isLock = lock.tryLock(tryTime.longValue(), leaseTime.longValue(), timeUnit);
            } else {
                lock.lock(leaseTime.longValue(), timeUnit);
            }
            if (isLock) {
                runnable.run();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            lock.unlock();
        }
    }
}

