/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.dao.ChannelDao;
import com.viontech.keliu.dao.DataDicDao;
import com.viontech.keliu.dao.FloorDao;
import com.viontech.keliu.dao.FloorGateDao;
import com.viontech.keliu.dao.GateDao;
import com.viontech.keliu.dao.MallDao;
import com.viontech.keliu.dao.ZoneDao;
import com.viontech.keliu.dao.ZoneGateDao;
import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.DataDic;
import com.viontech.keliu.model.Floor;
import com.viontech.keliu.model.FloorGate;
import com.viontech.keliu.model.Gate;
import com.viontech.keliu.model.Mall;
import com.viontech.keliu.model.Zone;
import com.viontech.keliu.model.ZoneGate;
import com.viontech.keliu.redis.RedisUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OrgCacheService {
    @Autowired
    private GateDao gateDao;
    @Autowired
    private ChannelDao channelDao;
    @Autowired
    private ZoneGateDao zoneGateDao;
    @Autowired
    private FloorGateDao floorGateDao;
    @Autowired
    private ZoneDao zoneDao;
    @Autowired
    private MallDao mallDao;
    @Autowired
    private FloorDao floorDao;
    @Autowired
    private DataDicDao dataDicDao;
    private static final HashMap<String, Map> ORG_CACHE_MAP = new HashMap(8);
    private static final HashMap<String, Long> CREATE_TIME_MAP = new HashMap(8);
    private final Object channel_lock = new Object();
    private final Object zone_lock = new Object();
    private final Object gate_lock = new Object();
    private final Object floor_lock = new Object();
    private final Object mall_lock = new Object();
    private final Object gate_mall_lock = new Object();
    private final Object gate_zone_lock = new Object();
    private final Object gate_floor_lock = new Object();
    private final Object data_dic_lock = new Object();
    private long defaultExpireTime = 600L;
    private Logger logger = LoggerFactory.getLogger(OrgCacheService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getChannelMap() {
        HashMap result;
        Long createTime = (Long)CREATE_TIME_MAP.get("channelMap");
        if (createTime == null || this.isExpire(createTime)) {
            Object object = this.channel_lock;
            synchronized (object) {
                createTime = (Long)CREATE_TIME_MAP.get("channelMap");
                if (createTime == null || this.isExpire(createTime)) {
                    HashMap<String, Channel> result2 = RedisUtil.getMap((String)"channelMap");
                    if (result2 == null || result2.isEmpty()) {
                        List channels = this.channelDao.selectAll();
                        result2 = new HashMap<String, Channel>();
                        for (Channel channel : channels) {
                            result2.put(String.valueOf(channel.getSerialnum()), channel);
                        }
                        RedisUtil.addMap((String)"channelMap", result2);
                        RedisUtil.setExpireTime((String)"channelMap", (Long)this.defaultExpireTime);
                    } else if (RedisUtil.getExpireTime((String)"channelMap") == -1L) {
                        RedisUtil.setExpireTime((String)"channelMap", (Long)this.defaultExpireTime);
                    }
                    ORG_CACHE_MAP.put("channelMap", result2);
                    CREATE_TIME_MAP.put("channelMap", System.currentTimeMillis());
                }
            }
        }
        if ((result = (HashMap)ORG_CACHE_MAP.get("channelMap")) == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Zone> getZoneMap() {
        HashMap result;
        Long createTime = (Long)CREATE_TIME_MAP.get("zoneMap");
        if (createTime == null || this.isExpire(createTime)) {
            Object object = this.zone_lock;
            synchronized (object) {
                createTime = (Long)CREATE_TIME_MAP.get("zoneMap");
                if (createTime == null || this.isExpire(createTime)) {
                    HashMap<String, Zone> result2 = RedisUtil.getMap((String)"zoneMap");
                    if (result2 == null || result2.isEmpty()) {
                        this.logger.info("");
                        List zones = this.zoneDao.selectAll();
                        result2 = new HashMap<String, Zone>();
                        for (Zone zone : zones) {
                            result2.put(String.valueOf(zone.getId()), zone);
                        }
                        RedisUtil.addMap((String)"zoneMap", result2);
                        RedisUtil.setExpireTime((String)"zoneMap", (Long)this.defaultExpireTime);
                    } else if (RedisUtil.getExpireTime((String)"zoneMap") == -1L) {
                        this.logger.debug("\u6570\u636e\u7684\u8fc7\u671f\u65f6\u95f4\u4e3a{},\u91cd\u65b0\u8bbe\u7f6e\u8fc7\u671f\u65f6\u95f4", (Object)RedisUtil.getExpireTime((String)"zoneMap"));
                        RedisUtil.setExpireTime((String)"zoneMap", (Long)this.defaultExpireTime);
                    }
                    ORG_CACHE_MAP.put("zoneMap", result2);
                    CREATE_TIME_MAP.put("zoneMap", System.currentTimeMillis());
                }
            }
        }
        if ((result = (HashMap)ORG_CACHE_MAP.get("zoneMap")) == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Gate> getGateMap() {
        HashMap result;
        this.logger.debug("\u5f00\u59cb\u83b7\u53d6gateMap");
        Long createTime = (Long)CREATE_TIME_MAP.get("gateMap");
        if (createTime == null || this.isExpire(createTime)) {
            Object object = this.gate_lock;
            synchronized (object) {
                createTime = (Long)CREATE_TIME_MAP.get("gateMap");
                if (createTime == null || this.isExpire(createTime)) {
                    HashMap<String, Gate> result2 = RedisUtil.getMap((String)"gateMap");
                    if (result2 == null || result2.isEmpty()) {
                        List gates = this.gateDao.selectAll();
                        result2 = new HashMap<String, Gate>();
                        for (Gate gate : gates) {
                            result2.put(String.valueOf(gate.getId()), gate);
                        }
                        RedisUtil.addMap((String)"gateMap", result2);
                        RedisUtil.setExpireTime((String)"gateMap", (Long)this.defaultExpireTime);
                    } else if (RedisUtil.getExpireTime((String)"gateMap") == -1L) {
                        RedisUtil.setExpireTime((String)"gateMap", (Long)this.defaultExpireTime);
                    }
                    ORG_CACHE_MAP.put("gateMap", result2);
                    CREATE_TIME_MAP.put("gateMap", System.currentTimeMillis());
                }
            }
        }
        if ((result = (HashMap)ORG_CACHE_MAP.get("gateMap")) == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Floor> getFloorMap() {
        HashMap result;
        this.logger.debug("\u5f00\u59cb\u83b7\u53d6floorMap");
        Long createTime = (Long)CREATE_TIME_MAP.get("floorMap");
        if (createTime == null || this.isExpire(createTime)) {
            Object object = this.floor_lock;
            synchronized (object) {
                createTime = (Long)CREATE_TIME_MAP.get("floorMap");
                if (createTime == null || this.isExpire(createTime)) {
                    HashMap<String, Floor> result2 = RedisUtil.getMap((String)"floorMap");
                    if (result2 == null || result2.isEmpty()) {
                        this.logger.info("");
                        List floors = this.floorDao.selectAll();
                        result2 = new HashMap<String, Floor>();
                        for (Floor floor : floors) {
                            result2.put(String.valueOf(floor.getId()), floor);
                        }
                        RedisUtil.addMap((String)"floorMap", result2);
                        RedisUtil.setExpireTime((String)"floorMap", (Long)this.defaultExpireTime);
                    } else if (RedisUtil.getExpireTime((String)"floorMap") == -1L) {
                        RedisUtil.setExpireTime((String)"floorMap", (Long)this.defaultExpireTime);
                    }
                    ORG_CACHE_MAP.put("floorMap", result2);
                    CREATE_TIME_MAP.put("floorMap", System.currentTimeMillis());
                }
            }
        }
        if ((result = (HashMap)ORG_CACHE_MAP.get("floorMap")) == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getGate2MallMap() {
        HashMap result;
        this.logger.debug("\u5f00\u59cb\u83b7\u53d6gate2mallMap");
        Long createTime = (Long)CREATE_TIME_MAP.get("gate2MallMap");
        if (createTime == null || this.isExpire(createTime)) {
            Object object = this.gate_mall_lock;
            synchronized (object) {
                createTime = (Long)CREATE_TIME_MAP.get("gate2MallMap");
                if (createTime == null || this.isExpire(createTime)) {
                    HashMap<String, Long> result2 = RedisUtil.getMap((String)"gate2MallMap");
                    if (result2 == null || result2.isEmpty()) {
                        this.logger.info("");
                        List gates = this.gateDao.selectAll();
                        result2 = new HashMap<String, Long>();
                        for (Gate gate : gates) {
                            if (!gate.isMallGate()) continue;
                            result2.put(String.valueOf(gate.getId()), gate.getMallId());
                        }
                        RedisUtil.addMap((String)"gate2MallMap", result2);
                        RedisUtil.setExpireTime((String)"gate2MallMap", (Long)this.defaultExpireTime);
                    } else if (RedisUtil.getExpireTime((String)"gate2MallMap") == -1L) {
                        RedisUtil.setExpireTime((String)"gate2MallMap", (Long)this.defaultExpireTime);
                    }
                    ORG_CACHE_MAP.put("gate2MallMap", result2);
                    CREATE_TIME_MAP.put("gate2MallMap", System.currentTimeMillis());
                }
            }
        }
        if ((result = (HashMap)ORG_CACHE_MAP.get("gate2MallMap")) == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getGate2ZoneMap() {
        HashMap result;
        this.logger.debug("\u5f00\u59cb\u83b7\u53d6gate2zoneMap");
        Long createTime = (Long)CREATE_TIME_MAP.get("gate2ZoneMap");
        if (createTime == null || this.isExpire(createTime)) {
            Object object = this.gate_zone_lock;
            synchronized (object) {
                createTime = (Long)CREATE_TIME_MAP.get("gate2ZoneMap");
                if (createTime == null || this.isExpire(createTime)) {
                    HashMap<String, ArrayList<ZoneGate>> result2 = RedisUtil.getMap((String)"gate2ZoneMap");
                    if (result2 == null || result2.isEmpty()) {
                        result2 = new HashMap<String, ArrayList<ZoneGate>>();
                        this.logger.info("\u4ece\u6570\u636e\u5e93\u4e2d\u52a0\u8f7dGate2Zone\u6570\u636e");
                        List zoneGates = this.zoneGateDao.selectAll();
                        for (ZoneGate zoneGate : zoneGates) {
                            long gateId = zoneGate.getGateId();
                            ArrayList<ZoneGate> gate2Zones = (ArrayList<ZoneGate>)result2.get(String.valueOf(gateId));
                            if (gate2Zones == null) {
                                gate2Zones = new ArrayList<ZoneGate>();
                                result2.put(String.valueOf(gateId), gate2Zones);
                            }
                            gate2Zones.add(zoneGate);
                        }
                        RedisUtil.addMap((String)"gate2ZoneMap", result2);
                        RedisUtil.setExpireTime((String)"gate2ZoneMap", (Long)this.defaultExpireTime);
                    } else if (RedisUtil.getExpireTime((String)"gate2ZoneMap") == -1L) {
                        RedisUtil.setExpireTime((String)"gate2ZoneMap", (Long)this.defaultExpireTime);
                    }
                    ORG_CACHE_MAP.put("gate2ZoneMap", result2);
                    CREATE_TIME_MAP.put("gate2ZoneMap", System.currentTimeMillis());
                }
            }
        }
        if ((result = (HashMap)ORG_CACHE_MAP.get("gate2ZoneMap")) == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getGate2FloorMap() {
        HashMap result;
        this.logger.debug("\u5f00\u59cb\u83b7\u53d6gate2floorMap");
        Long createTime = (Long)CREATE_TIME_MAP.get("gate2FloorMap");
        if (createTime == null || this.isExpire(createTime)) {
            Object object = this.gate_floor_lock;
            synchronized (object) {
                createTime = (Long)CREATE_TIME_MAP.get("gate2FloorMap");
                if (createTime == null || this.isExpire(createTime)) {
                    HashMap<String, ArrayList<FloorGate>> result2 = RedisUtil.getMap((String)"gate2FloorMap");
                    if (result2 == null || result2.isEmpty()) {
                        this.logger.info("\u4ece\u6570\u636e\u5e93\u4e2d\u52a0\u8f7dGate2Floor\u6570\u636e");
                        List floorGates = this.floorGateDao.selectAll();
                        result2 = new HashMap<String, ArrayList<FloorGate>>();
                        for (FloorGate floorGate : floorGates) {
                            long gateId = floorGate.getGateId();
                            ArrayList<FloorGate> floors = (ArrayList<FloorGate>)result2.get(String.valueOf(gateId));
                            if (floors == null) {
                                floors = new ArrayList<FloorGate>();
                                result2.put(String.valueOf(gateId), floors);
                            }
                            floors.add(floorGate);
                        }
                        RedisUtil.addMap((String)"gate2FloorMap", result2);
                        RedisUtil.setExpireTime((String)"gate2FloorMap", (Long)this.defaultExpireTime);
                    } else if (RedisUtil.getExpireTime((String)"gate2FloorMap") == -1L) {
                        boolean bl = RedisUtil.setExpireTime((String)"gate2FloorMap", (Long)this.defaultExpireTime);
                    }
                    ORG_CACHE_MAP.put("gate2FloorMap", result2);
                    CREATE_TIME_MAP.put("gate2FloorMap", System.currentTimeMillis());
                }
            }
        }
        if ((result = (HashMap)ORG_CACHE_MAP.get("gate2FloorMap")) == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMallMap() {
        HashMap result;
        this.logger.debug("\u5f00\u59cb\u83b7\u53d6 mall map");
        Long createTime = (Long)CREATE_TIME_MAP.get("mallMap");
        if (createTime == null || this.isExpire(createTime)) {
            Object object = this.mall_lock;
            synchronized (object) {
                createTime = (Long)CREATE_TIME_MAP.get("mallMap");
                if (createTime == null || this.isExpire(createTime)) {
                    Map<String, Mall> result2 = RedisUtil.getMap((String)"mallMap");
                    if (result2 == null || result2.isEmpty()) {
                        this.logger.info("\u4ece\u6570\u636e\u5e93\u4e2d\u52a0\u8f7dMall\u6570\u636e");
                        List malls = this.mallDao.selectAll();
                        result2 = malls.stream().collect(Collectors.toMap(mall -> String.valueOf(mall.getId()), mall -> mall));
                        RedisUtil.addMap((String)"mallMap", result2);
                        RedisUtil.setExpireTime((String)"mallMap", (Long)this.defaultExpireTime);
                    } else if (RedisUtil.getExpireTime((String)"mallMap") == -1L) {
                        RedisUtil.setExpireTime((String)"mallMap", (Long)this.defaultExpireTime);
                    }
                    ORG_CACHE_MAP.put("mallMap", result2);
                    CREATE_TIME_MAP.put("mallMap", System.currentTimeMillis());
                }
            }
        }
        if ((result = (HashMap)ORG_CACHE_MAP.get("mallMap")) == null) {
            result = new HashMap();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDataDicMap() {
        HashMap result;
        this.logger.debug("\u5f00\u59cb\u83b7\u53d6 dataDic map");
        Long createTime = (Long)CREATE_TIME_MAP.get("dataDicMap");
        if (createTime == null || this.isExpire(createTime)) {
            Object object = this.data_dic_lock;
            synchronized (object) {
                createTime = (Long)CREATE_TIME_MAP.get("dataDicMap");
                if (createTime == null || this.isExpire(createTime)) {
                    Map<String, DataDic> result2 = RedisUtil.getMap((String)"dataDicMap");
                    if (result2 == null || result2.isEmpty()) {
                        this.logger.info("\u4ece\u6570\u636e\u5e93\u4e2d\u52a0\u8f7ddataDic\u6570\u636e");
                        List dataDics = this.dataDicDao.selectAll();
                        result2 = dataDics.stream().collect(Collectors.toMap(dataDic -> {
                            this.logger.info(dataDic.toString());
                            return String.valueOf(dataDic.getId());
                        }, dataDic -> dataDic));
                        RedisUtil.addMap((String)"dataDicMap", result2);
                        RedisUtil.setExpireTime((String)"dataDicMap", (Long)this.defaultExpireTime);
                    } else if (RedisUtil.getExpireTime((String)"dataDicMap") == -1L) {
                        RedisUtil.setExpireTime((String)"dataDicMap", (Long)this.defaultExpireTime);
                    }
                    ORG_CACHE_MAP.put("dataDicMap", result2);
                    CREATE_TIME_MAP.put("dataDicMap", System.currentTimeMillis());
                }
            }
        }
        if ((result = (HashMap)ORG_CACHE_MAP.get("dataDicMap")) == null) {
            result = new HashMap();
        }
        return result;
    }

    private boolean isExpire(Long cacheTime) {
        return System.currentTimeMillis() - cacheTime > TimeUnit.SECONDS.toMillis(this.defaultExpireTime);
    }
}

