/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.util.DateUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class FaceRecognitionRawService {
    private Logger logger = LoggerFactory.getLogger(FaceRecognitionRawService.class);
    private static final Object faceDataRawKeySync = new Object();
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRepeat(FaceDataContent item) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date counttime = item.getCountDate();
        StringBuilder sb = new StringBuilder();
        sb.append(item.getChannelSerialnum());
        sb.append(":");
        sb.append(sdf.format(counttime));
        sb.append(":");
        sb.append(item.getPersonId());
        String faceItemKey = sb.toString();
        String datestr = DateUtil.format((String)"yyyyMMdd", (Date)item.getCountDate());
        String faceRecognitionRawKey = "faceRecognitionRawKey:" + datestr;
        boolean isKeyExist = false;
        try {
            isKeyExist = this.redisTemplate.expire((Object)faceRecognitionRawKey, 2L, TimeUnit.HOURS);
        }
        catch (Exception e) {
            this.logger.error("gateMinute\u53bb\u91cd redisTemplate: " + this.redisTemplate);
            this.logger.error("gateMinute\u53bb\u91cd key: " + faceRecognitionRawKey);
            this.logger.error("gateMinute\u53bb\u91cd\u9519\u8bef: ", (Throwable)e);
            throw e;
        }
        if (!isKeyExist) {
            Object object = faceDataRawKeySync;
            synchronized (object) {
                if (!this.redisTemplate.hasKey((Object)faceRecognitionRawKey).booleanValue()) {
                    List faceDataContentList = this.jdbcTemplate.query("select channel_serialnum as channelSerialnum,counttime as countDate,person_unid as personId From d_face_recognition_raw where countdate = ?", new Object[]{item.getCountDate()}, (RowMapper)new BeanPropertyRowMapper(FaceDataContent.class));
                    if (faceDataContentList.isEmpty()) {
                        this.redisTemplate.boundSetOps((Object)faceRecognitionRawKey).add(new Object[]{faceItemKey});
                        return false;
                    }
                    ArrayList<String> list = new ArrayList<String>();
                    for (FaceDataContent faceDataContent : faceDataContentList) {
                        if (faceDataContent.getChannelSerialnum() == null && faceDataContent.getCountDate() == null) continue;
                        list.add(faceDataContent.getChannelSerialnum() + ":" + sdf.format(faceDataContent.getCountDate()) + ":" + faceDataContent.getPersonId());
                    }
                    this.redisTemplate.execute((SessionCallback)new /* Unavailable Anonymous Inner Class!! */);
                    this.redisTemplate.expire((Object)faceRecognitionRawKey, 2L, TimeUnit.HOURS);
                }
            }
        }
        return this.redisTemplate.boundSetOps((Object)faceRecognitionRawKey).add(new Object[]{faceItemKey}) <= 0L;
    }
}

