/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.dao.FaceDataStaKeyDao;
import com.viontech.keliu.model.FaceStaData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class FaceDataStaKeyService {
    @Resource
    private FaceDataStaKeyDao keyDao;
    @Resource
    private RedisTemplate<String, String> redisTemplate;

    public void addGateDay(Date date, String key) {
        List gateDay = this.keyDao.getGateDay(date);
        this.dataHandler(key, date, gateDay, false);
    }

    public void addGateHour(Date date, String key) {
        List gateHour = this.keyDao.getGateHour(date);
        this.dataHandler(key, date, gateHour, true);
    }

    public void addMallDay(Date date, String key) {
        List mallDay = this.keyDao.getMallDay(date);
        this.dataHandler(key, date, mallDay, false);
    }

    public void addMallHour(Date date, String key) {
        List mallDay = this.keyDao.getMallHour(date);
        this.dataHandler(key, date, mallDay, true);
    }

    public void addZoneDay(Date date, String key) {
        List mallDay = this.keyDao.getZoneDay(date);
        this.dataHandler(key, date, mallDay, false);
    }

    public void addZoneHour(Date date, String key) {
        List mallDay = this.keyDao.getZoneHour(date);
        this.dataHandler(key, date, mallDay, true);
    }

    public void addFloorDay(Date date, String key) {
        List mallDay = this.keyDao.getFloorDay(date);
        this.dataHandler(key, date, mallDay, false);
    }

    public void addFloorHour(Date date, String key) {
        List mallDay = this.keyDao.getFloorHour(date);
        this.dataHandler(key, date, mallDay, true);
    }

    private void dataHandler(String key, Date date, List<FaceStaData> data, boolean isHour) {
        ArrayList<String> values = new ArrayList<String>();
        if (data != null && data.size() > 0) {
            SimpleDateFormat sdf = isHour ? new SimpleDateFormat("yyyyMMddHH") : new SimpleDateFormat("yyyyMMdd");
            data.forEach(item -> {
                String value = String.valueOf(item.getOrgId()) + ":" + sdf.format(isHour ? item.getCountTime() : item.getCountDate());
                values.add(value);
            });
        }
        if (values.isEmpty()) {
            values.add("placeholder");
        }
        BoundSetOperations boundSetOperations = this.redisTemplate.boundSetOps((Object)key);
        boundSetOperations.add((Object[])values.toArray(new String[0]));
        if (isHour) {
            boundSetOperations.expire(2L, TimeUnit.HOURS);
        } else if (System.currentTimeMillis() - date.getTime() > TimeUnit.DAYS.toMillis(3L)) {
            boundSetOperations.expire(2L, TimeUnit.HOURS);
        } else {
            boundSetOperations.expire(2L, TimeUnit.DAYS);
        }
    }
}

