/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.dao.DbPersonDao;
import com.viontech.keliu.dao.DbPersonPicDao;
import com.viontech.keliu.match.AbstractMatchService;
import com.viontech.keliu.model.DataDic;
import com.viontech.keliu.model.DbPerson;
import com.viontech.keliu.model.DbPersonPic;
import com.viontech.keliu.model.FaceFeature;
import com.viontech.keliu.model.Mall;
import com.viontech.keliu.model.MatchParam;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.storage.Storage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DbPersonMatchService
extends AbstractMatchService {
    private Logger logger = LoggerFactory.getLogger(DbPersonMatchService.class);
    @Autowired
    private DbPersonDao dbPersonDao;
    @Autowired
    private DbPersonPicDao dbPersonPicDao;
    @Autowired
    private OrgCacheService orgCacheService;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired
    private Storage simpleStringStorage;

    protected List<Person> getPersons(Long mallId, String type) {
        if (mallId == null || type == null) {
            this.logger.warn("\u53c2\u6570\u7f3a\u5931\u7981\u6b62\u67e5\u8be2\uff01");
            return Collections.emptyList();
        }
        Long typeNew = -1L;
        try {
            typeNew = Long.valueOf(type);
        }
        catch (NumberFormatException e) {
            this.logger.warn("type\u7c7b\u578b\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            return Collections.emptyList();
        }
        List dbPeoples = this.dbPersonDao.selectByMallIdAndType(mallId, typeNew);
        if (dbPeoples == null || dbPeoples.size() <= 0) {
            this.logger.info("\u67e5\u8be2\u4e0d\u5230{} {} \u7684\u4eba\u5458\u5e93\u6570\u636e", (Object)mallId, (Object)type);
            return Collections.emptyList();
        }
        ArrayList<Person> persons = new ArrayList<Person>();
        for (DbPerson dbPeople : dbPeoples) {
            List dbPersonPics = this.dbPersonPicDao.selectByPersonId(dbPeople.getId());
            for (DbPersonPic dbPersonPic : dbPersonPics) {
                dbPersonPic.setPerson_unid(dbPeople.getPersonUnid());
                Person person = this.buildPerson(dbPersonPic);
                persons.add(person);
            }
        }
        return persons;
    }

    public Person buildPerson(DbPersonPic dbPersonPic) {
        Person person = new Person();
        person.setPersonId(dbPersonPic.getRecognitionPersonUnid());
        String facePic = dbPersonPic.getPic();
        if (dbPersonPic.getFeatureType() != null && dbPersonPic.getFeatureType().intValue() == 1) {
            facePic = facePic.replace("face-0.jpg", "face-F.jpg");
        }
        facePic = facePic.replace("picture", "feature");
        facePic = facePic + ".feature";
        ArrayList<FaceFeature> faceFeatures = new ArrayList<FaceFeature>();
        FaceFeature faceFeature = new FaceFeature();
        faceFeature.setFid("d_person_pic-id:" + dbPersonPic.getId());
        faceFeature.setPicName(facePic);
        faceFeatures.add(faceFeature);
        person.setFaceFeatures(faceFeatures);
        person.setPersonId(dbPersonPic.getPerson_unid());
        return person;
    }

    protected Map<String, String> buildPoolName(MatchParam matchParam) {
        HashMap<String, String> poolNameMap = new HashMap<String, String>();
        Long mallId = matchParam.getMallId();
        Map dataDicMap = this.orgCacheService.getDataDicMap();
        Map mallMap = this.orgCacheService.getMallMap();
        Mall mall = (Mall)mallMap.get(String.valueOf(mallId));
        Iterator iterator = dataDicMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Short key;
            DataDic dataDic = (DataDic)iterator.next().getValue();
            if (!"personType".contains(dataDic.getType()) || (key = dataDic.getKey()) == 0 || key == 1) continue;
            String poolName = this.applicationName + "_personPool_" + key + "_";
            poolName = mall != null ? poolName + mall.getUnid() : poolName + mallId;
            poolNameMap.put(poolName, String.valueOf(key));
        }
        return poolNameMap;
    }

    protected String readFeature(String file) {
        return (String)this.simpleStringStorage.getItem(file);
    }
}

