/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.dao.FaceRecognitionDao;
import com.viontech.keliu.match.AbstractMatchService;
import com.viontech.keliu.model.FaceFeature;
import com.viontech.keliu.model.FaceRecognition;
import com.viontech.keliu.model.Mall;
import com.viontech.keliu.model.MatchParam;
import com.viontech.keliu.model.Person;
import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.storage.Storage;
import com.viontech.keliu.util.DateUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomMatchService
extends AbstractMatchService {
    private Logger logger = LoggerFactory.getLogger(CustomMatchService.class);
    @Autowired
    private FaceRecognitionDao faceRecognitionDao;
    @Autowired
    private OrgCacheService orgCacheService;
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired
    private Storage featureStorage;
    @Value(value="${match.score.camera:1.5}")
    private Float matchScoreCamera;

    protected List<Person> getPersons(Long mallId, String type) {
        Date countDate = null;
        try {
            countDate = DateUtil.parse((String)DateUtil.FORMAT_SHORT, (String)type);
        }
        catch (ParseException e) {
            this.logger.error("\u83b7\u53d6Persons\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        List faceRecognitions = this.faceRecognitionDao.selectByParameter(mallId, countDate, Integer.valueOf(0));
        if (faceRecognitions == null || faceRecognitions.size() <= 0) {
            this.logger.info("\u67e5\u8be2\u4e0d\u5230{} {} \u7684\u4eba\u8138\u6293\u62cd\u6570\u636e", (Object)mallId, (Object)countDate);
            return Collections.emptyList();
        }
        HashSet<String> personUnidSet = new HashSet<String>();
        ArrayList<Person> persons = new ArrayList<Person>();
        for (FaceRecognition faceRecognition : faceRecognitions) {
            Float faceScore = faceRecognition.getFaceScore();
            if (!personUnidSet.add(faceRecognition.getPersonUnid()) && faceScore != null && !(faceScore.floatValue() >= this.matchScoreCamera.floatValue())) continue;
            Person person = this.buildPerson(faceRecognition);
            persons.add(person);
        }
        return persons;
    }

    public Person buildPerson(FaceRecognition faceRecognition) {
        Person person = new Person();
        person.setPersonId(faceRecognition.getPersonUnid());
        String facePic = faceRecognition.getFacePic();
        if (faceRecognition.getFaceFeatureType() != null && faceRecognition.getFaceFeatureType().intValue() == 1) {
            facePic = facePic.replace("face-0.jpg", "face-F.jpg");
        }
        ArrayList<FaceFeature> faceFeatures = new ArrayList<FaceFeature>();
        FaceFeature faceFeature = new FaceFeature();
        faceFeature.setFid(facePic);
        faceFeature.setPicName(faceRecognition.getChannelSerialnum() + "/" + facePic);
        faceFeatures.add(faceFeature);
        person.setFaceFeatures(faceFeatures);
        return person;
    }

    protected Map<String, String> buildPoolName(MatchParam matchParam) {
        HashMap<String, String> poolNameMap = new HashMap<String, String>();
        Long mallId = matchParam.getMallId();
        List dates = matchParam.getDates();
        Map mallMap = this.orgCacheService.getMallMap();
        Mall mall = (Mall)mallMap.get(String.valueOf(mallId));
        dates.forEach(date -> {
            String format = DateUtil.format((String)DateUtil.FORMAT_SHORT, (Date)date);
            String poolName = matchParam.isSubPool() ? this.applicationName + "_customPool_" + format + "_" : this.applicationName + "_customPool_";
            poolName = mall != null ? poolName + mall.getUnid() : poolName + mallId;
            poolNameMap.put(poolName, format);
        });
        return poolNameMap;
    }

    protected String readFeature(String file) {
        return (String)this.featureStorage.getItem(file);
    }
}

