/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.dao.CountDataKeyDao;
import com.viontech.keliu.model.CountData;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class CountDataKeyService {
    public final Logger logger = LoggerFactory.getLogger(CountDataKeyService.class);
    @Resource
    private CountDataKeyDao countDataKeyDao;
    @Resource
    private RedisTemplate<String, String> redisTemplate;

    public void addGateDay(Date date, String key) {
        List gateDay = this.countDataKeyDao.getGateDay(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u76d1\u63a7\u70b9> <\u5929\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, gateDay);
    }

    public void addGateHour(Date date, String key) {
        List gateHour = this.countDataKeyDao.getGateHour(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u76d1\u63a7\u70b9> <\u5c0f\u65f6\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, gateHour);
    }

    public void addGateMinute(Date date, String key) {
        List gateMinute = this.countDataKeyDao.getGateMinute(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u76d1\u63a7\u70b9> <\u5206\u949f\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, gateMinute);
    }

    public void addMallDay(Date date, String key) {
        List mallDay = this.countDataKeyDao.getMallDay(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u5546\u573a> <\u5929\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, mallDay);
    }

    public void addMallHour(Date date, String key) {
        List mallDay = this.countDataKeyDao.getMallHour(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u5546\u573a> <\u5c0f\u65f6\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, mallDay);
    }

    public void addMallMinute(Date date, String key) {
        List mallDay = this.countDataKeyDao.getMallMinute(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u5546\u573a> <\u5206\u949f\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, mallDay);
    }

    public void addZoneDay(Date date, String key) {
        List mallDay = this.countDataKeyDao.getZoneDay(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u533a\u57df> <\u5929\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, mallDay);
    }

    public void addZoneHour(Date date, String key) {
        List mallDay = this.countDataKeyDao.getZoneHour(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u533a\u57df> <\u5c0f\u65f6\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, mallDay);
    }

    public void addZoneMinute(Date date, String key) {
        List mallDay = this.countDataKeyDao.getZoneMinute(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u533a\u57df> <\u5206\u949f\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, mallDay);
    }

    public void addFloorDay(Date date, String key) {
        List mallDay = this.countDataKeyDao.getFloorDay(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u697c\u5c42> <\u5929\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, mallDay);
    }

    public void addFloorHour(Date date, String key) {
        List mallDay = this.countDataKeyDao.getFloorHour(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u697c\u5c42> <\u5c0f\u65f6\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, mallDay);
    }

    public void addFloorMinute(Date date, String key) {
        List mallDay = this.countDataKeyDao.getFloorMinute(date);
        this.logger.debug("\u5f00\u59cb\u52a0\u8f7d <\u697c\u5c42> <\u5206\u949f\u7ea7> CountDataKey\u7f13\u5b58 key:{}", (Object)key);
        this.dataHandler(key, date, mallDay);
    }

    private void dataHandler(String key, Date date, List<CountData> data) {
        ArrayList<String> values = new ArrayList<String>();
        if (data != null && data.size() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmm");
            data.forEach(item -> {
                String value = String.valueOf(item.getOrgId()) + ":" + sdf.format(item.getCountTime());
                values.add(value);
            });
        }
        if (values.isEmpty()) {
            values.add("placeholder");
        }
        BoundSetOperations boundSetOperations = this.redisTemplate.boundSetOps((Object)key);
        boundSetOperations.add((Object[])values.toArray(new String[0]));
        if (System.currentTimeMillis() - date.getTime() > TimeUnit.DAYS.toMillis(3L)) {
            boundSetOperations.expire(6L, TimeUnit.HOURS);
        } else {
            boundSetOperations.expire(2L, TimeUnit.DAYS);
        }
    }
}

