/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.model.Channel;
import com.viontech.keliu.model.FloorGate;
import com.viontech.keliu.model.Gate;
import com.viontech.keliu.model.Zone;
import com.viontech.keliu.model.ZoneGate;
import com.viontech.keliu.util.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Service;

@Service
public class CountData2RedisService {
    private final Logger logger = LoggerFactory.getLogger(CountData2RedisService.class);
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private JdbcTemplate jdbcTemplate;
    @Value(value="${vion.time-offset.mall-day:0}")
    private int mallDayTimeOffset;
    private static final Object GATE_MINUTE_SYNC = new Object();
    private static final Object GATE_HOUR_SYNC = new Object();
    private static final Object GATE_DAY_SYNC = new Object();
    private static final Object ZONE_MINUTE_SYNC = new Object();
    private static final Object ZONE_HOUR_SYNC = new Object();
    private static final Object ZONE_DAY_SYNC = new Object();
    private static final Object FLOOR_MINUTE_SYNC = new Object();
    private static final Object FLOOR_HOUR_SYNC = new Object();
    private static final Object FLOOR_DAY_SYNC = new Object();
    private static final Object MALL_MINUTE_SYNC = new Object();
    private static final Object MALL_HOUR_SYNC = new Object();
    private static final Object MALL_DAY_SYNC = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoneCountData2Redis(Map<String, Zone> zoneMap, Channel channel, List<ZoneGate> list, Date createTime, int inNum, int outNum) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateStr = sdf.format(createTime);
        String dayDateStr = sdf.format(DateUtil.addHours((Date)createTime, (int)this.mallDayTimeOffset));
        dayDateStr = dayDateStr.substring(0, 8);
        StringBuilder sb = new StringBuilder();
        sb.append("countData:minute:zone:");
        sb.append(dateStr.substring(0, 11));
        String minueKeyPrefix = sb.toString();
        sb.setLength(0);
        sb.append("countData:hour:zone:");
        sb.append(dateStr.substring(0, 10));
        String hourKeyPrefix = sb.toString();
        sb.setLength(0);
        sb.append("countData:day:zone:");
        sb.append(dayDateStr);
        String dayKeyPrefix = sb.toString();
        HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
        Date countDate = createTime;
        countDate = DateUtil.setMilliseconds((Date)countDate, (int)0);
        countDate = DateUtil.setSeconds((Date)countDate, (int)0);
        Date minuteCountDate = DateUtil.setMinutes((Date)countDate, (int)(DateUtil.getMinute((Date)countDate) / 10 * 10));
        Date hourCountDate = DateUtil.setMinutes((Date)countDate, (int)0);
        for (ZoneGate zoneGate : list) {
            Object object;
            map.clear();
            long zoneId = zoneGate.getZoneId();
            Zone zone = zoneMap.get(String.valueOf(zoneId));
            if (zone == null) continue;
            int type = zoneGate.getType();
            map.put("mallId", channel.getMallId());
            map.put("accountId", channel.getAccountId());
            map.put("zoneId", Long.valueOf(zoneId));
            map.put("floorId", Long.valueOf(zone.getFloorId()));
            sb.setLength(0);
            sb.append(minueKeyPrefix);
            sb.append(":");
            sb.append(zoneId);
            String key = sb.toString();
            BoundHashOperations boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            map.put("createTime", minuteCountDate);
            if (!this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES).booleanValue()) {
                object = ZONE_MINUTE_SYNC;
                synchronized (object) {
                    if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                        this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u533a\u57df> <\u5206\u949f\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                        this.loadZoneMinuteCountSta(channel.getMallId(), Long.valueOf(zoneId), minuteCountDate, boundHashOps);
                    }
                }
            }
            this.incrementValueWithBindType(inNum, outNum, type, boundHashOps);
            boundHashOps.putAll(map);
            this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES);
            sb.setLength(0);
            sb.append(hourKeyPrefix);
            sb.append(":");
            sb.append(zoneId);
            key = sb.toString();
            boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            map.put("createTime", hourCountDate);
            if (!this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES).booleanValue()) {
                object = ZONE_HOUR_SYNC;
                synchronized (object) {
                    if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                        this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u533a\u57df> <\u5c0f\u65f6\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                        this.loadZoneHourCountSta(channel.getMallId(), Long.valueOf(zoneId), hourCountDate, boundHashOps);
                    }
                }
            }
            this.incrementValueWithBindType(inNum, outNum, type, boundHashOps);
            boundHashOps.putAll(map);
            this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES);
            Date dayCountDate = DateUtil.parse((String)"yyyyMMdd", (String)dayDateStr);
            map.put("createTime", dayCountDate);
            sb.setLength(0);
            sb.append(dayKeyPrefix);
            sb.append(":");
            sb.append(zoneId);
            key = sb.toString();
            boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            if (!this.redisTemplate.expire((Object)key, 2L, TimeUnit.DAYS).booleanValue()) {
                Object object2 = ZONE_DAY_SYNC;
                synchronized (object2) {
                    if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                        this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u533a\u57df> <\u5929\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                        this.loadZoneDayCountSta(channel.getMallId(), Long.valueOf(zoneId), dayCountDate, boundHashOps);
                    }
                }
            }
            this.incrementValueWithBindType(inNum, outNum, type, boundHashOps);
            boundHashOps.putAll(map);
            this.redisTemplate.expire((Object)key, 2L, TimeUnit.DAYS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gateCountData2Redis(Channel channel, Long gateId, Date createTime, int inNum, int outNum) throws ParseException {
        Object object;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        Date countDate = createTime;
        String dateStr = sdf.format(createTime);
        String dayDateStr = sdf.format(DateUtil.addHours((Date)createTime, (int)this.mallDayTimeOffset));
        dayDateStr = dayDateStr.substring(0, 8);
        countDate = DateUtil.setMilliseconds((Date)countDate, (int)0);
        countDate = DateUtil.setSeconds((Date)countDate, (int)0);
        Date hourCountDate = DateUtil.setMinutes((Date)countDate, (int)0);
        StringBuilder sb = new StringBuilder();
        sb.append("countData:minute:gate:");
        sb.append(dateStr.substring(0, 11));
        String minueKeyPrefix = sb.toString();
        sb.setLength(0);
        sb.append("countData:hour:gate:");
        sb.append(dateStr.substring(0, 10));
        String hourKeyPrefix = sb.toString();
        sb.setLength(0);
        sb.append("countData:day:gate:");
        sb.append(dayDateStr);
        String dayKeyPrefix = sb.toString();
        HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
        map.put("gateId", gateId);
        map.put("mallId", channel.getMallId());
        map.put("accountId", channel.getAccountId());
        Date minuteCountDate = DateUtil.setMinutes((Date)countDate, (int)(DateUtil.getMinute((Date)countDate) / 10 * 10));
        map.put("createTime", minuteCountDate);
        sb.setLength(0);
        sb.append(minueKeyPrefix);
        sb.append(":");
        sb.append(gateId.intValue());
        String key = sb.toString();
        BoundHashOperations boundHashOps = this.redisTemplate.boundHashOps((Object)key);
        if (!this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES).booleanValue()) {
            object = GATE_MINUTE_SYNC;
            synchronized (object) {
                if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                    this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u76d1\u63a7\u70b9> <\u5206\u949f\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                    this.loadGateMinuteCountSta(channel.getMallId(), gateId, minuteCountDate, boundHashOps);
                }
            }
        }
        this.incrementValueWithGateType(inNum, outNum, 1, boundHashOps);
        boundHashOps.putAll(map);
        this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES);
        sb.setLength(0);
        sb.append(hourKeyPrefix);
        sb.append(":");
        sb.append(gateId.intValue());
        key = sb.toString();
        map.put("createTime", hourCountDate);
        boundHashOps = this.redisTemplate.boundHashOps((Object)key);
        if (!this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES).booleanValue()) {
            object = GATE_HOUR_SYNC;
            synchronized (object) {
                if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                    this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u76d1\u63a7\u70b9> <\u5c0f\u65f6\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                    this.loadGateHourCountSta(channel.getMallId(), gateId, hourCountDate, boundHashOps);
                }
            }
        }
        this.incrementValueWithGateType(inNum, outNum, 1, boundHashOps);
        boundHashOps.putAll(map);
        this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES);
        sb.setLength(0);
        sb.append(dayKeyPrefix);
        sb.append(":");
        sb.append(gateId.intValue());
        key = sb.toString();
        Date dayCountDate = DateUtil.parse((String)"yyyyMMdd", (String)dayDateStr);
        map.put("createTime", dayCountDate);
        boundHashOps = this.redisTemplate.boundHashOps((Object)key);
        if (!this.redisTemplate.expire((Object)key, 2L, TimeUnit.HOURS).booleanValue()) {
            Object object2 = GATE_DAY_SYNC;
            synchronized (object2) {
                if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                    this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u76d1\u63a7\u70b9> <\u5929\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                    this.loadGateDayCountSta(channel.getMallId(), gateId, dayCountDate, boundHashOps);
                }
            }
        }
        this.incrementValueWithGateType(inNum, outNum, 1, boundHashOps);
        boundHashOps.putAll(map);
        this.redisTemplate.expire((Object)key, 2L, TimeUnit.HOURS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void floorCountData2Redis(Channel channel, List<FloorGate> list, Date createTime, int inNum, int outNum) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateStr = sdf.format(createTime);
        String dayDateStr = sdf.format(DateUtil.addHours((Date)createTime, (int)this.mallDayTimeOffset));
        dayDateStr = dayDateStr.substring(0, 8);
        StringBuilder sb = new StringBuilder();
        sb.append("countData:minute:floor:");
        sb.append(dateStr.substring(0, 11));
        String minueKeyPrefix = sb.toString();
        sb.setLength(0);
        sb.append("countData:hour:floor:");
        sb.append(dateStr.substring(0, 10));
        String hourKeyPrefix = sb.toString();
        sb.setLength(0);
        sb.append("countData:day:floor:");
        sb.append(dayDateStr);
        String dayKeyPrefix = sb.toString();
        HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
        Date countDate = createTime;
        countDate = DateUtil.setMilliseconds((Date)countDate, (int)0);
        countDate = DateUtil.setSeconds((Date)countDate, (int)0);
        Date minuteCountDate = DateUtil.setMinutes((Date)countDate, (int)(DateUtil.getMinute((Date)countDate) / 10 * 10));
        Date hourCountDate = DateUtil.setMinutes((Date)countDate, (int)0);
        for (FloorGate floorGate : list) {
            Object object;
            map.clear();
            long floorId = floorGate.getFloorId();
            int type = floorGate.getType();
            map.put("mallId", channel.getMallId());
            map.put("accountId", channel.getAccountId());
            map.put("floorId", Long.valueOf(floorId));
            map.put("createTime", minuteCountDate);
            sb.setLength(0);
            sb.append(minueKeyPrefix);
            sb.append(":");
            sb.append(floorId);
            String key = sb.toString();
            BoundHashOperations boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            if (!this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES).booleanValue()) {
                object = FLOOR_MINUTE_SYNC;
                synchronized (object) {
                    if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                        this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u697c\u5c42> <\u5206\u949f\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                        this.loadFloorMinuteCountSta(channel.getMallId(), Long.valueOf(floorId), minuteCountDate, boundHashOps);
                    }
                }
            }
            this.incrementValueWithBindType(inNum, outNum, type, boundHashOps);
            boundHashOps.putAll(map);
            this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES);
            map.put("createTime", hourCountDate);
            sb.setLength(0);
            sb.append(hourKeyPrefix);
            sb.append(":");
            sb.append(floorId);
            key = sb.toString();
            boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            if (!this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES).booleanValue()) {
                object = FLOOR_HOUR_SYNC;
                synchronized (object) {
                    if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                        this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u697c\u5c42> <\u5206\u949f\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                        this.loadFloorHourCountSta(channel.getMallId(), Long.valueOf(floorId), hourCountDate, boundHashOps);
                    }
                }
            }
            this.incrementValueWithBindType(inNum, outNum, type, boundHashOps);
            boundHashOps.putAll(map);
            this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES);
            sb.setLength(0);
            sb.append(dayKeyPrefix);
            Date dayCountDate = DateUtil.parse((String)"yyyyMMdd", (String)dayDateStr);
            sb.append(":");
            sb.append(floorId);
            key = sb.toString();
            boundHashOps = this.redisTemplate.boundHashOps((Object)key);
            map.put("createTime", dayCountDate);
            if (!this.redisTemplate.expire((Object)key, 2L, TimeUnit.HOURS).booleanValue()) {
                Object object2 = FLOOR_DAY_SYNC;
                synchronized (object2) {
                    if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                        this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u697c\u5c42> <\u5929\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                        this.loadFloorDayCountSta(channel.getMallId(), Long.valueOf(floorId), dayCountDate, boundHashOps);
                    }
                }
            }
            this.incrementValueWithBindType(inNum, outNum, type, boundHashOps);
            boundHashOps.putAll(map);
            this.redisTemplate.expire((Object)key, 2L, TimeUnit.HOURS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mallCountData2Redis(Channel channel, Long mallId, Gate gate, Date createTime, int inNum, int outNum) throws ParseException {
        Object object;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String dateStr = sdf.format(createTime);
        String dayDateStr = sdf.format(DateUtil.addHours((Date)createTime, (int)this.mallDayTimeOffset));
        dayDateStr = dayDateStr.substring(0, 8);
        Date countDate = createTime;
        countDate = DateUtil.setMilliseconds((Date)countDate, (int)0);
        countDate = DateUtil.setSeconds((Date)countDate, (int)0);
        Date minuteCountDate = DateUtil.setMinutes((Date)countDate, (int)(DateUtil.getMinute((Date)countDate) / 10 * 10));
        Date hourCountDate = DateUtil.setMinutes((Date)countDate, (int)0);
        StringBuilder sb = new StringBuilder();
        sb.append("countData:minute:mall:");
        sb.append(dateStr.substring(0, 11));
        String minueKeyPrefix = sb.toString();
        sb.setLength(0);
        sb.append("countData:hour:mall:");
        sb.append(dateStr.substring(0, 10));
        String hourKeyPrefix = sb.toString();
        sb.setLength(0);
        sb.append("countData:day:mall:");
        sb.append(dayDateStr);
        String dayKeyPrefix = sb.toString();
        HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
        map.put("mallId", mallId);
        map.put("accountId", channel.getAccountId());
        sb.setLength(0);
        sb.append(minueKeyPrefix);
        sb.append(":");
        sb.append(mallId.intValue());
        String key = sb.toString();
        map.put("createTime", minuteCountDate);
        BoundHashOperations boundHashOps = this.redisTemplate.boundHashOps((Object)key);
        if (!this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES).booleanValue()) {
            object = MALL_MINUTE_SYNC;
            synchronized (object) {
                if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                    this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u5546\u573a> <\u5206\u949f\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                    this.loadMallMinuteCountSta(mallId, minuteCountDate, boundHashOps);
                }
            }
        }
        this.incrementValueWithGateType(inNum, outNum, gate.getType(), boundHashOps);
        boundHashOps.putAll(map);
        this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES);
        sb.setLength(0);
        sb.append(hourKeyPrefix);
        sb.append(":");
        sb.append(mallId.intValue());
        key = sb.toString();
        boundHashOps = this.redisTemplate.boundHashOps((Object)key);
        if (!this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES).booleanValue()) {
            object = MALL_HOUR_SYNC;
            synchronized (object) {
                if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                    this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u5546\u573a> <\u5c0f\u65f6\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                    this.loadMallHourCountSta(mallId, hourCountDate, boundHashOps);
                }
            }
        }
        this.incrementValueWithGateType(inNum, outNum, gate.getType(), boundHashOps);
        map.put("createTime", hourCountDate);
        boundHashOps.putAll(map);
        this.redisTemplate.expire((Object)key, 30L, TimeUnit.MINUTES);
        sb.setLength(0);
        sb.append(dayKeyPrefix);
        Date dayCountDate = DateUtil.parse((String)"yyyyMMdd", (String)dayDateStr);
        sb.append(":");
        sb.append(mallId.intValue());
        key = sb.toString();
        boundHashOps = this.redisTemplate.boundHashOps((Object)key);
        if (!this.redisTemplate.expire((Object)key, 2L, TimeUnit.HOURS).booleanValue()) {
            Object object2 = MALL_DAY_SYNC;
            synchronized (object2) {
                if (!this.redisTemplate.hasKey((Object)key).booleanValue()) {
                    this.logger.info("\u5f00\u59cb\u52a0\u8f7d <\u5546\u573a> <\u5929\u7ea7> \u5ba2\u6d41\u7edf\u8ba1\u7f13\u5b58 key:{}", (Object)key);
                    this.loadMallDayCountSta(mallId, hourCountDate, boundHashOps);
                }
            }
        }
        this.incrementValueWithGateType(inNum, outNum, gate.getType(), boundHashOps);
        map.put("createTime", dayCountDate);
        boundHashOps.putAll(map);
        this.redisTemplate.expire((Object)key, 2L, TimeUnit.HOURS);
    }

    private void incrementValueWithGateType(int inNum, int outNum, int gateType, BoundHashOperations boundHashOps) {
        if (gateType == 2) {
            boundHashOps.increment((Object)"outsideInum", (long)inNum);
            boundHashOps.increment((Object)"outsideOutnum", (long)outNum);
        } else {
            boundHashOps.increment((Object)"innum", (long)inNum);
            boundHashOps.increment((Object)"outnum", (long)outNum);
        }
        boundHashOps.increment((Object)"flagUpdate", 1L);
    }

    private void incrementValueWithBindType(int inNum, int outNum, int bindType, BoundHashOperations boundHashOps) {
        if (bindType == 3) {
            boundHashOps.increment((Object)"outsideInum", (long)inNum);
            boundHashOps.increment((Object)"outsideOutnum", (long)outNum);
        } else if (bindType == 1) {
            boundHashOps.increment((Object)"innum", (long)inNum);
            boundHashOps.increment((Object)"outnum", (long)outNum);
        } else if (bindType == 2) {
            boundHashOps.increment((Object)"innum", (long)outNum);
            boundHashOps.increment((Object)"outnum", (long)inNum);
        }
        boundHashOps.increment((Object)"flagUpdate", 1L);
    }

    private void loadGateDayCountSta(Long mallId, Long gateId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum  FROM d_gate_day_count_data WHERE mall_id= ? AND gate_id = ? AND countdate = ?  LIMIT 1", new Object[]{mallId, gateId, counttime}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadGateHourCountSta(Long mallId, Long gateId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum  FROM d_gate_hour_count_data WHERE mall_id= ? AND gate_id = ? AND countdate = ? AND counttime = ?  LIMIT 1", new Object[]{mallId, gateId, counttime, counttime}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadGateMinuteCountSta(Long mallId, Long gateId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum  FROM d_gate_minute_count_data WHERE mall_id= ? AND gate_id = ? AND countdate = ? AND counttime = ? LIMIT 1", new Object[]{mallId, gateId, counttime, counttime}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadFloorDayCountSta(Long mallId, Long floorId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum  FROM d_floor_day_count_data WHERE mall_id= ? AND floor_id = ? AND countdate = ?  LIMIT 1", new Object[]{mallId, floorId, counttime}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadFloorHourCountSta(Long mallId, Long floorId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum  FROM d_floor_hour_count_data WHERE mall_id= ? AND floor_id = ? AND countdate = ? AND counttime = ?  LIMIT 1", new Object[]{mallId, floorId, counttime, counttime}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadFloorMinuteCountSta(Long mallId, Long floorId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum  FROM d_floor_minute_count_data WHERE mall_id= ? AND floor_id = ? AND countdate = ? AND counttime = ? LIMIT 1", new Object[]{mallId, floorId, counttime, counttime}, this.getRowCallbackHandler(boundHashOps));
    }

    private void loadZoneDayCountSta(Long mallId, Long zoneId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum,outside_innum,outside_outnum  FROM d_zone_day_count_data WHERE mall_id= ? AND zone_id = ? AND countdate = ?   LIMIT 1", new Object[]{mallId, zoneId, counttime}, this.getRowCallbackHandlerWithOutside(boundHashOps));
    }

    private void loadZoneHourCountSta(Long mallId, Long zoneId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum,outside_innum,outside_outnum  FROM d_zone_hour_count_data WHERE mall_id= ? AND zone_id = ? AND countdate = ? AND counttime = ?  LIMIT 1", new Object[]{mallId, zoneId, counttime, counttime}, this.getRowCallbackHandlerWithOutside(boundHashOps));
    }

    private void loadZoneMinuteCountSta(Long mallId, Long zoneId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum,outside_innum,outside_outnum  FROM d_zone_minute_count_data WHERE mall_id= ? AND zone_id = ? AND countdate = ? AND counttime = ? LIMIT 1", new Object[]{mallId, zoneId, counttime, counttime}, this.getRowCallbackHandlerWithOutside(boundHashOps));
    }

    private void loadMallDayCountSta(Long mallId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum,outside_innum,outside_outnum  FROM d_mall_day_count_data WHERE mall_id= ?  AND countdate = ? LIMIT 1", new Object[]{mallId, counttime}, this.getRowCallbackHandlerWithOutside(boundHashOps));
    }

    private void loadMallHourCountSta(Long mallId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum,outside_innum,outside_outnum  FROM d_mall_hour_count_data WHERE mall_id= ?  AND countdate = ? AND counttime = ?  LIMIT 1", new Object[]{mallId, counttime, counttime}, this.getRowCallbackHandlerWithOutside(boundHashOps));
    }

    private void loadMallMinuteCountSta(Long mallId, Date counttime, BoundHashOperations boundHashOps) {
        this.jdbcTemplate.query("SELECT innum,outnum,outside_innum,outside_outnum  FROM d_mall_minute_count_data WHERE mall_id= ?  AND countdate = ? AND counttime = ? LIMIT 1", new Object[]{mallId, counttime, counttime}, this.getRowCallbackHandlerWithOutside(boundHashOps));
    }

    private RowCallbackHandler getRowCallbackHandlerWithOutside(BoundHashOperations boundHashOps) {
        return rs -> {
            boundHashOps.increment((Object)"innum", rs.getLong("innum"));
            boundHashOps.increment((Object)"outnum", rs.getLong("outnum"));
            boundHashOps.increment((Object)"outsideInum", rs.getLong("outside_innum"));
            boundHashOps.increment((Object)"outsideOutnum", rs.getLong("outside_outnum"));
        };
    }

    private RowCallbackHandler getRowCallbackHandler(BoundHashOperations boundHashOps) {
        return rs -> {
            boundHashOps.increment((Object)"innum", rs.getLong("innum"));
            boundHashOps.increment((Object)"outnum", rs.getLong("outnum"));
        };
    }
}

