/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.service;

import com.viontech.keliu.model.ConfigParam;
import com.viontech.keliu.model.ConfigParamRaw;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ConfigParamService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    public final String SQL_SELECT_ALL = "SELECT mall_id, key, value FROM s_config_params";

    public Map<Long, ConfigParam> selectAll() {
        List configParams = this.jdbcTemplate.query("SELECT mall_id, key, value FROM s_config_params", new Object[0], (RowMapper)new BeanPropertyRowMapper(ConfigParamRaw.class));
        HashMap<Long, ConfigParam> configParamMap = new HashMap<Long, ConfigParam>();
        if (configParams.isEmpty()) {
            return null;
        }
        for (ConfigParamRaw configParamRaw : configParams) {
            ConfigParam configParam;
            if (configParamRaw.getKey() == null || configParamRaw.getValue() == null) continue;
            if (configParamRaw.getMallId() == null) {
                configParamRaw.setMallId(Long.valueOf(-1L));
            }
            if ((configParam = (ConfigParam)configParamMap.get(configParamRaw.getMallId())) == null) {
                configParam = new ConfigParam();
                configParamMap.put(configParamRaw.getMallId(), configParam);
            }
            String value = configParamRaw.getValue();
            switch (configParamRaw.getKey()) {
                case "backendAnalysisConfig": {
                    configParam.setCalibrate(value);
                    break;
                }
                case "customCompareConfig": {
                    configParam.setCustom(value);
                    break;
                }
                case "clerkCompareConfig": {
                    configParam.setStaff(value);
                    break;
                }
                case "newAndOldCustomerConfig": {
                    configParam.setNewOrRegular(value);
                    break;
                }
                case "faceFeatureConfig": {
                    configParam.setFaceFeature(value);
                    break;
                }
                case "bodyFeatureConfig": {
                    configParam.setBodyFeature(value);
                    break;
                }
                case "reidConfig": {
                    configParam.setReid(value);
                    break;
                }
                case "subPoolConfig": {
                    configParam.setSubPool(value);
                    break;
                }
                case "staffBodyMatchConfig": {
                    configParam.setStaffBodyMatch(value);
                    break;
                }
                case "personLibCompareConfig": {
                    configParam.setPersonLib(value);
                }
            }
        }
        return configParamMap;
    }
}

