/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.runner;

import com.viontech.keliu.service.OrgCacheService;
import com.viontech.keliu.service.WorkQueueProcessService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SessionCallback;
import org.springframework.stereotype.Component;

@Component
@Order(value=10)
public class WorkQueueProcessRunner
implements CommandLineRunner {
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private WorkQueueProcessService workQueueProcessService;
    @Resource
    private OrgCacheService orgCacheService;
    @Value(value="#{'${spring.cloud.client.ip-address}'+':'+'${server.port}'}")
    private String ipPort;
    private Logger logger = LoggerFactory.getLogger(WorkQueueProcessRunner.class);

    public void run(String ... args) throws Exception {
        new Thread(() -> {
            this.logger.info("\u5904\u7406faceDataWorkQueue\u5f00\u59cb");
            this.processWorkQueue("faceData:workQueue:" + this.ipPort + ":*");
            this.logger.info("\u5904\u7406faceDataWorkQueue\u5b8c\u6210");
            this.logger.info("\u5904\u7406coutnDataWorkQueue\u5f00\u59cb");
            this.processWorkQueue("countData:workQueue:" + this.ipPort + ":*");
            this.logger.info("\u5904\u7406coutnDataWorkQueue\u5b8c\u6210");
            this.logger.info("\u5904\u7406multiPCountRecords_V2WorkQueue\u5f00\u59cb");
            this.processWorkQueue("multiPCountRecords_V2:workQueue:" + this.ipPort + ":*");
            this.logger.info("\u5904\u7406multiPCountRecords_V2WorkQueue\u5b8c\u6210");
        }).start();
    }

    public void processWorkQueue(String pattern) {
        String queueName = pattern.split(":")[0];
        Set keys = this.redisTemplate.keys((Object)pattern);
        HashMap dbKeyMap = new HashMap();
        keys.forEach(item -> {
            String workQueueName = String.valueOf(item);
            this.logger.info("\u5f00\u59cb\u5904\u7406{}", (Object)workQueueName);
            this.processOneWorkQueue(dbKeyMap, workQueueName, queueName);
            this.logger.info("\u5904\u7406{}\u5b8c\u6210", (Object)workQueueName);
        });
    }

    private void processOneWorkQueue(Map dbKeyMap, String source, String target) {
        BoundListOperations boundListOperations = this.redisTemplate.boundListOps((Object)source);
        Long size = boundListOperations.size();
        if (size == null || size == 0L) {
            return;
        }
        List range = boundListOperations.range(0L, size.longValue());
        BoundListOperations targetBoundListOperations = this.redisTemplate.boundListOps((Object)target);
        Map channelMaps = this.orgCacheService.getChannelMap();
        this.redisTemplate.execute((SessionCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ WorkQueueProcessService access$000(WorkQueueProcessRunner x0) {
        return x0.workQueueProcessService;
    }

    static /* synthetic */ RedisTemplate access$100(WorkQueueProcessRunner x0) {
        return x0.redisTemplate;
    }
}

