/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.runner;

import com.viontech.keliu.redis.RedisUtil;
import com.viontech.keliu.util.DateUtil;
import java.text.ParseException;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.scheduling.annotation.Scheduled;

public class RedisCacheClearRunner
implements CommandLineRunner {
    private Logger logger = LoggerFactory.getLogger(RedisCacheClearRunner.class);
    private long defaultExpireTime = 259200000L;

    public void run(String ... args) throws Exception {
    }

    @Scheduled(cron="0 0 0/1 * * ?")
    public void scheduledDelKey() {
    }

    private void delKey(String keyMatcher, int dateStrIndex, String dateFormat) {
        this.logger.debug("\u5f00\u59cb\u6e05\u9664 {} \u7f13\u5b58\u8fc7\u671f\u6570\u636e", (Object)keyMatcher);
        Set keys = RedisUtil.getKeys((String)keyMatcher);
        long nowTime = System.currentTimeMillis();
        for (String key : keys) {
            String dateStr = key.split(":")[dateStrIndex];
            Date date = null;
            try {
                date = DateUtil.parse((String)dateFormat, (String)dateStr);
            }
            catch (ParseException e) {
                e.printStackTrace();
                continue;
            }
            if (nowTime - date.getTime() <= this.defaultExpireTime) continue;
            this.logger.info("\u6e05\u9664\u8fc7\u671f\u6570\u636e:{}", (Object)key);
            RedisUtil.remove((String)key);
        }
        this.logger.info("\u7ed3\u675f\u6e05\u9664 {} \u7f13\u5b58\u8fc7\u671f\u6570\u636e", (Object)keyMatcher);
    }
}

