/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.runner;

import java.util.UUID;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Order(value=11)
public class JobStartRunner
implements CommandLineRunner {
    @Autowired
    Job rawCountDataProcessJob;
    @Autowired
    Job rawFaceDataProcessJob;
    @Autowired
    Job rawHeatmapDataProcessJob;
    @Autowired
    Job channelSnapshotDataProcessJob;
    @Autowired
    Job faceDataProcessJob;
    @Autowired
    Job deviceProcessJob;
    @Autowired
    Job countDataRedis2DBJob;
    @Autowired
    Job faceDataStaRedis2DBJob;
    @Autowired
    Job gateRetentionDataProcessJob;
    @Autowired
    JobRepository jobRepository;

    public void run(String ... args) throws Exception {
        SimpleJobLauncher sjl = new SimpleJobLauncher();
        sjl.setJobRepository(this.jobRepository);
        sjl.setTaskExecutor((TaskExecutor)new SimpleAsyncTaskExecutor());
        sjl.afterPropertiesSet();
        JobParameters jobParameters = new JobParametersBuilder().addString("uuid", UUID.randomUUID().toString()).toJobParameters();
        sjl.run(this.rawCountDataProcessJob, jobParameters);
        jobParameters = new JobParametersBuilder().addString("uuid", UUID.randomUUID().toString()).toJobParameters();
        sjl.run(this.deviceProcessJob, jobParameters);
        for (int i = 0; i < 20; ++i) {
            jobParameters = new JobParametersBuilder().addString("uuid", UUID.randomUUID().toString()).toJobParameters();
            sjl.run(this.faceDataProcessJob, jobParameters);
        }
        jobParameters = new JobParametersBuilder().addString("uuid", UUID.randomUUID().toString()).toJobParameters();
        sjl.run(this.rawHeatmapDataProcessJob, jobParameters);
        jobParameters = new JobParametersBuilder().addString("uuid", UUID.randomUUID().toString()).toJobParameters();
        sjl.run(this.channelSnapshotDataProcessJob, jobParameters);
        jobParameters = new JobParametersBuilder().addString("uuid", UUID.randomUUID().toString()).toJobParameters();
        sjl.run(this.gateRetentionDataProcessJob, jobParameters);
    }
}

