/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.queue;

import com.viontech.keliu.queue.QueueHandler;
import com.viontech.keliu.queue.RedisWriter;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.batch.core.ChunkListener;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.step.builder.SimpleStepBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.data.redis.core.RedisTemplate;

public class QueueProcessStepBuilder<I, O> {
    private RedisTemplate redisTemplate;
    private Function<I, O> processor;
    private Consumer<List> writer;
    private RedisWriter<O> redisWriter;
    private String queueName;
    private String stepName;
    private StepBuilderFactory stepBuilderFactory;

    public QueueProcessStepBuilder queueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    public QueueProcessStepBuilder stepName(String stepName) {
        this.stepName = stepName;
        return this;
    }

    public QueueProcessStepBuilder redisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
        return this;
    }

    public QueueProcessStepBuilder writer(Consumer<List> writer) {
        this.writer = writer;
        return this;
    }

    public QueueProcessStepBuilder redisWriter(RedisWriter<O> redisWriter) {
        this.redisWriter = redisWriter;
        return this;
    }

    public QueueProcessStepBuilder processor(Function<I, O> processor) {
        this.processor = processor;
        return this;
    }

    public QueueProcessStepBuilder stepBuilderFactory(StepBuilderFactory stepBuilderFactory) {
        this.stepBuilderFactory = stepBuilderFactory;
        return this;
    }

    public Step build() {
        QueueHandler queueHandler = new QueueHandler();
        queueHandler.setQueueName(this.queueName);
        queueHandler.setRedisTemplate(this.redisTemplate);
        queueHandler.setProcessor(this.processor);
        queueHandler.setWriter(this.writer);
        queueHandler.setRedisWriter(this.redisWriter);
        SimpleStepBuilder stepBuilder = this.stepBuilderFactory.get(this.stepName).chunk(0).reader(() -> queueHandler.read()).processor((ItemProcessor)new /* Unavailable Anonymous Inner Class!! */).writer((ItemWriter)new /* Unavailable Anonymous Inner Class!! */);
        stepBuilder.listener((ChunkListener)new /* Unavailable Anonymous Inner Class!! */);
        return stepBuilder.build();
    }
}

