/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.jobhandler;

import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class FaceDataSta2DBProcessHandler {
    @Autowired
    Job faceDataStaRedis2DBJob;
    @Autowired
    JobRepository jobRepository;
    private Logger logger = LoggerFactory.getLogger(FaceDataSta2DBProcessHandler.class);

    @Scheduled(cron="30 5/5 * * * ?")
    public void execute() throws Exception {
        long time = System.currentTimeMillis();
        this.logger.info("FaceDataSta2DBProcessHandler start:" + time);
        SimpleJobLauncher sjl = new SimpleJobLauncher();
        sjl.setJobRepository(this.jobRepository);
        sjl.afterPropertiesSet();
        JobParameters jobParameters = new JobParametersBuilder().addString("uuid", UUID.randomUUID().toString()).toJobParameters();
        JobExecution result = sjl.run(this.faceDataStaRedis2DBJob, jobParameters);
        time = System.currentTimeMillis();
        this.logger.info("FaceDataSta2DBProcessHandler end:" + time);
    }
}

