/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.dao;

import com.viontech.keliu.model.FaceRecognition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class FaceRecognitionDao {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private final String SQL_SELECT = "select id,device_id,channel_id,gate_id,device_serialnum,channel_serialnum,person_type,face_pic,face_pic_num,body_pic_num,body_pic,mood,age,gender,direction,counttime,countdate,modify_time,create_time,mall_id,account_id,person_unid,status,face_feature_type,body_feature_type,track_info,track_time,happy_conf,history_arrival_count,today_arrival_count,unid from d_face_recognition where status = 1;";
    private final String SQL_SELECT_BYMALLID = "select id,device_id,channel_id,gate_id,device_serialnum,channel_serialnum,person_type,face_pic,face_pic_num,body_pic_num,body_pic,mood,age,gender,direction,counttime,countdate,modify_time,create_time,mall_id,account_id,person_unid,status,face_feature_type,body_feature_type,track_info,track_time,happy_conf,history_arrival_count,today_arrival_count,unid,face_score from d_face_recognition where mall_id =? and countdate =? and person_type =? ";
    private final String SQL_SELECT_BATCH_PARAMETER = "select id,channel_serialnum,mall_id,person_unid,face_feature,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where countdate >? and status =0 and direction =1 and age > 0 order by id asc";
    private final String SQL_SELECT_COUNTDATE_MALLID = "select id,person_unid,channel_serialnum,face_pic,face_score,countdate,face_feature_type from d_face_recognition where countdate = ? and mall_id = ? and direction =1 and age > 0 and person_type =0";
    private final String SQL_SELECT_TRACKGROU = "SELECT ID,channel_serialnum,track_info,countdate FROM d_face_recognition WHERE countdate = ? AND channel_id = ? and mall_id = ? AND person_type =0";
    private final String SQL_SELECT_MINANDMAX_ID = "SELECT MIN(id) as minId, max(id) as maxId FROM d_face_recognition WHERE countdate >? AND status = 0 AND direction = 1 AND age > 0";
    private final String SQL_SELECT_BYMAXANDMIN_ID = "select id,channel_serialnum,mall_id,person_unid,face_pic,face_feature_type,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where id >= ? and id <? and status =0 and direction =1 and age > 0 order by id asc";
    private final String SQL_SELECT_MIN_ID = "select id as minId from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id asc limit 1";
    private final String SQL_SELECT_MAX_ID = "select id as maxId from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id desc limit 1";
    private final String SQL_SELECT_ID = "select id from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id asc";
    private final String SQL_UPDATE_STATUSANDHASHCODE = "update d_face_recognition set status = 3,flag = ? where id in( select id from d_face_recognition where direction =1 and age > 0 and status = 0 and countdate > ? ORDER BY id asc LIMIT 1000 );";
    private final String SQL_SELECT_IDBYHASHCODE = "select id from d_face_recognition where countdate > ? and flag = ? and direction =1 and age>0 and status = 3 order by id asc";
    private final String SQL_SELECT_BYMAXIDANDMINANDHASHCODE = "select id,channel_serialnum,mall_id,person_unid,face_pic,face_feature_type,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where id >= ? and id <? and  flag = ? and status =3 and direction =1 and age > 0 order by id asc";
    private final String SQL_SELECT_BY_ID = "select id,channel_serialnum,mall_id,person_unid,face_pic,face_feature_type,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where id > ? and direction =1 and age>0 and status = 0 order by id asc LIMIT 1000";
    private final String SQL_SELECT_BY_COUNTDATE = "select id,channel_serialnum,mall_id,person_unid,face_pic,face_feature_type,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where countdate = ? and direction = 1 and age>0 and status = 0 order by id asc LIMIT 1000";
    private final String SQL_CACHE_INFO = "select unid as unid,channel_serialnum,counttime from d_face_recognition where countdate=? and mall_id =?";
    private final String ORDER_SQL_SELECT_FACERECOGNITIONINFO = "select id,unid,person_unid,person_type,channel_serialnum,counttime,face_pic,face_pic_num,body_pic_num,channel_id,gate_id,direction,mood,age,gender,track_time,face_feature_type from d_face_recognition where countdate =? and mall_id = ? order by id ASC";
    private final String SQL_UPDATE_UNIDINFO = "update d_face_recognition set person_unid = ?, person_type = ? where countdate =? and mall_id = ? and unid = ?;";

    public List<FaceRecognition> selectAll() {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List gates = this.jdbcTemplate.query("select id,device_id,channel_id,gate_id,device_serialnum,channel_serialnum,person_type,face_pic,face_pic_num,body_pic_num,body_pic,mood,age,gender,direction,counttime,countdate,modify_time,create_time,mall_id,account_id,person_unid,status,face_feature_type,body_feature_type,track_info,track_time,happy_conf,history_arrival_count,today_arrival_count,unid from d_face_recognition where status = 1;", (RowMapper)rowMapper);
        return gates;
    }

    public List<FaceRecognition> selectByParameter(Long mallId, Date countdate, Integer personType) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,device_id,channel_id,gate_id,device_serialnum,channel_serialnum,person_type,face_pic,face_pic_num,body_pic_num,body_pic,mood,age,gender,direction,counttime,countdate,modify_time,create_time,mall_id,account_id,person_unid,status,face_feature_type,body_feature_type,track_info,track_time,happy_conf,history_arrival_count,today_arrival_count,unid,face_score from d_face_recognition where mall_id =? and countdate =? and person_type =? ", (RowMapper)rowMapper, new Object[]{mallId, countdate, personType});
        return frrs;
    }

    public List<FaceRecognition> selectByCountDate(Date countDate) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,channel_serialnum,mall_id,person_unid,face_feature,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where countdate >? and status =0 and direction =1 and age > 0 order by id asc", (RowMapper)rowMapper, new Object[]{countDate});
        return frrs;
    }

    public List<FaceRecognition> selectByCountDateAndMallId(Date countdate, Long mallId) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,person_unid,channel_serialnum,face_pic,face_score,countdate,face_feature_type from d_face_recognition where countdate = ? and mall_id = ? and direction =1 and age > 0 and person_type =0", (RowMapper)rowMapper, new Object[]{countdate, mallId});
        return frrs;
    }

    public List<FaceRecognition> select4TrackGroup(Date countDate, Long channelId, Long mallId) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("SELECT ID,channel_serialnum,track_info,countdate FROM d_face_recognition WHERE countdate = ? AND channel_id = ? and mall_id = ? AND person_type =0", (RowMapper)rowMapper, new Object[]{countDate, channelId, mallId});
        return frrs;
    }

    public Map<String, Object> selectMinAndMaxId(Date countDate) {
        Map map = this.jdbcTemplate.queryForMap("SELECT MIN(id) as minId, max(id) as maxId FROM d_face_recognition WHERE countdate >? AND status = 0 AND direction = 1 AND age > 0", new Object[]{countDate});
        return map;
    }

    public List<FaceRecognition> selectByMaxAndMinId(Long minId, Long maxId) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,channel_serialnum,mall_id,person_unid,face_pic,face_feature_type,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where id >= ? and id <? and status =0 and direction =1 and age > 0 order by id asc", (RowMapper)rowMapper, new Object[]{minId, maxId});
        return frrs;
    }

    public Long selectMinId(Date countDate) {
        List minIds = this.jdbcTemplate.queryForList("select id as minId from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id asc limit 1", Long.class, new Object[]{countDate});
        if (minIds == null || minIds.isEmpty()) {
            return null;
        }
        return (Long)minIds.get(0);
    }

    public Long selectMaxId(Date countDate) {
        List maxIds = this.jdbcTemplate.queryForList("select id as maxId from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id desc limit 1", Long.class, new Object[]{countDate});
        if (maxIds == null || maxIds.isEmpty()) {
            return null;
        }
        return (Long)maxIds.get(0);
    }

    public List<FaceRecognition> selectIds(Date countDate) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id from d_face_recognition where countdate > ? and direction =1 and age>0 and status = 0 order by id asc", (RowMapper)rowMapper, new Object[]{countDate});
        return frrs;
    }

    public Boolean updateRowsByHashCode(Date date, int hashcode) {
        int update = this.jdbcTemplate.update("update d_face_recognition set status = 3,flag = ? where id in( select id from d_face_recognition where direction =1 and age > 0 and status = 0 and countdate > ? ORDER BY id asc LIMIT 1000 );", new Object[]{hashcode, date});
        if (update > 0) {
            return true;
        }
        return false;
    }

    public List<FaceRecognition> selectIdsByHashCode(Date date, int hashcode) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id from d_face_recognition where countdate > ? and flag = ? and direction =1 and age>0 and status = 3 order by id asc", (RowMapper)rowMapper, new Object[]{date, hashcode});
        return frrs;
    }

    public List<FaceRecognition> selectByMaxAndMinIdAndHashCode(Long minId, Long maxId, int hashcode) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,channel_serialnum,mall_id,person_unid,face_pic,face_feature_type,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where id >= ? and id <? and  flag = ? and status =3 and direction =1 and age > 0 order by id asc", (RowMapper)rowMapper, new Object[]{minId, maxId, hashcode});
        return frrs;
    }

    public List<FaceRecognition> selectlistById(Long id) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,channel_serialnum,mall_id,person_unid,face_pic,face_feature_type,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where id > ? and direction =1 and age>0 and status = 0 order by id asc LIMIT 1000", (RowMapper)rowMapper, new Object[]{id});
        return frrs;
    }

    public List<FaceRecognition> selectListByCountDate(Date date) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,channel_serialnum,mall_id,person_unid,face_pic,face_feature_type,unid,countdate,counttime,account_id,direction,person_type,gender,age from d_face_recognition where countdate = ? and direction = 1 and age>0 and status = 0 order by id asc LIMIT 1000", (RowMapper)rowMapper, new Object[]{date});
        return frrs;
    }

    public List<FaceRecognition> selCacheInfo(Date countDate) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List mallIds = this.jdbcTemplate.queryForList("select id from b_mall", Long.class);
        ArrayList<FaceRecognition> result = new ArrayList<FaceRecognition>();
        for (Long mallId : mallIds) {
            List frrs = this.jdbcTemplate.query("select unid as unid,channel_serialnum,counttime from d_face_recognition where countdate=? and mall_id =?", (RowMapper)rowMapper, new Object[]{countDate, mallId});
            result.addAll(frrs);
        }
        return result;
    }

    public List<FaceRecognition> selfaceRecognitionInfo4Order(Date countDate, Long mallid) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(FaceRecognition.class);
        List frrs = this.jdbcTemplate.query("select id,unid,person_unid,person_type,channel_serialnum,counttime,face_pic,face_pic_num,body_pic_num,channel_id,gate_id,direction,mood,age,gender,track_time,face_feature_type from d_face_recognition where countdate =? and mall_id = ? order by id ASC", (RowMapper)rowMapper, new Object[]{countDate, mallid});
        return frrs;
    }

    public boolean updateUnidInfo(FaceRecognition faceRecognition) {
        int update = this.jdbcTemplate.update("update d_face_recognition set person_unid = ?, person_type = ? where countdate =? and mall_id = ? and unid = ?;", new Object[]{faceRecognition.getPersonUnid(), faceRecognition.getPersonType(), faceRecognition.getCountdate(), faceRecognition.getMallId(), faceRecognition.getUnid()});
        return update == 1;
    }
}

