/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.dao;

import com.viontech.keliu.model.FaceStaData;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class FaceDataStaKeyDao {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private volatile BeanPropertyRowMapper<FaceStaData> mapper = new BeanPropertyRowMapper(FaceStaData.class);
    private final String SQL_DAY_GATE = "select DISTINCT gate_id as orgId,countdate as countDate from d_gate_day_face_recognition_sta where countdate = ?;";
    private final String SQL_DAY_ZONE = "select DISTINCT zone_id as orgId,countdate as countDate from d_zone_day_face_recognition_sta where countdate = ?;";
    private final String SQL_DAY_FLOOR = "select DISTINCT floor_id as orgId,countdate as countDate from d_floor_day_face_recognition_sta where countdate = ?;";
    private final String SQL_DAY_MALL = "select DISTINCT mall_id as orgId,countdate as countDate from d_mall_day_face_recognition_sta where countdate = ?;";
    private final String SQL_HOUR_GATE = "select DISTINCT gate_id as orgId,countdate as countDate,counttime as countTime from d_gate_hour_face_recognition_sta where countdate = ?;";
    private final String SQL_HOUR_ZONE = "select DISTINCT zone_id as orgId,countdate as countDate,counttime as countTime from d_zone_hour_face_recognition_sta where countdate = ?;";
    private final String SQL_HOUR_FLOOR = "select DISTINCT floor_id as orgId,countdate as countDate,counttime as countTime from d_floor_hour_face_recognition_sta where countdate = ?;";
    private final String SQL_HOUR_MALL = "select DISTINCT mall_id as orgId,countdate as countDate,counttime as countTime from d_mall_hour_face_recognition_sta where countdate = ?;";

    public List<FaceStaData> getGateDay(Date countDate) {
        return this.getResult(countDate, "select DISTINCT gate_id as orgId,countdate as countDate from d_gate_day_face_recognition_sta where countdate = ?;");
    }

    public List<FaceStaData> getGateHour(Date countDate) {
        return this.getResult(countDate, "select DISTINCT gate_id as orgId,countdate as countDate,counttime as countTime from d_gate_hour_face_recognition_sta where countdate = ?;");
    }

    public List<FaceStaData> getZoneDay(Date countDate) {
        return this.getResult(countDate, "select DISTINCT zone_id as orgId,countdate as countDate from d_zone_day_face_recognition_sta where countdate = ?;");
    }

    public List<FaceStaData> getZoneHour(Date countDate) {
        return this.getResult(countDate, "select DISTINCT zone_id as orgId,countdate as countDate,counttime as countTime from d_zone_hour_face_recognition_sta where countdate = ?;");
    }

    public List<FaceStaData> getFloorDay(Date countDate) {
        return this.getResult(countDate, "select DISTINCT floor_id as orgId,countdate as countDate from d_floor_day_face_recognition_sta where countdate = ?;");
    }

    public List<FaceStaData> getFloorHour(Date countDate) {
        return this.getResult(countDate, "select DISTINCT floor_id as orgId,countdate as countDate,counttime as countTime from d_floor_hour_face_recognition_sta where countdate = ?;");
    }

    public List<FaceStaData> getMallDay(Date countDate) {
        return this.getResult(countDate, "select DISTINCT mall_id as orgId,countdate as countDate from d_mall_day_face_recognition_sta where countdate = ?;");
    }

    public List<FaceStaData> getMallHour(Date countDate) {
        return this.getResult(countDate, "select DISTINCT mall_id as orgId,countdate as countDate,counttime as countTime from d_mall_hour_face_recognition_sta where countdate = ?;");
    }

    private List<FaceStaData> getResult(Date countDate, String sql) {
        return this.jdbcTemplate.query(sql, new Object[]{countDate}, (RowMapper)this.mapper);
    }
}

