/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.dao;

import com.viontech.keliu.content.FaceDataContent;
import com.viontech.keliu.util.DateUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class FaceDataDao {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private final String SQL_INSERT = "INSERT INTO d_face_recognition_raw (person_unid, device_serialnum, channel_serialnum, face_pic1, face_pic2, face_pic3, body_pic, showbody_pic, mood, age, gender, direction,counttime,countdate) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?);";

    public boolean insert(FaceDataContent faceData) {
        try {
            int update = this.jdbcTemplate.update("INSERT INTO d_face_recognition_raw (person_unid, device_serialnum, channel_serialnum, face_pic1, face_pic2, face_pic3, body_pic, showbody_pic, mood, age, gender, direction,counttime,countdate) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?);", this.toObject(faceData));
            if (update > 0) {
                return true;
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return false;
    }

    public List<FaceDataContent> insertBatch(List<FaceDataContent> faceDatas) {
        if (faceDatas.size() < 0) {
            return null;
        }
        if (faceDatas.size() == 1) {
            if (this.insert(faceDatas.get(0))) {
                return null;
            }
            return faceDatas;
        }
        ArrayList<Object[]> batchArgs = new ArrayList<Object[]>();
        ArrayList<FaceDataContent> errorObject = new ArrayList<FaceDataContent>();
        for (FaceDataContent countData : faceDatas) {
            try {
                batchArgs.add(this.toObject(countData));
            }
            catch (ParseException e) {
                errorObject.add(countData);
            }
        }
        int[] batchUpdate = this.jdbcTemplate.batchUpdate("INSERT INTO d_face_recognition_raw (person_unid, device_serialnum, channel_serialnum, face_pic1, face_pic2, face_pic3, body_pic, showbody_pic, mood, age, gender, direction,counttime,countdate) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?);", batchArgs);
        return null;
    }

    private Object[] toObject(FaceDataContent faceData) throws ParseException {
        String[] faceImageNames = faceData.getFaceImageName();
        if (faceImageNames == null) {
            faceImageNames = new String[]{null, null, null};
        } else {
            String[] tempImageNames = new String[3];
            for (int i = 0; i < faceImageNames.length; ++i) {
                tempImageNames[i] = faceImageNames[i];
            }
            faceImageNames = tempImageNames;
        }
        Date date = DateUtil.parse((String)DateUtil.FORMAT_LONG, (String)faceData.getStartTime());
        return new Object[]{faceData.getPersonId(), faceData.getVasId(), faceData.getVasId() + "-" + faceData.getChannelNo(), faceImageNames[0], faceImageNames[1], faceImageNames[2], faceData.getBodyImageName()[0], faceData.getShowBodyImageName()[0], faceData.getMood(), faceData.getAge(), faceData.getGender(), faceData.getDirection(), date, date};
    }
}

