/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.dao;

import com.viontech.keliu.model.Device;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class DeviceDao {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private final String SQL_SELECT = "select id,serialnum,mall_id,account_id,status from b_device;";
    private final String SQL_SELECT_BYSERIALNUM = "select id,serialnum,mall_id,account_id,status from b_device where serialnum = ?;";
    private final String SQL_UPDATE_STATUS = "update b_device set status = ? where id = ?;";

    public List<Device> selectAll() {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(Device.class);
        List devices = this.jdbcTemplate.query("select id,serialnum,mall_id,account_id,status from b_device;", (RowMapper)rowMapper);
        return devices;
    }

    public Device selectBySerialnum(String serialnum) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(Device.class);
        List devices = this.jdbcTemplate.query("select id,serialnum,mall_id,account_id,status from b_device where serialnum = ?;", (RowMapper)rowMapper, new Object[]{serialnum});
        if (devices.isEmpty()) {
            return null;
        }
        return (Device)devices.get(0);
    }

    public boolean updateDeviceStatus(Short status, Long id) {
        int update = this.jdbcTemplate.update("update b_device set status = ? where id = ?;", new Object[]{status, id});
        return update == 1;
    }
}

