/*
 * Decompiled with CFR 0.152.
 */
package com.viontech.keliu.dao;

import com.viontech.keliu.model.DbPerson;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class DbPersonDao {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private final String SQL_SELECT = "select id,person_unid,mall_id,type from b_person;";
    private final String SQL_SELECT_BYMALLID = "select id,person_unid,mall_id,type from b_person where mall_id =? and type =?;";
    private final String SQL_SELECT_BYMALLIDANDPERSONUNID = "select type from b_person where mall_id =? and person_unid =?;";

    public List<DbPerson> selectAll() {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(DbPerson.class);
        List dbPeoples = this.jdbcTemplate.query("select id,person_unid,mall_id,type from b_person;", (RowMapper)rowMapper);
        return dbPeoples;
    }

    public List<DbPerson> selectByMallIdAndType(Long mallId, Long type) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(DbPerson.class);
        List dbPeoples = this.jdbcTemplate.query("select id,person_unid,mall_id,type from b_person where mall_id =? and type =?;", (RowMapper)rowMapper, new Object[]{mallId, type});
        return dbPeoples;
    }

    public Integer selTypeByUnid(Long mallId, String personUnid) {
        BeanPropertyRowMapper rowMapper = new BeanPropertyRowMapper(DbPerson.class);
        List dbPeoples = this.jdbcTemplate.query("select type from b_person where mall_id =? and person_unid =?;", (RowMapper)rowMapper, new Object[]{mallId, personUnid});
        if (dbPeoples == null || dbPeoples.size() <= 0) {
            return 0;
        }
        return (int)((DbPerson)dbPeoples.get(0)).getType();
    }
}

